/*
 * Decompiled with CFR 0.152.
 */
package com.sonicether.soundphysics.config;

import com.sonicether.soundphysics.Loggers;
import de.maxhenkel.sound_physics_remastered.configbuilder.CommentedProperties;
import de.maxhenkel.sound_physics_remastered.configbuilder.CommentedPropertyConfig;
import java.io.IOException;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.class_2960;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_6880;
import net.minecraft.class_7923;

public class AllowedSoundConfig
extends CommentedPropertyConfig {
    private Map<String, Boolean> allowedSounds;

    public AllowedSoundConfig(Path path) {
        super(new CommentedProperties(false));
        this.path = path;
        this.reload();
    }

    @Override
    public void load() throws IOException {
        super.load();
        this.allowedSounds = this.createDefaultMap();
        for (Map.Entry<String, String> entry : this.properties.entrySet()) {
            boolean value;
            String key = entry.getKey();
            try {
                value = Boolean.parseBoolean(entry.getValue());
            }
            catch (Exception e) {
                Loggers.warn("Failed to set allowed sound entry {}", key);
                continue;
            }
            class_2960 resourceLocation = class_2960.method_12829((String)key);
            if (resourceLocation == null) {
                Loggers.warn("Failed to set allowed sound entry {}", key);
                continue;
            }
            if (!resourceLocation.method_12836().equals("voicechat")) {
                this.logIfUnknownSound(resourceLocation);
            }
            this.setAllowed(resourceLocation.toString(), value);
        }
        this.saveSync();
    }

    private void logIfUnknownSound(class_2960 resourceLocation) {
        try {
            class_3414 soundEvent = class_7923.field_41172.method_10223(resourceLocation).map(class_6880.class_6883::comp_349).orElse(null);
            if (soundEvent == null) {
                Loggers.log("Unknown sound in allowed sound config: {}", resourceLocation);
            }
        }
        catch (Exception e) {
            Loggers.warn("Failed to parse allowed sound entry {}", resourceLocation, e);
        }
    }

    @Override
    public void saveSync() {
        this.properties.clear();
        this.properties.addHeaderComment("Allowed sounds");
        this.properties.addHeaderComment("Set to 'false' to disable sound physics for that sound");
        for (Map.Entry<String, Boolean> entry : this.allowedSounds.entrySet()) {
            this.properties.set(entry.getKey(), String.valueOf(entry.getValue()), new String[0]);
        }
        super.saveSync();
    }

    public Map<String, Boolean> getAllowedSounds() {
        return this.allowedSounds;
    }

    public boolean isAllowed(String soundEvent) {
        return this.allowedSounds.getOrDefault(soundEvent, true);
    }

    public AllowedSoundConfig setAllowed(String soundEvent, boolean allowed) {
        this.allowedSounds.put(soundEvent, allowed);
        return this;
    }

    public Map<String, Boolean> createDefaultMap() {
        HashMap<String, Boolean> map = new HashMap<String, Boolean>();
        for (class_3414 event : class_7923.field_41172) {
            map.put(event.comp_3319().toString(), true);
        }
        map.put(class_3417.field_14946.comp_3319().toString(), false);
        map.put(class_3417.field_15020.comp_3319().toString(), false);
        map.put(class_3417.field_14865.comp_3319().toString(), false);
        class_3417.field_39028.forEach(r -> map.put(r.method_40237().method_29177().toString(), false));
        return map;
    }
}

