/*
 * Decompiled with CFR 0.152.
 */
package games.aquastudios.aquaclient.shaded.gson.internal.bind.util;

import java.text.ParseException;
import java.text.ParsePosition;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Locale;
import java.util.TimeZone;

public class ISO8601Utils {
    private static final String UTC_ID = "UTC";
    private static final TimeZone TIMEZONE_UTC = TimeZone.getTimeZone("UTC");

    public static String format(Date date) {
        return ISO8601Utils.format(date, false, TIMEZONE_UTC);
    }

    public static String format(Date date, boolean bl) {
        return ISO8601Utils.format(date, bl, TIMEZONE_UTC);
    }

    public static String format(Date date, boolean n, TimeZone timeZone) {
        GregorianCalendar gregorianCalendar = new GregorianCalendar(timeZone, Locale.US);
        gregorianCalendar.setTime(date);
        int n2 = 19;
        n2 = 19 + (n != 0 ? 4 : 0);
        StringBuilder stringBuilder = new StringBuilder(n2 += timeZone.getRawOffset() == 0 ? 1 : 6);
        ISO8601Utils.padInt(stringBuilder, gregorianCalendar.get(1), 4);
        stringBuilder.append('-');
        ISO8601Utils.padInt(stringBuilder, gregorianCalendar.get(2) + 1, 2);
        stringBuilder.append('-');
        ISO8601Utils.padInt(stringBuilder, gregorianCalendar.get(5), 2);
        stringBuilder.append('T');
        ISO8601Utils.padInt(stringBuilder, gregorianCalendar.get(11), 2);
        stringBuilder.append(':');
        ISO8601Utils.padInt(stringBuilder, gregorianCalendar.get(12), 2);
        stringBuilder.append(':');
        ISO8601Utils.padInt(stringBuilder, gregorianCalendar.get(13), 2);
        if (n != 0) {
            stringBuilder.append('.');
            ISO8601Utils.padInt(stringBuilder, gregorianCalendar.get(14), 3);
        }
        if ((n = timeZone.getOffset(gregorianCalendar.getTimeInMillis())) != 0) {
            int n3 = Math.abs(n / 60000 / 60);
            int n4 = Math.abs(n / 60000 % 60);
            stringBuilder.append(n < 0 ? (char)'-' : '+');
            ISO8601Utils.padInt(stringBuilder, n3, 2);
            stringBuilder.append(':');
            ISO8601Utils.padInt(stringBuilder, n4, 2);
        } else {
            stringBuilder.append('Z');
        }
        return stringBuilder.toString();
    }

    public static Date parse(String string, ParsePosition parsePosition) {
        RuntimeException runtimeException;
        RuntimeException runtimeException2;
        try {
            TimeZone timeZone;
            int n = parsePosition.getIndex();
            int n2 = ISO8601Utils.parseInt(string, n, n += 4);
            if (ISO8601Utils.checkOffset(string, n, '-')) {
                // empty if block
            }
            int n3 = ISO8601Utils.parseInt(string, ++n, n += 2);
            if (ISO8601Utils.checkOffset(string, n, '-')) {
                // empty if block
            }
            int n4 = ISO8601Utils.parseInt(string, ++n, n += 2);
            int n5 = 0;
            int n6 = 0;
            int n7 = 0;
            int n8 = 0;
            int n9 = ISO8601Utils.checkOffset(string, n, 'T');
            if (n9 == 0 && string.length() <= n) {
                GregorianCalendar gregorianCalendar = new GregorianCalendar(n2, n3 - 1, n4);
                parsePosition.setIndex(n);
                return gregorianCalendar.getTime();
            }
            if (n9 != 0) {
                n5 = ISO8601Utils.parseInt(string, ++n, n += 2);
                if (ISO8601Utils.checkOffset(string, n, ':')) {
                    // empty if block
                }
                n6 = ISO8601Utils.parseInt(string, ++n, n += 2);
                if (ISO8601Utils.checkOffset(string, n, ':')) {
                    ++n;
                }
                if (string.length() > n && (n9 = string.charAt(n)) != 90 && n9 != 43 && n9 != 45) {
                    if ((n7 = ISO8601Utils.parseInt(string, n, n += 2)) > 59 && n7 < 63) {
                        n7 = 59;
                    }
                    if (ISO8601Utils.checkOffset(string, n, '.')) {
                        n9 = ISO8601Utils.indexOfNonDigit(string, ++n + 1);
                        int n10 = Math.min(n9, n + 3);
                        int n11 = ISO8601Utils.parseInt(string, n, n10);
                        switch (n10 - n) {
                            case 2: {
                                n8 = n11 * 10;
                                break;
                            }
                            case 1: {
                                n8 = n11 * 100;
                                break;
                            }
                            default: {
                                n8 = n11;
                            }
                        }
                        n = n9;
                    }
                }
            }
            if (string.length() <= n) {
                throw new IllegalArgumentException("No time zone indicator");
            }
            n9 = string.charAt(n);
            if (n9 == 90) {
                timeZone = TIMEZONE_UTC;
                ++n;
            } else if (n9 == 43 || n9 == 45) {
                String string2 = string.substring(n);
                string2 = string2.length() >= 5 ? string2 : string2 + "00";
                n += string2.length();
                if ("+0000".equals(string2) || "+00:00".equals(string2)) {
                    timeZone = TIMEZONE_UTC;
                } else {
                    String string3 = "GMT" + string2;
                    timeZone = TimeZone.getTimeZone(string3);
                    if (!(string2 = timeZone.getID()).equals(string3) && !(string2 = string2.replace(":", "")).equals(string3)) {
                        throw new IndexOutOfBoundsException("Mismatching time zone indicator: " + string3 + " given, resolves to " + timeZone.getID());
                    }
                }
            } else {
                throw new IndexOutOfBoundsException("Invalid time zone indicator '" + (char)n9 + "'");
            }
            GregorianCalendar gregorianCalendar = new GregorianCalendar(timeZone);
            gregorianCalendar.setLenient(false);
            gregorianCalendar.set(1, n2);
            gregorianCalendar.set(2, n3 - 1);
            gregorianCalendar.set(5, n4);
            gregorianCalendar.set(11, n5);
            gregorianCalendar.set(12, n6);
            gregorianCalendar.set(13, n7);
            gregorianCalendar.set(14, n8);
            parsePosition.setIndex(n);
            return gregorianCalendar.getTime();
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            runtimeException2 = indexOutOfBoundsException;
            runtimeException = indexOutOfBoundsException;
        }
        catch (NumberFormatException numberFormatException) {
            runtimeException2 = numberFormatException;
            runtimeException = numberFormatException;
        }
        catch (IllegalArgumentException illegalArgumentException) {
            runtimeException2 = illegalArgumentException;
            runtimeException = illegalArgumentException;
        }
        runtimeException2 = string == null ? null : "\"" + string + '\"';
        String string4 = runtimeException.getMessage();
        if (string4 == null || string4.isEmpty()) {
            string4 = "(" + runtimeException.getClass().getName() + ")";
        }
        ParseException parseException = new ParseException("Failed to parse date [" + (String)((Object)runtimeException2) + "]: " + string4, parsePosition.getIndex());
        parseException.initCause(runtimeException);
        throw parseException;
    }

    private static boolean checkOffset(String string, int n, char c2) {
        return n < string.length() && string.charAt(n) == c2;
    }

    private static int parseInt(String string, int n, int n2) {
        int n3;
        if (n < 0 || n2 > string.length() || n > n2) {
            throw new NumberFormatException(string);
        }
        int n4 = n;
        int n5 = 0;
        if (n4 < n2) {
            if ((n3 = Character.digit(string.charAt(n4++), 10)) < 0) {
                throw new NumberFormatException("Invalid number: " + string.substring(n, n2));
            }
            n5 = -n3;
        }
        while (n4 < n2) {
            if ((n3 = Character.digit(string.charAt(n4++), 10)) < 0) {
                throw new NumberFormatException("Invalid number: " + string.substring(n, n2));
            }
            n5 *= 10;
            n5 -= n3;
        }
        return -n5;
    }

    private static void padInt(StringBuilder stringBuilder, int n, int n2) {
        String string = Integer.toString(n);
        n2 -= string.length();
        while (n2 > 0) {
            stringBuilder.append('0');
            --n2;
        }
        stringBuilder.append(string);
    }

    private static int indexOfNonDigit(String string, int n) {
        while (n < string.length()) {
            char c2 = string.charAt(n);
            if (c2 < '0' || c2 > '9') {
                return n;
            }
            ++n;
        }
        return string.length();
    }
}

