/*
 * Decompiled with CFR 0.152.
 */
package games.aquastudios.aquaclient.shaded.gson.internal.bind;

import games.aquastudios.aquaclient.shaded.gson.JsonArray;
import games.aquastudios.aquaclient.shaded.gson.JsonElement;
import games.aquastudios.aquaclient.shaded.gson.JsonNull;
import games.aquastudios.aquaclient.shaded.gson.JsonObject;
import games.aquastudios.aquaclient.shaded.gson.JsonPrimitive;
import games.aquastudios.aquaclient.shaded.gson.internal.bind.JsonTreeWriter$1;
import games.aquastudios.aquaclient.shaded.gson.stream.JsonWriter;
import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.List;

public final class JsonTreeWriter
extends JsonWriter {
    private static final Writer UNWRITABLE_WRITER = new JsonTreeWriter$1();
    private static final JsonPrimitive SENTINEL_CLOSED = new JsonPrimitive("closed");
    private final List<JsonElement> stack = new ArrayList<JsonElement>();
    private String pendingName;
    private JsonElement product = JsonNull.INSTANCE;

    public JsonTreeWriter() {
        super(UNWRITABLE_WRITER);
    }

    public final JsonElement get() {
        if (!this.stack.isEmpty()) {
            throw new IllegalStateException("Expected one JSON element but was " + this.stack);
        }
        return this.product;
    }

    private JsonElement peek() {
        return this.stack.get(this.stack.size() - 1);
    }

    private void put(JsonElement jsonElement) {
        if (this.pendingName != null) {
            if (!jsonElement.isJsonNull() || this.getSerializeNulls()) {
                JsonObject jsonObject = (JsonObject)this.peek();
                jsonObject.add(this.pendingName, jsonElement);
            }
            this.pendingName = null;
            return;
        }
        if (this.stack.isEmpty()) {
            this.product = jsonElement;
            return;
        }
        JsonElement jsonElement2 = this.peek();
        if (jsonElement2 instanceof JsonArray) {
            ((JsonArray)jsonElement2).add(jsonElement);
            return;
        }
        throw new IllegalStateException();
    }

    @Override
    public final JsonWriter beginArray() {
        JsonArray jsonArray = new JsonArray();
        this.put(jsonArray);
        this.stack.add(jsonArray);
        return this;
    }

    @Override
    public final JsonWriter endArray() {
        if (this.stack.isEmpty() || this.pendingName != null) {
            throw new IllegalStateException();
        }
        JsonElement jsonElement = this.peek();
        if (jsonElement instanceof JsonArray) {
            this.stack.remove(this.stack.size() - 1);
            return this;
        }
        throw new IllegalStateException();
    }

    @Override
    public final JsonWriter beginObject() {
        JsonObject jsonObject = new JsonObject();
        this.put(jsonObject);
        this.stack.add(jsonObject);
        return this;
    }

    @Override
    public final JsonWriter endObject() {
        if (this.stack.isEmpty() || this.pendingName != null) {
            throw new IllegalStateException();
        }
        JsonElement jsonElement = this.peek();
        if (jsonElement instanceof JsonObject) {
            this.stack.remove(this.stack.size() - 1);
            return this;
        }
        throw new IllegalStateException();
    }

    @Override
    public final JsonWriter name(String string) {
        if (string == null) {
            throw new NullPointerException("name == null");
        }
        if (this.stack.isEmpty() || this.pendingName != null) {
            throw new IllegalStateException();
        }
        JsonElement jsonElement = this.peek();
        if (jsonElement instanceof JsonObject) {
            this.pendingName = string;
            return this;
        }
        throw new IllegalStateException();
    }

    @Override
    public final JsonWriter value(String string) {
        if (string == null) {
            return ((JsonWriter)this).nullValue();
        }
        this.put(new JsonPrimitive(string));
        return this;
    }

    @Override
    public final JsonWriter nullValue() {
        this.put(JsonNull.INSTANCE);
        return this;
    }

    @Override
    public final JsonWriter value(boolean bl) {
        this.put(new JsonPrimitive(bl));
        return this;
    }

    @Override
    public final JsonWriter value(Boolean bl) {
        if (bl == null) {
            return ((JsonWriter)this).nullValue();
        }
        this.put(new JsonPrimitive(bl));
        return this;
    }

    @Override
    public final JsonWriter value(double d2) {
        if (!this.isLenient() && (Double.isNaN(d2) || Double.isInfinite(d2))) {
            throw new IllegalArgumentException("JSON forbids NaN and infinities: " + d2);
        }
        this.put(new JsonPrimitive(d2));
        return this;
    }

    @Override
    public final JsonWriter value(long l) {
        this.put(new JsonPrimitive(l));
        return this;
    }

    @Override
    public final JsonWriter value(Number number) {
        double d2;
        if (number == null) {
            return ((JsonWriter)this).nullValue();
        }
        if (!this.isLenient() && (Double.isNaN(d2 = number.doubleValue()) || Double.isInfinite(d2))) {
            throw new IllegalArgumentException("JSON forbids NaN and infinities: " + number);
        }
        this.put(new JsonPrimitive(number));
        return this;
    }

    @Override
    public final void flush() {
    }

    @Override
    public final void close() {
        if (!this.stack.isEmpty()) {
            throw new IOException("Incomplete document");
        }
        this.stack.add(SENTINEL_CLOSED);
    }
}

