/*
 * Decompiled with CFR 0.152.
 */
package games.aquastudios.aquaclient.shaded.gson.internal.bind;

import games.aquastudios.aquaclient.shaded.gson.JsonSyntaxException;
import games.aquastudios.aquaclient.shaded.gson.TypeAdapter;
import games.aquastudios.aquaclient.shaded.gson.TypeAdapterFactory;
import games.aquastudios.aquaclient.shaded.gson.internal.JavaVersion;
import games.aquastudios.aquaclient.shaded.gson.internal.PreJava9DateFormatProvider;
import games.aquastudios.aquaclient.shaded.gson.internal.bind.DateTypeAdapter$1;
import games.aquastudios.aquaclient.shaded.gson.internal.bind.util.ISO8601Utils;
import games.aquastudios.aquaclient.shaded.gson.stream.JsonReader;
import games.aquastudios.aquaclient.shaded.gson.stream.JsonToken;
import games.aquastudios.aquaclient.shaded.gson.stream.JsonWriter;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.ParsePosition;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Locale;

public final class DateTypeAdapter
extends TypeAdapter<Date> {
    public static final TypeAdapterFactory FACTORY = new DateTypeAdapter$1();
    private final List<DateFormat> dateFormats = new ArrayList<DateFormat>();

    public DateTypeAdapter() {
        this.dateFormats.add(DateFormat.getDateTimeInstance(2, 2, Locale.US));
        if (!Locale.getDefault().equals(Locale.US)) {
            this.dateFormats.add(DateFormat.getDateTimeInstance(2, 2));
        }
        if (JavaVersion.isJava9OrLater()) {
            this.dateFormats.add(PreJava9DateFormatProvider.getUSDateTimeFormat(2, 2));
        }
    }

    @Override
    public final Date read(JsonReader jsonReader) {
        if (jsonReader.peek() == JsonToken.NULL) {
            jsonReader.nextNull();
            return null;
        }
        return this.deserializeToDate(jsonReader.nextString());
    }

    private synchronized Date deserializeToDate(String string) {
        for (DateFormat dateFormat : this.dateFormats) {
            try {
                return dateFormat.parse(string);
            }
            catch (ParseException parseException) {
            }
        }
        try {
            return ISO8601Utils.parse(string, new ParsePosition(0));
        }
        catch (ParseException parseException) {
            throw new JsonSyntaxException(string, parseException);
        }
    }

    @Override
    public final synchronized void write(JsonWriter jsonWriter, Date object) {
        if (object == null) {
            jsonWriter.nullValue();
            return;
        }
        object = this.dateFormats.get(0).format((Date)object);
        jsonWriter.value((String)object);
    }
}

