/*
 * Decompiled with CFR 0.152.
 */
package games.aquastudios.aquaclient.shaded.gson;

import games.aquastudios.aquaclient.shaded.gson.JsonElement;
import games.aquastudios.aquaclient.shaded.gson.JsonIOException;
import games.aquastudios.aquaclient.shaded.gson.JsonParseException;
import games.aquastudios.aquaclient.shaded.gson.JsonSyntaxException;
import games.aquastudios.aquaclient.shaded.gson.internal.Streams;
import games.aquastudios.aquaclient.shaded.gson.stream.JsonReader;
import games.aquastudios.aquaclient.shaded.gson.stream.JsonToken;
import games.aquastudios.aquaclient.shaded.gson.stream.MalformedJsonException;
import java.io.EOFException;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.Iterator;
import java.util.NoSuchElementException;

public final class JsonStreamParser
implements Iterator<JsonElement> {
    private final JsonReader parser;
    private final Object lock;

    public JsonStreamParser(String string) {
        this(new StringReader(string));
    }

    public JsonStreamParser(Reader reader) {
        this.parser = new JsonReader(reader);
        this.parser.setLenient(true);
        this.lock = new Object();
    }

    @Override
    public final JsonElement next() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        try {
            return Streams.parse(this.parser);
        }
        catch (StackOverflowError stackOverflowError) {
            throw new JsonParseException("Failed parsing JSON source to Json", stackOverflowError);
        }
        catch (OutOfMemoryError outOfMemoryError) {
            throw new JsonParseException("Failed parsing JSON source to Json", outOfMemoryError);
        }
        catch (JsonParseException jsonParseException) {
            JsonParseException jsonParseException2 = jsonParseException;
            throw jsonParseException.getCause() instanceof EOFException ? new NoSuchElementException() : jsonParseException2;
        }
    }

    @Override
    public final boolean hasNext() {
        Object object = this.lock;
        synchronized (object) {
            try {
                return this.parser.peek() != JsonToken.END_DOCUMENT;
            }
            catch (MalformedJsonException malformedJsonException) {
                throw new JsonSyntaxException(malformedJsonException);
            }
            catch (IOException iOException) {
                throw new JsonIOException(iOException);
            }
        }
    }

    @Override
    public final void remove() {
        throw new UnsupportedOperationException();
    }
}

