/*
 * Decompiled with CFR 0.152.
 */
package games.aquastudios.aquaclient.shaded.gson;

import games.aquastudios.aquaclient.shaded.gson.JsonElement;
import games.aquastudios.aquaclient.shaded.gson.internal.$Gson$Preconditions;
import games.aquastudios.aquaclient.shaded.gson.internal.LazilyParsedNumber;
import java.math.BigDecimal;
import java.math.BigInteger;

public final class JsonPrimitive
extends JsonElement {
    private final Object value;

    public JsonPrimitive(Boolean bl) {
        this.value = $Gson$Preconditions.checkNotNull(bl);
    }

    public JsonPrimitive(Number number) {
        this.value = $Gson$Preconditions.checkNotNull(number);
    }

    public JsonPrimitive(String string) {
        this.value = $Gson$Preconditions.checkNotNull(string);
    }

    public JsonPrimitive(Character c2) {
        this.value = $Gson$Preconditions.checkNotNull(c2).toString();
    }

    @Override
    public final JsonPrimitive deepCopy() {
        return this;
    }

    public final boolean isBoolean() {
        return this.value instanceof Boolean;
    }

    @Override
    public final boolean getAsBoolean() {
        if (this.isBoolean()) {
            return (Boolean)this.value;
        }
        return Boolean.parseBoolean(((JsonElement)this).getAsString());
    }

    public final boolean isNumber() {
        return this.value instanceof Number;
    }

    @Override
    public final Number getAsNumber() {
        if (this.value instanceof String) {
            return new LazilyParsedNumber((String)this.value);
        }
        return (Number)this.value;
    }

    public final boolean isString() {
        return this.value instanceof String;
    }

    @Override
    public final String getAsString() {
        if (this.isNumber()) {
            return ((JsonElement)this).getAsNumber().toString();
        }
        if (this.isBoolean()) {
            return ((Boolean)this.value).toString();
        }
        return (String)this.value;
    }

    @Override
    public final double getAsDouble() {
        if (this.isNumber()) {
            return ((JsonElement)this).getAsNumber().doubleValue();
        }
        return Double.parseDouble(((JsonElement)this).getAsString());
    }

    @Override
    public final BigDecimal getAsBigDecimal() {
        if (this.value instanceof BigDecimal) {
            return (BigDecimal)this.value;
        }
        return new BigDecimal(this.value.toString());
    }

    @Override
    public final BigInteger getAsBigInteger() {
        if (this.value instanceof BigInteger) {
            return (BigInteger)this.value;
        }
        return new BigInteger(this.value.toString());
    }

    @Override
    public final float getAsFloat() {
        if (this.isNumber()) {
            return ((JsonElement)this).getAsNumber().floatValue();
        }
        return Float.parseFloat(((JsonElement)this).getAsString());
    }

    @Override
    public final long getAsLong() {
        if (this.isNumber()) {
            return ((JsonElement)this).getAsNumber().longValue();
        }
        return Long.parseLong(((JsonElement)this).getAsString());
    }

    @Override
    public final short getAsShort() {
        if (this.isNumber()) {
            return ((JsonElement)this).getAsNumber().shortValue();
        }
        return Short.parseShort(((JsonElement)this).getAsString());
    }

    @Override
    public final int getAsInt() {
        if (this.isNumber()) {
            return ((JsonElement)this).getAsNumber().intValue();
        }
        return Integer.parseInt(((JsonElement)this).getAsString());
    }

    @Override
    public final byte getAsByte() {
        if (this.isNumber()) {
            return ((JsonElement)this).getAsNumber().byteValue();
        }
        return Byte.parseByte(((JsonElement)this).getAsString());
    }

    @Override
    public final char getAsCharacter() {
        return ((JsonElement)this).getAsString().charAt(0);
    }

    public final int hashCode() {
        if (this.value == null) {
            return 31;
        }
        if (JsonPrimitive.isIntegral(this)) {
            long l = ((JsonElement)this).getAsNumber().longValue();
            return (int)(l ^ l >>> 32);
        }
        if (this.value instanceof Number) {
            long l = Double.doubleToLongBits(((JsonElement)this).getAsNumber().doubleValue());
            return (int)(l ^ l >>> 32);
        }
        return this.value.hashCode();
    }

    public final boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        object = (JsonPrimitive)object;
        if (this.value == null) {
            return ((JsonPrimitive)object).value == null;
        }
        if (JsonPrimitive.isIntegral(this) && JsonPrimitive.isIntegral((JsonPrimitive)object)) {
            return ((JsonElement)this).getAsNumber().longValue() == ((JsonElement)object).getAsNumber().longValue();
        }
        if (this.value instanceof Number && ((JsonPrimitive)object).value instanceof Number) {
            double d2;
            double d3 = ((JsonElement)this).getAsNumber().doubleValue();
            return d3 == (d2 = ((JsonElement)object).getAsNumber().doubleValue()) || Double.isNaN(d3) && Double.isNaN(d2);
        }
        return this.value.equals(((JsonPrimitive)object).value);
    }

    private static boolean isIntegral(JsonPrimitive object) {
        if (((JsonPrimitive)object).value instanceof Number) {
            object = (Number)((JsonPrimitive)object).value;
            return object instanceof BigInteger || object instanceof Long || object instanceof Integer || object instanceof Short || object instanceof Byte;
        }
        return false;
    }
}

