/*
 * Decompiled with CFR 0.152.
 */
package games.aquastudios.aquaclient.shaded.gson;

import games.aquastudios.aquaclient.shaded.gson.JsonSyntaxException;
import games.aquastudios.aquaclient.shaded.gson.TypeAdapter;
import games.aquastudios.aquaclient.shaded.gson.internal.JavaVersion;
import games.aquastudios.aquaclient.shaded.gson.internal.PreJava9DateFormatProvider;
import games.aquastudios.aquaclient.shaded.gson.internal.bind.util.ISO8601Utils;
import games.aquastudios.aquaclient.shaded.gson.stream.JsonReader;
import games.aquastudios.aquaclient.shaded.gson.stream.JsonToken;
import games.aquastudios.aquaclient.shaded.gson.stream.JsonWriter;
import java.sql.Date;
import java.sql.Timestamp;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.ParsePosition;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;

final class DefaultDateTypeAdapter
extends TypeAdapter<java.util.Date> {
    private static final String SIMPLE_NAME = "DefaultDateTypeAdapter";
    private final Class<? extends java.util.Date> dateType;
    private final List<DateFormat> dateFormats = new ArrayList<DateFormat>();

    DefaultDateTypeAdapter(Class<? extends java.util.Date> clazz) {
        this.dateType = DefaultDateTypeAdapter.verifyDateType(clazz);
        this.dateFormats.add(DateFormat.getDateTimeInstance(2, 2, Locale.US));
        if (!Locale.getDefault().equals(Locale.US)) {
            this.dateFormats.add(DateFormat.getDateTimeInstance(2, 2));
        }
        if (JavaVersion.isJava9OrLater()) {
            this.dateFormats.add(PreJava9DateFormatProvider.getUSDateTimeFormat(2, 2));
        }
    }

    DefaultDateTypeAdapter(Class<? extends java.util.Date> clazz, String string) {
        this.dateType = DefaultDateTypeAdapter.verifyDateType(clazz);
        this.dateFormats.add(new SimpleDateFormat(string, Locale.US));
        if (!Locale.getDefault().equals(Locale.US)) {
            this.dateFormats.add(new SimpleDateFormat(string));
        }
    }

    DefaultDateTypeAdapter(Class<? extends java.util.Date> clazz, int n) {
        this.dateType = DefaultDateTypeAdapter.verifyDateType(clazz);
        this.dateFormats.add(DateFormat.getDateInstance(n, Locale.US));
        if (!Locale.getDefault().equals(Locale.US)) {
            this.dateFormats.add(DateFormat.getDateInstance(n));
        }
        if (JavaVersion.isJava9OrLater()) {
            this.dateFormats.add(PreJava9DateFormatProvider.getUSDateFormat(n));
        }
    }

    public DefaultDateTypeAdapter(int n, int n2) {
        this(java.util.Date.class, n, n2);
    }

    public DefaultDateTypeAdapter(Class<? extends java.util.Date> clazz, int n, int n2) {
        this.dateType = DefaultDateTypeAdapter.verifyDateType(clazz);
        this.dateFormats.add(DateFormat.getDateTimeInstance(n, n2, Locale.US));
        if (!Locale.getDefault().equals(Locale.US)) {
            this.dateFormats.add(DateFormat.getDateTimeInstance(n, n2));
        }
        if (JavaVersion.isJava9OrLater()) {
            this.dateFormats.add(PreJava9DateFormatProvider.getUSDateTimeFormat(n, n2));
        }
    }

    private static Class<? extends java.util.Date> verifyDateType(Class<? extends java.util.Date> clazz) {
        if (clazz != java.util.Date.class && clazz != Date.class && clazz != Timestamp.class) {
            throw new IllegalArgumentException("Date type must be one of " + java.util.Date.class + ", " + Timestamp.class + ", or " + Date.class + " but was " + clazz);
        }
        return clazz;
    }

    @Override
    public final void write(JsonWriter jsonWriter, java.util.Date object) {
        if (object == null) {
            jsonWriter.nullValue();
            return;
        }
        List<DateFormat> list = this.dateFormats;
        synchronized (list) {
            object = this.dateFormats.get(0).format((java.util.Date)object);
            jsonWriter.value((String)object);
            return;
        }
    }

    @Override
    public final java.util.Date read(JsonReader object) {
        if (((JsonReader)object).peek() == JsonToken.NULL) {
            ((JsonReader)object).nextNull();
            return null;
        }
        object = this.deserializeToDate(((JsonReader)object).nextString());
        if (this.dateType == java.util.Date.class) {
            return object;
        }
        if (this.dateType == Timestamp.class) {
            return new Timestamp(((java.util.Date)object).getTime());
        }
        if (this.dateType == Date.class) {
            return new Date(((java.util.Date)object).getTime());
        }
        throw new AssertionError();
    }

    private java.util.Date deserializeToDate(String string) {
        List<DateFormat> list = this.dateFormats;
        synchronized (list) {
            for (DateFormat dateFormat : this.dateFormats) {
                try {
                    return dateFormat.parse(string);
                }
                catch (ParseException parseException) {
                }
            }
            try {
                return ISO8601Utils.parse(string, new ParsePosition(0));
            }
            catch (ParseException parseException) {
                throw new JsonSyntaxException(string, parseException);
            }
        }
    }

    public final String toString() {
        DateFormat dateFormat = this.dateFormats.get(0);
        if (dateFormat instanceof SimpleDateFormat) {
            return "DefaultDateTypeAdapter(" + ((SimpleDateFormat)dateFormat).toPattern() + ')';
        }
        return "DefaultDateTypeAdapter(" + dateFormat.getClass().getSimpleName() + ')';
    }
}

