/*
 * Decompiled with CFR 0.152.
 */
package games.aquastudios.aquaclient.shaded.discordgamesdk.pipe;

import games.aquastudios.aquaclient.shaded.discordgamesdk.DiscordPacket;
import games.aquastudios.aquaclient.shaded.discordgamesdk.DiscordPacket$OpCode;
import games.aquastudios.aquaclient.shaded.discordgamesdk.DiscordRPCClient;
import games.aquastudios.aquaclient.shaded.discordgamesdk.exceptions.NoDiscordException;
import games.aquastudios.aquaclient.shaded.discordgamesdk.pipe.Pipe;
import games.aquastudios.aquaclient.shaded.gson.JsonObject;
import games.aquastudios.aquaclient.shaded.javax.annotation.Nonnull;
import games.aquastudios.aquaclient.shaded.slf4j.Logger;
import games.aquastudios.aquaclient.shaded.slf4j.LoggerFactory;
import java.io.File;
import java.io.IOException;
import java.net.StandardProtocolFamily;
import java.net.UnixDomainSocketAddress;
import java.nio.ByteBuffer;
import java.nio.channels.SocketChannel;
import java.nio.charset.StandardCharsets;

public class UnixPipe
implements Pipe {
    private final SocketChannel socket;

    public UnixPipe() {
        Logger logger = LoggerFactory.getLogger(UnixPipe.class);
        try {
            this.socket = SocketChannel.open(StandardProtocolFamily.UNIX);
        }
        catch (IOException iOException) {
            throw new NoDiscordException("Failed to open socket", iOException);
        }
        String[] stringArray = new String[]{"XDG_RUNTIME_DIR", "TMPDIR", "TMP", "TEMP"};
        String string = null;
        int cfr_ignored_0 = stringArray.length;
        for (int i2 = 0; i2 < 4; ++i2) {
            string = stringArray[i2];
            if ((string = System.getenv(string)) != null) break;
        }
        if (string == null) {
            string = "/tmp";
        }
        for (int i3 = 0; i3 < 10; ++i3) {
            File file = new File(string + "/discord-ipc-" + i3);
            if (!file.exists()) continue;
            try {
                this.socket.connect(UnixDomainSocketAddress.of(file.getCanonicalPath()));
                break;
            }
            catch (IOException iOException) {
                logger.debug("IOException while binding socket " + i3, iOException);
            }
        }
        if (!this.socket.isConnected()) {
            throw new NoDiscordException("Discord client not found");
        }
    }

    @Override
    public void write(byte[] byArray) {
        this.socket.write(ByteBuffer.wrap(byArray));
    }

    @Override
    @Nonnull
    public DiscordPacket read() {
        ByteBuffer byteBuffer = ByteBuffer.allocate(8);
        this.socket.read(byteBuffer);
        byteBuffer.flip();
        DiscordPacket$OpCode discordPacket$OpCode = DiscordPacket$OpCode.values()[Integer.reverseBytes(byteBuffer.getInt())];
        int n = Integer.reverseBytes(byteBuffer.getInt());
        ByteBuffer byteBuffer2 = ByteBuffer.allocate(n);
        this.socket.read(byteBuffer2);
        return new DiscordPacket(discordPacket$OpCode, DiscordRPCClient.GSON.fromJson(new String(byteBuffer2.flip().array(), StandardCharsets.UTF_8), JsonObject.class));
    }

    @Override
    public void close() {
        this.socket.close();
    }
}

