/*
 * Decompiled with CFR 0.152.
 */
package games.aquastudios.aquaclient.shaded.discordgamesdk;

import games.aquastudios.aquaclient.shaded.discordgamesdk.DiscordPacket;
import games.aquastudios.aquaclient.shaded.discordgamesdk.DiscordPacket$OpCode;
import games.aquastudios.aquaclient.shaded.discordgamesdk.ErrorEvent;
import games.aquastudios.aquaclient.shaded.discordgamesdk.EventListener;
import games.aquastudios.aquaclient.shaded.discordgamesdk.RichPresence;
import games.aquastudios.aquaclient.shaded.discordgamesdk.User;
import games.aquastudios.aquaclient.shaded.discordgamesdk.exceptions.DiscordException;
import games.aquastudios.aquaclient.shaded.discordgamesdk.exceptions.NotConnectedException;
import games.aquastudios.aquaclient.shaded.discordgamesdk.pipe.Pipe;
import games.aquastudios.aquaclient.shaded.discordgamesdk.pipe.UnixPipe;
import games.aquastudios.aquaclient.shaded.discordgamesdk.pipe.WindowsPipe;
import games.aquastudios.aquaclient.shaded.gson.Gson;
import games.aquastudios.aquaclient.shaded.gson.JsonElement;
import games.aquastudios.aquaclient.shaded.gson.JsonObject;
import games.aquastudios.aquaclient.shaded.javax.annotation.Nonnull;
import games.aquastudios.aquaclient.shaded.javax.annotation.Nullable;
import java.io.IOException;
import java.nio.BufferUnderflowException;
import java.nio.channels.AsynchronousCloseException;

public class DiscordRPCClient {
    @Nonnull
    public static final Gson GSON = new Gson();
    private final boolean isWindows = System.getProperty("os.name").toLowerCase().contains("win");
    private final String appId;
    private volatile Pipe pipe = null;
    public volatile boolean isConnected = false;
    @Nullable
    public volatile EventListener listeners;

    public DiscordRPCClient(@Nullable EventListener eventListener, @Nonnull String string) {
        this.listeners = eventListener;
        this.appId = string;
    }

    public DiscordRPCClient(@Nonnull String string) {
        this(null, string);
    }

    private void close() {
        this.isConnected = false;
        try {
            this.pipe.close();
            EventListener eventListener = this.listeners;
            if (eventListener != null) {
                eventListener.onClose(this);
            }
            return;
        }
        catch (IOException iOException) {
            throw new DiscordException("Failed to close DiscordRPC pipe, something may go very wrong", iOException);
        }
    }

    private void sendMessage(JsonObject jsonObject) {
        if (!this.isConnected) {
            throw new NotConnectedException("Tried to send message");
        }
        try {
            this.pipe.send(DiscordPacket$OpCode.MESSAGE, jsonObject);
            return;
        }
        catch (IOException iOException) {
            EventListener eventListener = this.listeners;
            if (eventListener != null) {
                eventListener.onError(this, iOException, null);
            }
            return;
        }
    }

    public void connect() {
        this.pipe = this.isWindows ? new WindowsPipe(this) : new UnixPipe();
        try {
            JsonObject jsonObject = new JsonObject();
            jsonObject.addProperty("v", 1);
            jsonObject.addProperty("client_id", this.appId);
            this.pipe.send(DiscordPacket$OpCode.HANDSHAKE, jsonObject);
            this.isConnected = true;
            new Thread(() -> {
                while (this.isConnected) {
                    Object object;
                    try {
                        Object object2 = this.pipe.read();
                        if (object2 == null) {
                            return;
                        }
                        if (((DiscordPacket)object2).opCode() == DiscordPacket$OpCode.CLOSE) {
                            this.close();
                            return;
                        }
                        object = ((DiscordPacket)object2).json();
                        if ((object2 = ((JsonObject)object).get("evt")) != null && !((JsonElement)object2).isJsonNull()) {
                            object = ((JsonObject)object).get("data").getAsJsonObject();
                            EventListener eventListener = this.listeners;
                            if (eventListener != null) {
                                switch (((JsonElement)object2).getAsString()) {
                                    case "READY": {
                                        eventListener.onReady(this, GSON.fromJson(((JsonObject)object).get("user"), User.class));
                                        break;
                                    }
                                    case "ERROR": {
                                        eventListener.onError(this, null, GSON.fromJson((JsonElement)object, ErrorEvent.class));
                                        break;
                                    }
                                    case "ACTIVITY_JOIN": {
                                        eventListener.onActivityJoin(this, ((JsonObject)object).get("secret").getAsString());
                                        break;
                                    }
                                    case "ACTIVITY_SPECTATE": {
                                        eventListener.onActivitySpectate(this, ((JsonObject)object).get("secret").getAsString());
                                        break;
                                    }
                                    case "ACTIVITY_JOIN_REQUEST": {
                                        eventListener.onActivityJoinRequest(this, GSON.fromJson(((JsonObject)object).get("user"), User.class));
                                    }
                                }
                            }
                        }
                    }
                    catch (BufferUnderflowException | AsynchronousCloseException exception) {
                        this.isConnected = false;
                        return;
                    }
                    catch (IOException iOException) {
                        object = this.listeners;
                        if (object != null) {
                            object.onError(this, iOException, null);
                        }
                        this.close();
                    }
                }
            }, "DiscordRPC Read Thread").start();
            return;
        }
        catch (IOException iOException) {
            EventListener eventListener = this.listeners;
            if (eventListener != null) {
                eventListener.onError(this, iOException, null);
            }
            this.close();
            return;
        }
    }

    public void sendPresence(@Nonnull RichPresence richPresence) {
        JsonObject jsonObject = new JsonObject();
        jsonObject.addProperty("cmd", "SET_ACTIVITY");
        JsonObject jsonObject2 = new JsonObject();
        jsonObject2.addProperty("pid", ProcessHandle.current().pid());
        jsonObject2.add("activity", GSON.toJsonTree(richPresence));
        jsonObject.add("args", jsonObject2);
        this.sendMessage(jsonObject);
    }

    public void disconnect() {
        if (!this.isConnected) {
            throw new NotConnectedException("Tried to disconnect");
        }
        this.close();
    }

    public void respond(String string, boolean bl) {
        JsonObject jsonObject = new JsonObject();
        jsonObject.addProperty("cmd", bl ? "SEND_ACTIVITY_JOIN_INVITE" : "CLOSE_ACTIVITY_REQUEST");
        jsonObject.addProperty("user_id", string);
        this.sendMessage(jsonObject);
    }
}

