/*
 * Decompiled with CFR 0.152.
 */
package games.aquastudios.aquaclient.shaded.apache.commons.math3.util;

import games.aquastudios.aquaclient.shaded.apache.commons.math3.exception.MathIllegalArgumentException;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.exception.MathIllegalStateException;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.exception.MathInternalError;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.exception.NotStrictlyPositiveException;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.exception.NumberIsTooSmallException;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.exception.util.Localizable;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.exception.util.LocalizedFormats;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.util.DoubleArray;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.util.FastMath;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.util.MathArrays$Function;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.util.MathUtils;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.util.ResizableDoubleArray$ExpansionMode;
import java.io.Serializable;
import java.util.Arrays;

public class ResizableDoubleArray
implements DoubleArray,
Serializable {
    @Deprecated
    public static final int ADDITIVE_MODE = 1;
    @Deprecated
    public static final int MULTIPLICATIVE_MODE = 0;
    private static final long serialVersionUID = -3485529955529426875L;
    private static final int DEFAULT_INITIAL_CAPACITY = 16;
    private static final double DEFAULT_EXPANSION_FACTOR = 2.0;
    private static final double DEFAULT_CONTRACTION_DELTA = 0.5;
    private double contractionCriterion = 2.5;
    private double expansionFactor = 2.0;
    private ResizableDoubleArray$ExpansionMode expansionMode = ResizableDoubleArray$ExpansionMode.MULTIPLICATIVE;
    private double[] internalArray;
    private int numElements = 0;
    private int startIndex = 0;

    public ResizableDoubleArray() {
        this(16);
    }

    public ResizableDoubleArray(int n) {
        this(n, 2.0);
    }

    public ResizableDoubleArray(double[] dArray) {
        this(16, 2.0, 2.5, ResizableDoubleArray$ExpansionMode.MULTIPLICATIVE, dArray);
    }

    @Deprecated
    public ResizableDoubleArray(int n, float f2) {
        this(n, (double)f2);
    }

    public ResizableDoubleArray(int n, double d2) {
        this(n, d2, d2 + 0.5);
    }

    @Deprecated
    public ResizableDoubleArray(int n, float f2, float f3) {
        this(n, (double)f2, (double)f3);
    }

    public ResizableDoubleArray(int n, double d2, double d3) {
        this(n, d2, d3, ResizableDoubleArray$ExpansionMode.MULTIPLICATIVE, null);
    }

    @Deprecated
    public ResizableDoubleArray(int n, float f2, float f3, int n2) {
        this(n, f2, f3, n2 == 1 ? ResizableDoubleArray$ExpansionMode.ADDITIVE : ResizableDoubleArray$ExpansionMode.MULTIPLICATIVE, null);
        this.setExpansionMode(n2);
    }

    public ResizableDoubleArray(int n, double d2, double d3, ResizableDoubleArray$ExpansionMode resizableDoubleArray$ExpansionMode, double ... dArray) {
        if (n <= 0) {
            throw new NotStrictlyPositiveException((Localizable)LocalizedFormats.INITIAL_CAPACITY_NOT_POSITIVE, n);
        }
        this.checkContractExpand(d3, d2);
        this.expansionFactor = d2;
        this.contractionCriterion = d3;
        this.expansionMode = resizableDoubleArray$ExpansionMode;
        this.internalArray = new double[n];
        this.numElements = 0;
        this.startIndex = 0;
        if (dArray != null && dArray.length > 0) {
            this.addElements(dArray);
        }
    }

    public ResizableDoubleArray(ResizableDoubleArray resizableDoubleArray) {
        MathUtils.checkNotNull(resizableDoubleArray);
        ResizableDoubleArray.copy(resizableDoubleArray, this);
    }

    public synchronized void addElement(double d2) {
        if (this.internalArray.length <= this.startIndex + this.numElements) {
            this.expand();
        }
        this.internalArray[this.startIndex + this.numElements++] = d2;
    }

    public synchronized void addElements(double[] dArray) {
        double[] dArray2 = new double[this.numElements + dArray.length + 1];
        System.arraycopy(this.internalArray, this.startIndex, dArray2, 0, this.numElements);
        System.arraycopy(dArray, 0, dArray2, this.numElements, dArray.length);
        this.internalArray = dArray2;
        this.startIndex = 0;
        this.numElements += dArray.length;
    }

    public synchronized double addElementRolling(double d2) {
        double d3 = this.internalArray[this.startIndex];
        if (this.startIndex + (this.numElements + 1) > this.internalArray.length) {
            this.expand();
        }
        ++this.startIndex;
        this.internalArray[this.startIndex + (this.numElements - 1)] = d2;
        if (this.shouldContract()) {
            this.contract();
        }
        return d3;
    }

    public synchronized double substituteMostRecentElement(double d2) {
        if (this.numElements <= 0) {
            throw new MathIllegalStateException(LocalizedFormats.CANNOT_SUBSTITUTE_ELEMENT_FROM_EMPTY_ARRAY, new Object[0]);
        }
        int n = this.startIndex + (this.numElements - 1);
        double d3 = this.internalArray[n];
        this.internalArray[n] = d2;
        return d3;
    }

    @Deprecated
    protected void checkContractExpand(float f2, float f3) {
        this.checkContractExpand((double)f2, (double)f3);
    }

    protected void checkContractExpand(double d2, double d3) {
        if (d2 < d3) {
            NumberIsTooSmallException numberIsTooSmallException = new NumberIsTooSmallException(d2, (Number)1, true);
            numberIsTooSmallException.getContext().addMessage(LocalizedFormats.CONTRACTION_CRITERIA_SMALLER_THAN_EXPANSION_FACTOR, d2, d3);
            throw numberIsTooSmallException;
        }
        if (d2 <= 1.0) {
            NumberIsTooSmallException numberIsTooSmallException = new NumberIsTooSmallException(d2, (Number)1, false);
            numberIsTooSmallException.getContext().addMessage(LocalizedFormats.CONTRACTION_CRITERIA_SMALLER_THAN_ONE, d2);
            throw numberIsTooSmallException;
        }
        if (d3 <= 1.0) {
            NumberIsTooSmallException numberIsTooSmallException = new NumberIsTooSmallException(d2, (Number)1, false);
            numberIsTooSmallException.getContext().addMessage(LocalizedFormats.EXPANSION_FACTOR_SMALLER_THAN_ONE, d3);
            throw numberIsTooSmallException;
        }
    }

    public synchronized void clear() {
        this.numElements = 0;
        this.startIndex = 0;
    }

    public synchronized void contract() {
        double[] dArray = new double[this.numElements + 1];
        System.arraycopy(this.internalArray, this.startIndex, dArray, 0, this.numElements);
        this.internalArray = dArray;
        this.startIndex = 0;
    }

    public synchronized void discardFrontElements(int n) {
        this.discardExtremeElements(n, true);
    }

    public synchronized void discardMostRecentElements(int n) {
        this.discardExtremeElements(n, false);
    }

    private synchronized void discardExtremeElements(int n, boolean bl) {
        if (n > this.numElements) {
            throw new MathIllegalArgumentException(LocalizedFormats.TOO_MANY_ELEMENTS_TO_DISCARD_FROM_ARRAY, n, this.numElements);
        }
        if (n < 0) {
            throw new MathIllegalArgumentException(LocalizedFormats.CANNOT_DISCARD_NEGATIVE_NUMBER_OF_ELEMENTS, n);
        }
        this.numElements -= n;
        if (bl) {
            this.startIndex += n;
        }
        if (this.shouldContract()) {
            this.contract();
        }
    }

    protected synchronized void expand() {
        int n = this.expansionMode == ResizableDoubleArray$ExpansionMode.MULTIPLICATIVE ? (int)FastMath.ceil((double)this.internalArray.length * this.expansionFactor) : (int)((long)this.internalArray.length + FastMath.round(this.expansionFactor));
        double[] dArray = new double[n];
        System.arraycopy(this.internalArray, 0, dArray, 0, this.internalArray.length);
        this.internalArray = dArray;
    }

    private synchronized void expandTo(int n) {
        double[] dArray = new double[n];
        System.arraycopy(this.internalArray, 0, dArray, 0, this.internalArray.length);
        this.internalArray = dArray;
    }

    @Deprecated
    public float getContractionCriteria() {
        return (float)this.getContractionCriterion();
    }

    public double getContractionCriterion() {
        return this.contractionCriterion;
    }

    public synchronized double getElement(int n) {
        if (n >= this.numElements) {
            throw new ArrayIndexOutOfBoundsException(n);
        }
        if (n >= 0) {
            return this.internalArray[this.startIndex + n];
        }
        throw new ArrayIndexOutOfBoundsException(n);
    }

    public synchronized double[] getElements() {
        double[] dArray = new double[this.numElements];
        System.arraycopy(this.internalArray, this.startIndex, dArray, 0, this.numElements);
        return dArray;
    }

    @Deprecated
    public float getExpansionFactor() {
        return (float)this.expansionFactor;
    }

    @Deprecated
    public int getExpansionMode() {
        ResizableDoubleArray resizableDoubleArray = this;
        synchronized (resizableDoubleArray) {
            switch (this.expansionMode) {
                case MULTIPLICATIVE: {
                    return 0;
                }
                case ADDITIVE: {
                    return 1;
                }
            }
            throw new MathInternalError();
        }
    }

    @Deprecated
    synchronized int getInternalLength() {
        return this.internalArray.length;
    }

    public int getCapacity() {
        return this.internalArray.length;
    }

    public synchronized int getNumElements() {
        return this.numElements;
    }

    @Deprecated
    public synchronized double[] getInternalValues() {
        return this.internalArray;
    }

    protected double[] getArrayRef() {
        return this.internalArray;
    }

    protected int getStartIndex() {
        return this.startIndex;
    }

    @Deprecated
    public void setContractionCriteria(float f2) {
        this.checkContractExpand(f2, this.getExpansionFactor());
        ResizableDoubleArray resizableDoubleArray = this;
        synchronized (resizableDoubleArray) {
            this.contractionCriterion = f2;
            return;
        }
    }

    public double compute(MathArrays$Function mathArrays$Function) {
        int n;
        int n2;
        double[] dArray;
        ResizableDoubleArray resizableDoubleArray = this;
        synchronized (resizableDoubleArray) {
            dArray = this.internalArray;
            n2 = this.startIndex;
            n = this.numElements;
        }
        return mathArrays$Function.evaluate(dArray, n2, n);
    }

    public synchronized void setElement(int n, double d2) {
        if (n < 0) {
            throw new ArrayIndexOutOfBoundsException(n);
        }
        if (n + 1 > this.numElements) {
            this.numElements = n + 1;
        }
        if (this.startIndex + n >= this.internalArray.length) {
            ResizableDoubleArray resizableDoubleArray = this;
            resizableDoubleArray.expandTo(resizableDoubleArray.startIndex + (n + 1));
        }
        this.internalArray[this.startIndex + n] = d2;
    }

    @Deprecated
    public void setExpansionFactor(float f2) {
        ResizableDoubleArray resizableDoubleArray = this;
        resizableDoubleArray.checkContractExpand(resizableDoubleArray.getContractionCriterion(), (double)f2);
        ResizableDoubleArray resizableDoubleArray2 = this;
        synchronized (resizableDoubleArray2) {
            this.expansionFactor = f2;
            return;
        }
    }

    @Deprecated
    public void setExpansionMode(int n) {
        if (n != 0 && n != 1) {
            throw new MathIllegalArgumentException(LocalizedFormats.UNSUPPORTED_EXPANSION_MODE, n, 0, "MULTIPLICATIVE_MODE", 1, "ADDITIVE_MODE");
        }
        ResizableDoubleArray resizableDoubleArray = this;
        synchronized (resizableDoubleArray) {
            if (n == 0) {
                this.setExpansionMode(ResizableDoubleArray$ExpansionMode.MULTIPLICATIVE);
            } else if (n == 1) {
                this.setExpansionMode(ResizableDoubleArray$ExpansionMode.ADDITIVE);
            }
            return;
        }
    }

    @Deprecated
    public void setExpansionMode(ResizableDoubleArray$ExpansionMode resizableDoubleArray$ExpansionMode) {
        ResizableDoubleArray resizableDoubleArray = this;
        synchronized (resizableDoubleArray) {
            this.expansionMode = resizableDoubleArray$ExpansionMode;
            return;
        }
    }

    @Deprecated
    protected void setInitialCapacity(int n) {
    }

    public synchronized void setNumElements(int n) {
        if (n < 0) {
            throw new MathIllegalArgumentException(LocalizedFormats.INDEX_NOT_POSITIVE, n);
        }
        int n2 = this.startIndex + n;
        if (n2 > this.internalArray.length) {
            this.expandTo(n2);
        }
        this.numElements = n;
    }

    private synchronized boolean shouldContract() {
        if (this.expansionMode == ResizableDoubleArray$ExpansionMode.MULTIPLICATIVE) {
            return (double)((float)this.internalArray.length / (float)this.numElements) > this.contractionCriterion;
        }
        return (double)(this.internalArray.length - this.numElements) > this.contractionCriterion;
    }

    @Deprecated
    public synchronized int start() {
        return this.startIndex;
    }

    public static void copy(ResizableDoubleArray resizableDoubleArray, ResizableDoubleArray resizableDoubleArray2) {
        MathUtils.checkNotNull(resizableDoubleArray);
        MathUtils.checkNotNull(resizableDoubleArray2);
        ResizableDoubleArray resizableDoubleArray3 = resizableDoubleArray;
        synchronized (resizableDoubleArray3) {
            ResizableDoubleArray resizableDoubleArray4 = resizableDoubleArray2;
            synchronized (resizableDoubleArray4) {
                resizableDoubleArray2.contractionCriterion = resizableDoubleArray.contractionCriterion;
                resizableDoubleArray2.expansionFactor = resizableDoubleArray.expansionFactor;
                resizableDoubleArray2.expansionMode = resizableDoubleArray.expansionMode;
                resizableDoubleArray2.internalArray = new double[resizableDoubleArray.internalArray.length];
                System.arraycopy(resizableDoubleArray.internalArray, 0, resizableDoubleArray2.internalArray, 0, resizableDoubleArray2.internalArray.length);
                resizableDoubleArray2.numElements = resizableDoubleArray.numElements;
                resizableDoubleArray2.startIndex = resizableDoubleArray.startIndex;
            }
            return;
        }
    }

    public synchronized ResizableDoubleArray copy() {
        ResizableDoubleArray resizableDoubleArray = new ResizableDoubleArray();
        ResizableDoubleArray.copy(this, resizableDoubleArray);
        return resizableDoubleArray;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof ResizableDoubleArray)) {
            return false;
        }
        ResizableDoubleArray resizableDoubleArray = this;
        synchronized (resizableDoubleArray) {
            Object object2 = object;
            synchronized (object2) {
                ResizableDoubleArray resizableDoubleArray2 = (ResizableDoubleArray)object;
                boolean bl = resizableDoubleArray2.contractionCriterion == this.contractionCriterion;
                bl = bl && resizableDoubleArray2.expansionFactor == this.expansionFactor;
                bl = bl && resizableDoubleArray2.expansionMode == this.expansionMode;
                bl = bl && resizableDoubleArray2.numElements == this.numElements;
                if (!(bl = bl && resizableDoubleArray2.startIndex == this.startIndex)) {
                    return false;
                }
                return Arrays.equals(this.internalArray, resizableDoubleArray2.internalArray);
            }
        }
    }

    public synchronized int hashCode() {
        int[] nArray = new int[6];
        int[] nArray2 = nArray;
        nArray[0] = Double.valueOf(this.expansionFactor).hashCode();
        nArray2[1] = Double.valueOf(this.contractionCriterion).hashCode();
        nArray2[2] = this.expansionMode.hashCode();
        nArray2[3] = Arrays.hashCode(this.internalArray);
        nArray2[4] = this.numElements;
        nArray2[5] = this.startIndex;
        return Arrays.hashCode(nArray2);
    }
}

