/*
 * Decompiled with CFR 0.152.
 */
package games.aquastudios.aquaclient.shaded.apache.commons.math3.util;

import games.aquastudios.aquaclient.shaded.apache.commons.math3.exception.MathArithmeticException;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.exception.MathIllegalArgumentException;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.exception.util.LocalizedFormats;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.util.FastMath;
import java.math.BigDecimal;

public class Precision {
    public static final double EPSILON;
    public static final double SAFE_MIN;
    private static final long EXPONENT_OFFSET = 1023L;
    private static final long SGN_MASK = Long.MIN_VALUE;
    private static final int SGN_MASK_FLOAT = Integer.MIN_VALUE;
    private static final double POSITIVE_ZERO = 0.0;
    private static final long POSITIVE_ZERO_DOUBLE_BITS;
    private static final long NEGATIVE_ZERO_DOUBLE_BITS;
    private static final int POSITIVE_ZERO_FLOAT_BITS;
    private static final int NEGATIVE_ZERO_FLOAT_BITS;

    private Precision() {
    }

    public static int compareTo(double d2, double d3, double d4) {
        if (Precision.equals(d2, d3, d4)) {
            return 0;
        }
        if (d2 < d3) {
            return -1;
        }
        return 1;
    }

    public static int compareTo(double d2, double d3, int n) {
        if (Precision.equals(d2, d3, n)) {
            return 0;
        }
        if (d2 < d3) {
            return -1;
        }
        return 1;
    }

    public static boolean equals(float f2, float f3) {
        return Precision.equals(f2, f3, 1);
    }

    public static boolean equalsIncludingNaN(float f2, float f3) {
        block3: {
            block2: {
                float f4 = f2;
                if (f4 != f4) break block2;
                float f5 = f3;
                if (f5 == f5) break block3;
            }
            float f6 = f2;
            float f7 = f3;
            return !(f6 != f6 ^ f7 != f7);
        }
        return Precision.equals(f2, f3, 1);
    }

    public static boolean equals(float f2, float f3, float f4) {
        return Precision.equals(f2, f3, 1) || FastMath.abs(f3 - f2) <= f4;
    }

    public static boolean equalsIncludingNaN(float f2, float f3, float f4) {
        return Precision.equalsIncludingNaN(f2, f3) || FastMath.abs(f3 - f2) <= f4;
    }

    public static boolean equals(float f2, float f3, int n) {
        int n2;
        int n3 = Float.floatToRawIntBits(f2);
        if (((n3 ^ (n2 = Float.floatToRawIntBits(f3))) & Integer.MIN_VALUE) == 0) {
            n = FastMath.abs(n3 - n2) <= n ? 1 : 0;
        } else {
            int n4;
            if (n3 < n2) {
                n4 = n2 - POSITIVE_ZERO_FLOAT_BITS;
                n3 -= NEGATIVE_ZERO_FLOAT_BITS;
            } else {
                n4 = n3 - POSITIVE_ZERO_FLOAT_BITS;
                n3 = n2 - NEGATIVE_ZERO_FLOAT_BITS;
            }
            int n5 = n = n4 <= n && n3 <= n - n4 ? 1 : 0;
        }
        return n != 0 && !Float.isNaN(f2) && !Float.isNaN(f3);
    }

    public static boolean equalsIncludingNaN(float f2, float f3, int n) {
        block3: {
            block2: {
                float f4 = f2;
                if (f4 != f4) break block2;
                float f5 = f3;
                if (f5 == f5) break block3;
            }
            float f6 = f2;
            float f7 = f3;
            return !(f6 != f6 ^ f7 != f7);
        }
        return Precision.equals(f2, f3, n);
    }

    public static boolean equals(double d2, double d3) {
        return Precision.equals(d2, d3, 1);
    }

    public static boolean equalsIncludingNaN(double d2, double d3) {
        block3: {
            block2: {
                double d4 = d2;
                if (d4 != d4) break block2;
                double d5 = d3;
                if (d5 == d5) break block3;
            }
            double d6 = d2;
            double d7 = d3;
            return !(d6 != d6 ^ d7 != d7);
        }
        return Precision.equals(d2, d3, 1);
    }

    public static boolean equals(double d2, double d3, double d4) {
        return Precision.equals(d2, d3, 1) || FastMath.abs(d3 - d2) <= d4;
    }

    public static boolean equalsWithRelativeTolerance(double d2, double d3, double d4) {
        double d5;
        if (Precision.equals(d2, d3, 1)) {
            return true;
        }
        double d6 = FastMath.max(FastMath.abs(d2), FastMath.abs(d3));
        double d7 = FastMath.abs((d2 - d3) / d6);
        return d5 <= d4;
    }

    public static boolean equalsIncludingNaN(double d2, double d3, double d4) {
        return Precision.equalsIncludingNaN(d2, d3) || FastMath.abs(d3 - d2) <= d4;
    }

    public static boolean equals(double d2, double d3, int n) {
        long l;
        long l2 = Double.doubleToRawLongBits(d2);
        if (((l2 ^ (l = Double.doubleToRawLongBits(d3))) & Long.MIN_VALUE) == 0L) {
            n = FastMath.abs(l2 - l) <= (long)n ? 1 : 0;
        } else {
            long l3;
            long l4;
            if (l2 < l) {
                l4 = l - POSITIVE_ZERO_DOUBLE_BITS;
                l3 = l2 - NEGATIVE_ZERO_DOUBLE_BITS;
            } else {
                l4 = l2 - POSITIVE_ZERO_DOUBLE_BITS;
                l3 = l - NEGATIVE_ZERO_DOUBLE_BITS;
            }
            int n2 = n = l4 <= (long)n && l3 <= (long)n - l4 ? 1 : 0;
        }
        return n != 0 && !Double.isNaN(d2) && !Double.isNaN(d3);
    }

    public static boolean equalsIncludingNaN(double d2, double d3, int n) {
        block3: {
            block2: {
                double d4 = d2;
                if (d4 != d4) break block2;
                double d5 = d3;
                if (d5 == d5) break block3;
            }
            double d6 = d2;
            double d7 = d3;
            return !(d6 != d6 ^ d7 != d7);
        }
        return Precision.equals(d2, d3, n);
    }

    public static double round(double d2, int n) {
        return Precision.round(d2, n, 4);
    }

    public static double round(double d2, int n, int n2) {
        try {
            double d3 = new BigDecimal(Double.toString(d2)).setScale(n, n2).doubleValue();
            if (d3 == 0.0) {
                return d2 * 0.0;
            }
            return d3;
        }
        catch (NumberFormatException numberFormatException) {
            if (Double.isInfinite(d2)) {
                return d2;
            }
            return Double.NaN;
        }
    }

    public static float round(float f2, int n) {
        return Precision.round(f2, n, 4);
    }

    public static float round(float f2, int n, int n2) {
        float f3 = FastMath.copySign(1.0f, f2);
        float f4 = (float)FastMath.pow(10.0, n) * f3;
        return (float)Precision.roundUnscaled(f2 * f4, f3, n2) / f4;
    }

    private static double roundUnscaled(double d2, double d3, int n) {
        switch (n) {
            case 2: {
                if (d3 == -1.0) {
                    d2 = FastMath.floor(FastMath.nextAfter(d2, Double.NEGATIVE_INFINITY));
                    break;
                }
                d2 = FastMath.ceil(FastMath.nextAfter(d2, Double.POSITIVE_INFINITY));
                break;
            }
            case 1: {
                d2 = FastMath.floor(FastMath.nextAfter(d2, Double.NEGATIVE_INFINITY));
                break;
            }
            case 3: {
                if (d3 == -1.0) {
                    d2 = FastMath.ceil(FastMath.nextAfter(d2, Double.POSITIVE_INFINITY));
                    break;
                }
                d2 = FastMath.floor(FastMath.nextAfter(d2, Double.NEGATIVE_INFINITY));
                break;
            }
            case 5: {
                double d4;
                d2 = FastMath.nextAfter(d2, Double.NEGATIVE_INFINITY);
                double d5 = d2 - FastMath.floor(d2);
                if (d4 > 0.5) {
                    d2 = FastMath.ceil(d2);
                    break;
                }
                d2 = FastMath.floor(d2);
                break;
            }
            case 6: {
                double d6;
                double d7 = d2;
                double d8 = d7 - FastMath.floor(d7);
                if (d6 > 0.5) {
                    d2 = FastMath.ceil(d2);
                    break;
                }
                if (d8 < 0.5) {
                    d2 = FastMath.floor(d2);
                    break;
                }
                if (FastMath.floor(d2) / 2.0 == FastMath.floor(FastMath.floor(d2) / 2.0)) {
                    d2 = FastMath.floor(d2);
                    break;
                }
                d2 = FastMath.ceil(d2);
                break;
            }
            case 4: {
                double d9;
                d2 = FastMath.nextAfter(d2, Double.POSITIVE_INFINITY);
                double d10 = d2 - FastMath.floor(d2);
                if (d9 >= 0.5) {
                    d2 = FastMath.ceil(d2);
                    break;
                }
                d2 = FastMath.floor(d2);
                break;
            }
            case 7: {
                double d11 = d2;
                if (d11 == FastMath.floor(d11)) break;
                throw new MathArithmeticException();
            }
            case 0: {
                double d12 = d2;
                if (d12 == FastMath.floor(d12)) break;
                d2 = FastMath.ceil(FastMath.nextAfter(d2, Double.POSITIVE_INFINITY));
                break;
            }
            default: {
                throw new MathIllegalArgumentException(LocalizedFormats.INVALID_ROUNDING_METHOD, n, "ROUND_CEILING", 2, "ROUND_DOWN", 1, "ROUND_FLOOR", 3, "ROUND_HALF_DOWN", 5, "ROUND_HALF_EVEN", 6, "ROUND_HALF_UP", 4, "ROUND_UNNECESSARY", 7, "ROUND_UP", 0);
            }
        }
        return d2;
    }

    public static double representableDelta(double d2, double d3) {
        return d2 + d3 - d2;
    }

    static {
        POSITIVE_ZERO_DOUBLE_BITS = Double.doubleToRawLongBits(0.0);
        NEGATIVE_ZERO_DOUBLE_BITS = Double.doubleToRawLongBits(-0.0);
        POSITIVE_ZERO_FLOAT_BITS = Float.floatToRawIntBits(0.0f);
        NEGATIVE_ZERO_FLOAT_BITS = Float.floatToRawIntBits(-0.0f);
        EPSILON = Double.longBitsToDouble(4368491638549381120L);
        SAFE_MIN = Double.longBitsToDouble(0x10000000000000L);
    }
}

