/*
 * Decompiled with CFR 0.152.
 */
package games.aquastudios.aquaclient.shaded.apache.commons.math3.util;

import games.aquastudios.aquaclient.shaded.apache.commons.math3.Field;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.FieldElement;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.util.FastMath;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.util.OpenIntToFieldHashMap$Iterator;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.lang.reflect.Array;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OpenIntToFieldHashMap<T extends FieldElement<T>>
implements Serializable {
    protected static final byte FREE = 0;
    protected static final byte FULL = 1;
    protected static final byte REMOVED = 2;
    private static final long serialVersionUID = -9179080286849120720L;
    private static final float LOAD_FACTOR = 0.5f;
    private static final int DEFAULT_EXPECTED_SIZE = 16;
    private static final int RESIZE_MULTIPLIER = 2;
    private static final int PERTURB_SHIFT = 5;
    private final Field<T> field;
    private int[] keys;
    private T[] values;
    private byte[] states;
    private final T missingEntries;
    private int size;
    private int mask;
    private transient int count;

    public OpenIntToFieldHashMap(Field<T> field) {
        this(field, 16, (FieldElement)field.getZero());
    }

    public OpenIntToFieldHashMap(Field<T> field, T t) {
        this(field, 16, t);
    }

    public OpenIntToFieldHashMap(Field<T> field, int n) {
        this(field, n, (FieldElement)field.getZero());
    }

    public OpenIntToFieldHashMap(Field<T> field, int n, T t) {
        this.field = field;
        int n2 = OpenIntToFieldHashMap.computeCapacity(n);
        this.keys = new int[n2];
        this.values = this.buildArray(n2);
        this.states = new byte[n2];
        this.missingEntries = t;
        this.mask = n2 - 1;
    }

    public OpenIntToFieldHashMap(OpenIntToFieldHashMap<T> openIntToFieldHashMap) {
        this.field = openIntToFieldHashMap.field;
        int n = openIntToFieldHashMap.keys.length;
        this.keys = new int[n];
        System.arraycopy(openIntToFieldHashMap.keys, 0, this.keys, 0, n);
        this.values = this.buildArray(n);
        System.arraycopy(openIntToFieldHashMap.values, 0, this.values, 0, n);
        this.states = new byte[n];
        System.arraycopy(openIntToFieldHashMap.states, 0, this.states, 0, n);
        this.missingEntries = openIntToFieldHashMap.missingEntries;
        this.size = openIntToFieldHashMap.size;
        this.mask = openIntToFieldHashMap.mask;
        this.count = openIntToFieldHashMap.count;
    }

    private static int computeCapacity(int n) {
        if (n == 0) {
            return 1;
        }
        int n2 = Integer.highestOneBit(n = (int)FastMath.ceil((float)n / 0.5f));
        if (n2 == n) {
            return n;
        }
        return OpenIntToFieldHashMap.nextPowerOfTwo(n);
    }

    private static int nextPowerOfTwo(int n) {
        return Integer.highestOneBit(n) << 1;
    }

    public T get(int n) {
        int n2 = OpenIntToFieldHashMap.hashOf(n);
        int n3 = n2 & this.mask;
        if (this.containsKey(n, n3)) {
            return this.values[n3];
        }
        if (this.states[n3] == 0) {
            return this.missingEntries;
        }
        int n4 = n3;
        n2 = OpenIntToFieldHashMap.perturb(n2);
        while (this.states[n3] != 0) {
            n3 = (n4 = OpenIntToFieldHashMap.probe(n2, n4)) & this.mask;
            if (this.containsKey(n, n3)) {
                return this.values[n3];
            }
            n2 >>= 5;
        }
        return this.missingEntries;
    }

    public boolean containsKey(int n) {
        int n2 = OpenIntToFieldHashMap.hashOf(n);
        int n3 = n2 & this.mask;
        if (this.containsKey(n, n3)) {
            return true;
        }
        if (this.states[n3] == 0) {
            return false;
        }
        int n4 = n3;
        n2 = OpenIntToFieldHashMap.perturb(n2);
        while (this.states[n3] != 0) {
            n3 = (n4 = OpenIntToFieldHashMap.probe(n2, n4)) & this.mask;
            if (this.containsKey(n, n3)) {
                return true;
            }
            n2 >>= 5;
        }
        return false;
    }

    public OpenIntToFieldHashMap$Iterator iterator() {
        return new OpenIntToFieldHashMap$Iterator(this, null);
    }

    private static int perturb(int n) {
        return n & Integer.MAX_VALUE;
    }

    private int findInsertionIndex(int n) {
        return OpenIntToFieldHashMap.findInsertionIndex(this.keys, this.states, n, this.mask);
    }

    private static int findInsertionIndex(int[] nArray, byte[] byArray, int n, int n2) {
        int n3 = OpenIntToFieldHashMap.hashOf(n);
        int n4 = n3 & n2;
        if (byArray[n4] == 0) {
            return n4;
        }
        if (byArray[n4] == 1 && nArray[n4] == n) {
            return OpenIntToFieldHashMap.changeIndexSign(n4);
        }
        n3 = OpenIntToFieldHashMap.perturb(n3);
        int n5 = n4;
        if (byArray[n4] == 1) {
            do {
                n5 = OpenIntToFieldHashMap.probe(n3, n5);
                n4 = n5 & n2;
                n3 >>= 5;
            } while (byArray[n4] == 1 && nArray[n4] != n);
        }
        if (byArray[n4] == 0) {
            return n4;
        }
        if (byArray[n4] == 1) {
            return OpenIntToFieldHashMap.changeIndexSign(n4);
        }
        int n6 = n4;
        while (byArray[n4 = (n5 = OpenIntToFieldHashMap.probe(n3, n5)) & n2] != 0) {
            if (byArray[n4] == 1 && nArray[n4] == n) {
                return OpenIntToFieldHashMap.changeIndexSign(n4);
            }
            n3 >>= 5;
        }
        return n6;
    }

    private static int probe(int n, int n2) {
        return (n2 << 2) + n2 + n + 1;
    }

    private static int changeIndexSign(int n) {
        return -n - 1;
    }

    public int size() {
        return this.size;
    }

    public T remove(int n) {
        int n2 = OpenIntToFieldHashMap.hashOf(n);
        int n3 = n2 & this.mask;
        if (this.containsKey(n, n3)) {
            return this.doRemove(n3);
        }
        if (this.states[n3] == 0) {
            return this.missingEntries;
        }
        int n4 = n3;
        n2 = OpenIntToFieldHashMap.perturb(n2);
        while (this.states[n3] != 0) {
            n3 = (n4 = OpenIntToFieldHashMap.probe(n2, n4)) & this.mask;
            if (this.containsKey(n, n3)) {
                return this.doRemove(n3);
            }
            n2 >>= 5;
        }
        return this.missingEntries;
    }

    private boolean containsKey(int n, int n2) {
        return (n != 0 || this.states[n2] == 1) && this.keys[n2] == n;
    }

    private T doRemove(int n) {
        this.keys[n] = 0;
        this.states[n] = 2;
        T t = this.values[n];
        this.values[n] = this.missingEntries;
        --this.size;
        ++this.count;
        return t;
    }

    public T put(int n, T t) {
        int n2 = this.findInsertionIndex(n);
        T t2 = this.missingEntries;
        boolean bl = true;
        if (n2 < 0) {
            n2 = OpenIntToFieldHashMap.changeIndexSign(n2);
            t2 = this.values[n2];
            bl = false;
        }
        this.keys[n2] = n;
        this.states[n2] = 1;
        this.values[n2] = t;
        if (bl) {
            ++this.size;
            if (this.shouldGrowTable()) {
                this.growTable();
            }
            ++this.count;
        }
        return t2;
    }

    private void growTable() {
        int n = this.states.length;
        int[] nArray = this.keys;
        T[] TArray = this.values;
        byte[] byArray = this.states;
        int n2 = 2 * n;
        int[] nArray2 = new int[n2];
        FieldElement[] fieldElementArray = this.buildArray(n2);
        byte[] byArray2 = new byte[n2];
        --n2;
        for (int i2 = 0; i2 < n; ++i2) {
            if (byArray[i2] != 1) continue;
            int n3 = nArray[i2];
            int n4 = OpenIntToFieldHashMap.findInsertionIndex(nArray2, byArray2, n3, n2);
            nArray2[n4] = n3;
            fieldElementArray[n4] = TArray[i2];
            byArray2[n4] = 1;
        }
        this.mask = n2;
        this.keys = nArray2;
        this.values = fieldElementArray;
        this.states = byArray2;
    }

    private boolean shouldGrowTable() {
        return (float)this.size > (float)(this.mask + 1) * 0.5f;
    }

    private static int hashOf(int n) {
        int n2 = n;
        n = n2 ^ (n2 >>> 20 ^ n >>> 12);
        return n ^ n >>> 7 ^ n >>> 4;
    }

    private void readObject(ObjectInputStream objectInputStream) {
        objectInputStream.defaultReadObject();
        this.count = 0;
    }

    private T[] buildArray(int n) {
        return (FieldElement[])Array.newInstance(this.field.getRuntimeClass(), n);
    }

    static /* synthetic */ int access$100(OpenIntToFieldHashMap openIntToFieldHashMap) {
        return openIntToFieldHashMap.count;
    }

    static /* synthetic */ int[] access$200(OpenIntToFieldHashMap openIntToFieldHashMap) {
        return openIntToFieldHashMap.keys;
    }

    static /* synthetic */ FieldElement[] access$300(OpenIntToFieldHashMap openIntToFieldHashMap) {
        return openIntToFieldHashMap.values;
    }

    static /* synthetic */ byte[] access$400(OpenIntToFieldHashMap openIntToFieldHashMap) {
        return openIntToFieldHashMap.states;
    }
}

