/*
 * Decompiled with CFR 0.152.
 */
package games.aquastudios.aquaclient.shaded.apache.commons.math3.util;

import games.aquastudios.aquaclient.shaded.apache.commons.math3.util.FastMath;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.util.OpenIntToDoubleHashMap$Iterator;
import java.io.ObjectInputStream;
import java.io.Serializable;

public class OpenIntToDoubleHashMap
implements Serializable {
    protected static final byte FREE = 0;
    protected static final byte FULL = 1;
    protected static final byte REMOVED = 2;
    private static final long serialVersionUID = -3646337053166149105L;
    private static final float LOAD_FACTOR = 0.5f;
    private static final int DEFAULT_EXPECTED_SIZE = 16;
    private static final int RESIZE_MULTIPLIER = 2;
    private static final int PERTURB_SHIFT = 5;
    private int[] keys;
    private double[] values;
    private byte[] states;
    private final double missingEntries;
    private int size;
    private int mask;
    private transient int count;

    public OpenIntToDoubleHashMap() {
        this(16, Double.NaN);
    }

    public OpenIntToDoubleHashMap(double d2) {
        this(16, d2);
    }

    public OpenIntToDoubleHashMap(int n) {
        this(n, Double.NaN);
    }

    public OpenIntToDoubleHashMap(int n, double d2) {
        n = OpenIntToDoubleHashMap.computeCapacity(n);
        this.keys = new int[n];
        this.values = new double[n];
        this.states = new byte[n];
        this.missingEntries = d2;
        this.mask = n - 1;
    }

    public OpenIntToDoubleHashMap(OpenIntToDoubleHashMap openIntToDoubleHashMap) {
        int n = openIntToDoubleHashMap.keys.length;
        this.keys = new int[n];
        System.arraycopy(openIntToDoubleHashMap.keys, 0, this.keys, 0, n);
        this.values = new double[n];
        System.arraycopy(openIntToDoubleHashMap.values, 0, this.values, 0, n);
        this.states = new byte[n];
        System.arraycopy(openIntToDoubleHashMap.states, 0, this.states, 0, n);
        this.missingEntries = openIntToDoubleHashMap.missingEntries;
        this.size = openIntToDoubleHashMap.size;
        this.mask = openIntToDoubleHashMap.mask;
        this.count = openIntToDoubleHashMap.count;
    }

    private static int computeCapacity(int n) {
        if (n == 0) {
            return 1;
        }
        int n2 = Integer.highestOneBit(n = (int)FastMath.ceil((float)n / 0.5f));
        if (n2 == n) {
            return n;
        }
        return OpenIntToDoubleHashMap.nextPowerOfTwo(n);
    }

    private static int nextPowerOfTwo(int n) {
        return Integer.highestOneBit(n) << 1;
    }

    public double get(int n) {
        int n2 = OpenIntToDoubleHashMap.hashOf(n);
        int n3 = n2 & this.mask;
        if (this.containsKey(n, n3)) {
            return this.values[n3];
        }
        if (this.states[n3] == 0) {
            return this.missingEntries;
        }
        int n4 = n3;
        n2 = OpenIntToDoubleHashMap.perturb(n2);
        while (this.states[n3] != 0) {
            n3 = (n4 = OpenIntToDoubleHashMap.probe(n2, n4)) & this.mask;
            if (this.containsKey(n, n3)) {
                return this.values[n3];
            }
            n2 >>= 5;
        }
        return this.missingEntries;
    }

    public boolean containsKey(int n) {
        int n2 = OpenIntToDoubleHashMap.hashOf(n);
        int n3 = n2 & this.mask;
        if (this.containsKey(n, n3)) {
            return true;
        }
        if (this.states[n3] == 0) {
            return false;
        }
        int n4 = n3;
        n2 = OpenIntToDoubleHashMap.perturb(n2);
        while (this.states[n3] != 0) {
            n3 = (n4 = OpenIntToDoubleHashMap.probe(n2, n4)) & this.mask;
            if (this.containsKey(n, n3)) {
                return true;
            }
            n2 >>= 5;
        }
        return false;
    }

    public OpenIntToDoubleHashMap$Iterator iterator() {
        return new OpenIntToDoubleHashMap$Iterator(this, null);
    }

    private static int perturb(int n) {
        return n & Integer.MAX_VALUE;
    }

    private int findInsertionIndex(int n) {
        return OpenIntToDoubleHashMap.findInsertionIndex(this.keys, this.states, n, this.mask);
    }

    private static int findInsertionIndex(int[] nArray, byte[] byArray, int n, int n2) {
        int n3 = OpenIntToDoubleHashMap.hashOf(n);
        int n4 = n3 & n2;
        if (byArray[n4] == 0) {
            return n4;
        }
        if (byArray[n4] == 1 && nArray[n4] == n) {
            return OpenIntToDoubleHashMap.changeIndexSign(n4);
        }
        n3 = OpenIntToDoubleHashMap.perturb(n3);
        int n5 = n4;
        if (byArray[n4] == 1) {
            do {
                n5 = OpenIntToDoubleHashMap.probe(n3, n5);
                n4 = n5 & n2;
                n3 >>= 5;
            } while (byArray[n4] == 1 && nArray[n4] != n);
        }
        if (byArray[n4] == 0) {
            return n4;
        }
        if (byArray[n4] == 1) {
            return OpenIntToDoubleHashMap.changeIndexSign(n4);
        }
        int n6 = n4;
        while (byArray[n4 = (n5 = OpenIntToDoubleHashMap.probe(n3, n5)) & n2] != 0) {
            if (byArray[n4] == 1 && nArray[n4] == n) {
                return OpenIntToDoubleHashMap.changeIndexSign(n4);
            }
            n3 >>= 5;
        }
        return n6;
    }

    private static int probe(int n, int n2) {
        return (n2 << 2) + n2 + n + 1;
    }

    private static int changeIndexSign(int n) {
        return -n - 1;
    }

    public int size() {
        return this.size;
    }

    public double remove(int n) {
        int n2 = OpenIntToDoubleHashMap.hashOf(n);
        int n3 = n2 & this.mask;
        if (this.containsKey(n, n3)) {
            return this.doRemove(n3);
        }
        if (this.states[n3] == 0) {
            return this.missingEntries;
        }
        int n4 = n3;
        n2 = OpenIntToDoubleHashMap.perturb(n2);
        while (this.states[n3] != 0) {
            n3 = (n4 = OpenIntToDoubleHashMap.probe(n2, n4)) & this.mask;
            if (this.containsKey(n, n3)) {
                return this.doRemove(n3);
            }
            n2 >>= 5;
        }
        return this.missingEntries;
    }

    private boolean containsKey(int n, int n2) {
        return (n != 0 || this.states[n2] == 1) && this.keys[n2] == n;
    }

    private double doRemove(int n) {
        this.keys[n] = 0;
        this.states[n] = 2;
        double d2 = this.values[n];
        this.values[n] = this.missingEntries;
        --this.size;
        ++this.count;
        return d2;
    }

    public double put(int n, double d2) {
        int n2 = this.findInsertionIndex(n);
        double d3 = this.missingEntries;
        boolean bl = true;
        if (n2 < 0) {
            n2 = OpenIntToDoubleHashMap.changeIndexSign(n2);
            d3 = this.values[n2];
            bl = false;
        }
        this.keys[n2] = n;
        this.states[n2] = 1;
        this.values[n2] = d2;
        if (bl) {
            ++this.size;
            if (this.shouldGrowTable()) {
                this.growTable();
            }
            ++this.count;
        }
        return d3;
    }

    private void growTable() {
        int n = this.states.length;
        int[] nArray = this.keys;
        double[] dArray = this.values;
        byte[] byArray = this.states;
        int n2 = 2 * n;
        int[] nArray2 = new int[n2];
        double[] dArray2 = new double[n2];
        byte[] byArray2 = new byte[n2];
        --n2;
        for (int i2 = 0; i2 < n; ++i2) {
            if (byArray[i2] != 1) continue;
            int n3 = nArray[i2];
            int n4 = OpenIntToDoubleHashMap.findInsertionIndex(nArray2, byArray2, n3, n2);
            nArray2[n4] = n3;
            dArray2[n4] = dArray[i2];
            byArray2[n4] = 1;
        }
        this.mask = n2;
        this.keys = nArray2;
        this.values = dArray2;
        this.states = byArray2;
    }

    private boolean shouldGrowTable() {
        return (float)this.size > (float)(this.mask + 1) * 0.5f;
    }

    private static int hashOf(int n) {
        int n2 = n;
        n = n2 ^ (n2 >>> 20 ^ n >>> 12);
        return n ^ n >>> 7 ^ n >>> 4;
    }

    private void readObject(ObjectInputStream objectInputStream) {
        objectInputStream.defaultReadObject();
        this.count = 0;
    }

    static /* synthetic */ int access$100(OpenIntToDoubleHashMap openIntToDoubleHashMap) {
        return openIntToDoubleHashMap.count;
    }

    static /* synthetic */ int[] access$200(OpenIntToDoubleHashMap openIntToDoubleHashMap) {
        return openIntToDoubleHashMap.keys;
    }

    static /* synthetic */ double[] access$300(OpenIntToDoubleHashMap openIntToDoubleHashMap) {
        return openIntToDoubleHashMap.values;
    }

    static /* synthetic */ byte[] access$400(OpenIntToDoubleHashMap openIntToDoubleHashMap) {
        return openIntToDoubleHashMap.states;
    }
}

