/*
 * Decompiled with CFR 0.152.
 */
package games.aquastudios.aquaclient.shaded.apache.commons.math3.util;

import games.aquastudios.aquaclient.shaded.apache.commons.math3.exception.DimensionMismatchException;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.exception.NotStrictlyPositiveException;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.exception.OutOfRangeException;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.util.MathArrays;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.util.MultidimensionalCounter$Iterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MultidimensionalCounter
implements Iterable<Integer> {
    private final int dimension;
    private final int[] uniCounterOffset;
    private final int[] size;
    private final int totalSize;
    private final int last;

    public MultidimensionalCounter(int ... nArray) {
        this.dimension = nArray.length;
        this.size = MathArrays.copyOf(nArray);
        this.uniCounterOffset = new int[this.dimension];
        this.last = this.dimension - 1;
        int n = nArray[this.last];
        for (int i2 = 0; i2 < this.last; ++i2) {
            int n2 = 1;
            for (int i3 = i2 + 1; i3 < this.dimension; ++i3) {
                n2 *= nArray[i3];
            }
            this.uniCounterOffset[i2] = n2;
            n *= nArray[i2];
        }
        this.uniCounterOffset[this.last] = 0;
        if (n <= 0) {
            throw new NotStrictlyPositiveException(n);
        }
        this.totalSize = n;
    }

    public MultidimensionalCounter$Iterator iterator() {
        return new MultidimensionalCounter$Iterator(this);
    }

    public int getDimension() {
        return this.dimension;
    }

    public int[] getCounts(int n) {
        if (n < 0 || n >= this.totalSize) {
            throw new OutOfRangeException(n, (Number)0, this.totalSize);
        }
        int[] nArray = new int[this.dimension];
        int n2 = 0;
        for (int i2 = 0; i2 < this.last; ++i2) {
            int n3 = 0;
            int n4 = this.uniCounterOffset[i2];
            while (n2 <= n) {
                n2 += n4;
                ++n3;
            }
            n2 -= n4;
            nArray[i2] = --n3;
        }
        nArray[this.last] = n - n2;
        return nArray;
    }

    public int getCount(int ... nArray) {
        if (nArray.length != this.dimension) {
            throw new DimensionMismatchException(nArray.length, this.dimension);
        }
        int n = 0;
        for (int i2 = 0; i2 < this.dimension; ++i2) {
            int n2 = nArray[i2];
            if (n2 < 0 || n2 >= this.size[i2]) {
                throw new OutOfRangeException(n2, (Number)0, this.size[i2] - 1);
            }
            n += this.uniCounterOffset[i2] * nArray[i2];
        }
        return n + nArray[this.last];
    }

    public int getSize() {
        return this.totalSize;
    }

    public int[] getSizes() {
        return MathArrays.copyOf(this.size);
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        int n = 0;
        while (n < this.dimension) {
            stringBuilder.append("[").append(this.getCount(n++)).append("]");
        }
        return stringBuilder.toString();
    }

    static /* synthetic */ int access$000(MultidimensionalCounter multidimensionalCounter) {
        return multidimensionalCounter.dimension;
    }

    static /* synthetic */ int access$100(MultidimensionalCounter multidimensionalCounter) {
        return multidimensionalCounter.totalSize;
    }

    static /* synthetic */ int access$200(MultidimensionalCounter multidimensionalCounter) {
        return multidimensionalCounter.last;
    }

    static /* synthetic */ int[] access$300(MultidimensionalCounter multidimensionalCounter) {
        return multidimensionalCounter.size;
    }
}

