/*
 * Decompiled with CFR 0.152.
 */
package games.aquastudios.aquaclient.shaded.apache.commons.math3.util;

import games.aquastudios.aquaclient.shaded.apache.commons.math3.RealFieldElement;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.exception.MathArithmeticException;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.exception.NotFiniteNumberException;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.exception.NullArgumentException;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.exception.util.Localizable;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.exception.util.LocalizedFormats;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.util.FastMath;
import java.util.Arrays;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class MathUtils {
    public static final double TWO_PI = Math.PI * 2;
    public static final double PI_SQUARED = Math.PI * Math.PI;

    private MathUtils() {
    }

    public static int hash(double d2) {
        return Double.valueOf(d2).hashCode();
    }

    public static boolean equals(double d2, double d3) {
        return Double.valueOf(d2).equals(d3);
    }

    public static int hash(double[] dArray) {
        return Arrays.hashCode(dArray);
    }

    public static double normalizeAngle(double d2, double d3) {
        return d2 - Math.PI * 2 * FastMath.floor((d2 + Math.PI - d3) / (Math.PI * 2));
    }

    public static <T extends RealFieldElement<T>> T max(T t, T t2) {
        if (t.subtract(t2).getReal() >= 0.0) {
            return t;
        }
        return t2;
    }

    public static <T extends RealFieldElement<T>> T min(T t, T t2) {
        if (t.subtract(t2).getReal() >= 0.0) {
            return t2;
        }
        return t;
    }

    public static double reduce(double d2, double d3, double d4) {
        double d5 = FastMath.abs(d3);
        return d2 - d5 * FastMath.floor((d2 - d4) / d5) - d4;
    }

    public static byte copySign(byte by, byte by2) {
        if (by >= 0 && by2 >= 0 || by < 0 && by2 < 0) {
            return by;
        }
        if (by2 >= 0 && by == -128) {
            throw new MathArithmeticException(LocalizedFormats.OVERFLOW, new Object[0]);
        }
        return -by;
    }

    public static short copySign(short s, short s2) {
        if (s >= 0 && s2 >= 0 || s < 0 && s2 < 0) {
            return s;
        }
        if (s2 >= 0 && s == Short.MIN_VALUE) {
            throw new MathArithmeticException(LocalizedFormats.OVERFLOW, new Object[0]);
        }
        return -s;
    }

    public static int copySign(int n, int n2) {
        if (n >= 0 && n2 >= 0 || n < 0 && n2 < 0) {
            return n;
        }
        if (n2 >= 0 && n == Integer.MIN_VALUE) {
            throw new MathArithmeticException(LocalizedFormats.OVERFLOW, new Object[0]);
        }
        return -n;
    }

    public static long copySign(long l, long l2) {
        if (l >= 0L && l2 >= 0L || l < 0L && l2 < 0L) {
            return l;
        }
        if (l2 >= 0L && l == Long.MIN_VALUE) {
            throw new MathArithmeticException(LocalizedFormats.OVERFLOW, new Object[0]);
        }
        return -l;
    }

    public static void checkFinite(double d2) {
        if (Double.isInfinite(d2) || Double.isNaN(d2)) {
            throw new NotFiniteNumberException(d2, new Object[0]);
        }
    }

    public static void checkFinite(double[] dArray) {
        for (int i2 = 0; i2 < dArray.length; ++i2) {
            double d2 = dArray[i2];
            if (!Double.isInfinite(d2) && !Double.isNaN(d2)) continue;
            throw new NotFiniteNumberException((Localizable)LocalizedFormats.ARRAY_ELEMENT, d2, i2);
        }
    }

    public static void checkNotNull(Object object, Localizable localizable, Object ... objectArray) {
        if (object == null) {
            throw new NullArgumentException(localizable, objectArray);
        }
    }

    public static void checkNotNull(Object object) {
        if (object == null) {
            throw new NullArgumentException();
        }
    }
}

