/*
 * Decompiled with CFR 0.152.
 */
package games.aquastudios.aquaclient.shaded.apache.commons.math3.util;

import games.aquastudios.aquaclient.shaded.apache.commons.math3.util.FastMath;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.util.MathUtils;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.util.MedianOf3PivotingStrategy;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.util.PivotingStrategyInterface;
import java.io.Serializable;
import java.util.Arrays;

public class KthSelector
implements Serializable {
    private static final long serialVersionUID = 20140713L;
    private static final int MIN_SELECT_SIZE = 15;
    private final PivotingStrategyInterface pivotingStrategy;

    public KthSelector() {
        this.pivotingStrategy = new MedianOf3PivotingStrategy();
    }

    public KthSelector(PivotingStrategyInterface pivotingStrategyInterface) {
        MathUtils.checkNotNull(pivotingStrategyInterface);
        this.pivotingStrategy = pivotingStrategyInterface;
    }

    public PivotingStrategyInterface getPivotingStrategy() {
        return this.pivotingStrategy;
    }

    public double select(double[] dArray, int[] nArray, int n) {
        boolean bl;
        int n2 = 0;
        int n3 = dArray.length;
        int n4 = 0;
        boolean bl2 = bl = nArray != null;
        while (n3 - n2 > 15) {
            int n5;
            if (bl && n4 < nArray.length && nArray[n4] >= 0) {
                n5 = nArray[n4];
            } else {
                n5 = this.partition(dArray, n2, n3, this.pivotingStrategy.pivotIndex(dArray, n2, n3));
                if (bl && n4 < nArray.length) {
                    nArray[n4] = n5;
                }
            }
            if (n == n5) {
                return dArray[n];
            }
            if (n < n5) {
                n3 = n5;
                n4 = FastMath.min(2 * n4 + 1, bl ? nArray.length : n3);
                continue;
            }
            n2 = n5 + 1;
            n4 = FastMath.min(2 * n4 + 2, bl ? nArray.length : n3);
        }
        Arrays.sort(dArray, n2, n3);
        return dArray[n];
    }

    private int partition(double[] dArray, int n, int n2, int n3) {
        double d2 = dArray[n3];
        dArray[n3] = dArray[n];
        n3 = n + 1;
        int n4 = n2 - 1;
        while (n3 < n4) {
            while (n3 < n4 && dArray[n4] > d2) {
                --n4;
            }
            while (n3 < n4 && dArray[n3] < d2) {
                ++n3;
            }
            if (n3 >= n4) continue;
            double d3 = dArray[n3];
            dArray[n3++] = dArray[n4];
            dArray[n4--] = d3;
        }
        if (n3 >= n2 || dArray[n3] > d2) {
            --n3;
        }
        dArray[n] = dArray[n3];
        dArray[n3] = d2;
        return n3;
    }
}

