/*
 * Decompiled with CFR 0.152.
 */
package games.aquastudios.aquaclient.shaded.apache.commons.math3.util;

import games.aquastudios.aquaclient.shaded.apache.commons.math3.util.Incrementor$MaxCountExceededCallback;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.util.IntegerSequence$Incrementor;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.util.IntegerSequence$Incrementor$MaxCountExceededCallback;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.util.IterationEvent;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.util.IterationListener;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.util.IterationManager$1;
import java.util.Collection;
import java.util.concurrent.CopyOnWriteArrayList;

public class IterationManager {
    private IntegerSequence$Incrementor iterations;
    private final Collection<IterationListener> listeners;

    public IterationManager(int n) {
        this.iterations = IntegerSequence$Incrementor.create().withMaximalCount(n);
        this.listeners = new CopyOnWriteArrayList<IterationListener>();
    }

    @Deprecated
    public IterationManager(int n, Incrementor$MaxCountExceededCallback incrementor$MaxCountExceededCallback) {
        this(n, new IterationManager$1(incrementor$MaxCountExceededCallback));
    }

    public IterationManager(int n, IntegerSequence$Incrementor$MaxCountExceededCallback integerSequence$Incrementor$MaxCountExceededCallback) {
        this.iterations = IntegerSequence$Incrementor.create().withMaximalCount(n).withCallback(integerSequence$Incrementor$MaxCountExceededCallback);
        this.listeners = new CopyOnWriteArrayList<IterationListener>();
    }

    public void addIterationListener(IterationListener iterationListener) {
        this.listeners.add(iterationListener);
    }

    public void fireInitializationEvent(IterationEvent iterationEvent) {
        for (IterationListener iterationListener : this.listeners) {
            iterationListener.initializationPerformed(iterationEvent);
        }
    }

    public void fireIterationPerformedEvent(IterationEvent iterationEvent) {
        for (IterationListener iterationListener : this.listeners) {
            iterationListener.iterationPerformed(iterationEvent);
        }
    }

    public void fireIterationStartedEvent(IterationEvent iterationEvent) {
        for (IterationListener iterationListener : this.listeners) {
            iterationListener.iterationStarted(iterationEvent);
        }
    }

    public void fireTerminationEvent(IterationEvent iterationEvent) {
        for (IterationListener iterationListener : this.listeners) {
            iterationListener.terminationPerformed(iterationEvent);
        }
    }

    public int getIterations() {
        return this.iterations.getCount();
    }

    public int getMaxIterations() {
        return this.iterations.getMaximalCount();
    }

    public void incrementIterationCount() {
        this.iterations.increment();
    }

    public void removeIterationListener(IterationListener iterationListener) {
        this.listeners.remove(iterationListener);
    }

    public void resetIterationCount() {
        this.iterations = this.iterations.withStart(0);
    }
}

