/*
 * Decompiled with CFR 0.152.
 */
package games.aquastudios.aquaclient.shaded.apache.commons.math3.util;

import games.aquastudios.aquaclient.shaded.apache.commons.math3.exception.MathUnsupportedOperationException;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.exception.NotStrictlyPositiveException;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.exception.NullArgumentException;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.exception.ZeroException;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.util.IntegerSequence$Incrementor$1;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.util.IntegerSequence$Incrementor$MaxCountExceededCallback;
import java.util.Iterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IntegerSequence$Incrementor
implements Iterator<Integer> {
    private static final IntegerSequence$Incrementor$MaxCountExceededCallback CALLBACK = new IntegerSequence$Incrementor$1();
    private final int init;
    private final int maximalCount;
    private final int increment;
    private final IntegerSequence$Incrementor$MaxCountExceededCallback maxCountCallback;
    private int count = 0;

    private IntegerSequence$Incrementor(int n, int n2, int n3, IntegerSequence$Incrementor$MaxCountExceededCallback integerSequence$Incrementor$MaxCountExceededCallback) {
        if (integerSequence$Incrementor$MaxCountExceededCallback == null) {
            throw new NullArgumentException();
        }
        this.init = n;
        this.maximalCount = n2;
        this.increment = n3;
        this.maxCountCallback = integerSequence$Incrementor$MaxCountExceededCallback;
        this.count = n;
    }

    public static IntegerSequence$Incrementor create() {
        return new IntegerSequence$Incrementor(0, 0, 1, CALLBACK);
    }

    public IntegerSequence$Incrementor withStart(int n) {
        return new IntegerSequence$Incrementor(n, this.maximalCount, this.increment, this.maxCountCallback);
    }

    public IntegerSequence$Incrementor withMaximalCount(int n) {
        return new IntegerSequence$Incrementor(this.init, n, this.increment, this.maxCountCallback);
    }

    public IntegerSequence$Incrementor withIncrement(int n) {
        if (n == 0) {
            throw new ZeroException();
        }
        return new IntegerSequence$Incrementor(this.init, this.maximalCount, n, this.maxCountCallback);
    }

    public IntegerSequence$Incrementor withCallback(IntegerSequence$Incrementor$MaxCountExceededCallback integerSequence$Incrementor$MaxCountExceededCallback) {
        return new IntegerSequence$Incrementor(this.init, this.maximalCount, this.increment, integerSequence$Incrementor$MaxCountExceededCallback);
    }

    public int getMaximalCount() {
        return this.maximalCount;
    }

    public int getCount() {
        return this.count;
    }

    public boolean canIncrement() {
        return this.canIncrement(1);
    }

    public boolean canIncrement(int n) {
        n = this.count + n * this.increment;
        if (this.increment < 0) {
            return n > this.maximalCount;
        }
        return n < this.maximalCount;
    }

    public void increment(int n) {
        if (n <= 0) {
            throw new NotStrictlyPositiveException(n);
        }
        if (!this.canIncrement(0)) {
            this.maxCountCallback.trigger(this.maximalCount);
        }
        this.count += n * this.increment;
    }

    public void increment() {
        this.increment(1);
    }

    @Override
    public boolean hasNext() {
        return this.canIncrement(0);
    }

    @Override
    public Integer next() {
        int n = this.count;
        this.increment();
        return n;
    }

    @Override
    public void remove() {
        throw new MathUnsupportedOperationException();
    }
}

