/*
 * Decompiled with CFR 0.152.
 */
package games.aquastudios.aquaclient.shaded.apache.commons.math3.util;

import games.aquastudios.aquaclient.shaded.apache.commons.math3.exception.DimensionMismatchException;
import java.io.PrintStream;

class FastMathCalc {
    private static final long HEX_40000000 = 0x40000000L;
    private static final double[] FACT = new double[]{1.0, 1.0, 2.0, 6.0, 24.0, 120.0, 720.0, 5040.0, 40320.0, 362880.0, 3628800.0, 3.99168E7, 4.790016E8, 6.2270208E9, 8.71782912E10, 1.307674368E12, 2.0922789888E13, 3.55687428096E14, 6.402373705728E15, 1.21645100408832E17};
    private static final double[][] LN_SPLIT_COEF = new double[][]{{2.0, 0.0}, {0.6666666269302368, 3.9736429850260626E-8}, {0.3999999761581421, 2.3841857910019882E-8}, {0.2857142686843872, 1.7029898543501842E-8}, {0.2222222089767456, 1.3245471311735498E-8}, {0.1818181574344635, 2.4384203044354907E-8}, {0.1538461446762085, 9.140260083262505E-9}, {0.13333332538604736, 9.220590270857665E-9}, {0.11764700710773468, 1.2393345855018391E-8}, {0.10526403784751892, 8.251545029714408E-9}, {0.0952233225107193, 1.2675934823758863E-8}, {0.08713622391223907, 1.1430250008909141E-8}, {0.07842259109020233, 2.404307984052299E-9}, {0.08371849358081818, 1.176342548272881E-8}, {0.03058958f, 1.2958646899018938E-9}, {0.14982303977012634, 1.225743062930824E-8}};
    private static final String TABLE_START_DECL = "    {";
    private static final String TABLE_END_DECL = "    };";

    private FastMathCalc() {
    }

    private static void buildSinCosTables(double[] dArray, double[] dArray2, double[] dArray3, double[] dArray4, int n, double[] dArray5, double[] dArray6) {
        double[] dArray7;
        double[] dArray8;
        int n2;
        double[] dArray9 = new double[2];
        for (n2 = 0; n2 < 7; ++n2) {
            double d2 = (double)n2 / 8.0;
            FastMathCalc.slowSin(d2, dArray9);
            dArray[n2] = dArray9[0];
            dArray2[n2] = dArray9[1];
            FastMathCalc.slowCos(d2, dArray9);
            dArray3[n2] = dArray9[0];
            dArray4[n2] = dArray9[1];
        }
        for (n2 = 7; n2 < n; ++n2) {
            double[] dArray10 = new double[2];
            dArray8 = new double[2];
            dArray7 = new double[2];
            double[] dArray11 = new double[2];
            double[] dArray12 = new double[2];
            if ((n2 & 1) == 0) {
                dArray10[0] = dArray[n2 / 2];
                dArray10[1] = dArray2[n2 / 2];
                dArray8[0] = dArray3[n2 / 2];
                dArray8[1] = dArray4[n2 / 2];
                FastMathCalc.splitMult(dArray10, dArray8, dArray9);
                dArray[n2] = dArray9[0] * 2.0;
                dArray2[n2] = dArray9[1] * 2.0;
                FastMathCalc.splitMult(dArray8, dArray8, dArray7);
                FastMathCalc.splitMult(dArray10, dArray10, dArray12);
                dArray12[0] = -dArray12[0];
                dArray12[1] = -dArray12[1];
                FastMathCalc.splitAdd(dArray7, dArray12, dArray9);
                dArray3[n2] = dArray9[0];
                dArray4[n2] = dArray9[1];
                continue;
            }
            dArray10[0] = dArray[n2 / 2];
            dArray10[1] = dArray2[n2 / 2];
            dArray8[0] = dArray3[n2 / 2];
            dArray8[1] = dArray4[n2 / 2];
            dArray7[0] = dArray[n2 / 2 + 1];
            dArray7[1] = dArray2[n2 / 2 + 1];
            dArray11[0] = dArray3[n2 / 2 + 1];
            dArray11[1] = dArray4[n2 / 2 + 1];
            FastMathCalc.splitMult(dArray10, dArray11, dArray12);
            FastMathCalc.splitMult(dArray8, dArray7, dArray9);
            FastMathCalc.splitAdd(dArray9, dArray12, dArray9);
            dArray[n2] = dArray9[0];
            dArray2[n2] = dArray9[1];
            FastMathCalc.splitMult(dArray8, dArray11, dArray9);
            FastMathCalc.splitMult(dArray10, dArray7, dArray12);
            dArray12[0] = -dArray12[0];
            dArray12[1] = -dArray12[1];
            FastMathCalc.splitAdd(dArray9, dArray12, dArray9);
            dArray3[n2] = dArray9[0];
            dArray4[n2] = dArray9[1];
        }
        for (n2 = 0; n2 < n; ++n2) {
            double[] dArray13 = new double[2];
            dArray8 = new double[2];
            double[] dArray14 = new double[2];
            dArray7 = dArray14;
            dArray14[0] = dArray3[n2];
            dArray7[1] = dArray4[n2];
            FastMathCalc.splitReciprocal(dArray7, dArray8);
            dArray13[0] = dArray[n2];
            dArray13[1] = dArray2[n2];
            FastMathCalc.splitMult(dArray13, dArray8, dArray7);
            dArray5[n2] = dArray7[0];
            dArray6[n2] = dArray7[1];
        }
    }

    static double slowCos(double d2, double[] dArray) {
        double[] dArray2 = new double[2];
        double[] dArray3 = new double[2];
        double[] dArray4 = new double[2];
        double[] dArray5 = new double[2];
        FastMathCalc.split(d2, dArray2);
        dArray3[1] = 0.0;
        dArray3[0] = 0.0;
        for (int i2 = FACT.length - 1; i2 >= 0; --i2) {
            FastMathCalc.splitMult(dArray2, dArray3, dArray5);
            dArray3[0] = dArray5[0];
            dArray3[1] = dArray5[1];
            if ((i2 & 1) != 0) continue;
            FastMathCalc.split(FACT[i2], dArray5);
            FastMathCalc.splitReciprocal(dArray5, dArray4);
            if ((i2 & 2) != 0) {
                dArray4[0] = -dArray4[0];
                dArray4[1] = -dArray4[1];
            }
            FastMathCalc.splitAdd(dArray3, dArray4, dArray5);
            dArray3[0] = dArray5[0];
            dArray3[1] = dArray5[1];
        }
        if (dArray != null) {
            dArray[0] = dArray3[0];
            dArray[1] = dArray3[1];
        }
        return dArray3[0] + dArray3[1];
    }

    static double slowSin(double d2, double[] dArray) {
        double[] dArray2 = new double[2];
        double[] dArray3 = new double[2];
        double[] dArray4 = new double[2];
        double[] dArray5 = new double[2];
        FastMathCalc.split(d2, dArray2);
        dArray3[1] = 0.0;
        dArray3[0] = 0.0;
        for (int i2 = FACT.length - 1; i2 >= 0; --i2) {
            FastMathCalc.splitMult(dArray2, dArray3, dArray5);
            dArray3[0] = dArray5[0];
            dArray3[1] = dArray5[1];
            if ((i2 & 1) == 0) continue;
            FastMathCalc.split(FACT[i2], dArray5);
            FastMathCalc.splitReciprocal(dArray5, dArray4);
            if ((i2 & 2) != 0) {
                dArray4[0] = -dArray4[0];
                dArray4[1] = -dArray4[1];
            }
            FastMathCalc.splitAdd(dArray3, dArray4, dArray5);
            dArray3[0] = dArray5[0];
            dArray3[1] = dArray5[1];
        }
        if (dArray != null) {
            dArray[0] = dArray3[0];
            dArray[1] = dArray3[1];
        }
        return dArray3[0] + dArray3[1];
    }

    static double slowexp(double d2, double[] dArray) {
        double[] dArray2 = new double[2];
        double[] dArray3 = new double[2];
        double[] dArray4 = new double[2];
        double[] dArray5 = new double[2];
        FastMathCalc.split(d2, dArray2);
        dArray3[1] = 0.0;
        dArray3[0] = 0.0;
        for (int i2 = FACT.length - 1; i2 >= 0; --i2) {
            FastMathCalc.splitMult(dArray2, dArray3, dArray5);
            dArray3[0] = dArray5[0];
            dArray3[1] = dArray5[1];
            FastMathCalc.split(FACT[i2], dArray5);
            FastMathCalc.splitReciprocal(dArray5, dArray4);
            FastMathCalc.splitAdd(dArray3, dArray4, dArray5);
            dArray3[0] = dArray5[0];
            dArray3[1] = dArray5[1];
        }
        if (dArray != null) {
            dArray[0] = dArray3[0];
            dArray[1] = dArray3[1];
        }
        return dArray3[0] + dArray3[1];
    }

    private static void split(double d2, double[] dArray) {
        if (d2 < 8.0E298 && d2 > -8.0E298) {
            double d3 = d2 * 1.073741824E9;
            dArray[0] = d2 + d3 - d3;
            dArray[1] = d2 - dArray[0];
            return;
        }
        double d4 = d2 * 9.313225746154785E-10;
        dArray[0] = (d2 + d4 - d2) * 1.073741824E9;
        dArray[1] = d2 - dArray[0];
    }

    private static void resplit(double[] dArray) {
        double d2 = dArray[0] + dArray[1];
        double d3 = -(d2 - dArray[0] - dArray[1]);
        if (d2 < 8.0E298 && d2 > -8.0E298) {
            double d4 = d2 * 1.073741824E9;
            dArray[0] = d2 + d4 - d4;
            dArray[1] = d2 - dArray[0] + d3;
            return;
        }
        double d5 = d2 * 9.313225746154785E-10;
        dArray[0] = (d2 + d5 - d2) * 1.073741824E9;
        dArray[1] = d2 - dArray[0] + d3;
    }

    private static void splitMult(double[] dArray, double[] dArray2, double[] dArray3) {
        dArray3[0] = dArray[0] * dArray2[0];
        dArray3[1] = dArray[0] * dArray2[1] + dArray[1] * dArray2[0] + dArray[1] * dArray2[1];
        FastMathCalc.resplit(dArray3);
    }

    private static void splitAdd(double[] dArray, double[] dArray2, double[] dArray3) {
        dArray3[0] = dArray[0] + dArray2[0];
        dArray3[1] = dArray[1] + dArray2[1];
        FastMathCalc.resplit(dArray3);
    }

    static void splitReciprocal(double[] dArray, double[] dArray2) {
        if (dArray[0] == 0.0) {
            dArray[0] = dArray[1];
            dArray[1] = 0.0;
        }
        dArray2[0] = 0.9999997615814209 / dArray[0];
        dArray2[1] = (2.384185791015625E-7 * dArray[0] - 0.9999997615814209 * dArray[1]) / (dArray[0] * dArray[0] + dArray[0] * dArray[1]);
        if (dArray2[1] != dArray2[1]) {
            dArray2[1] = 0.0;
        }
        FastMathCalc.resplit(dArray2);
        for (int i2 = 0; i2 < 2; ++i2) {
            double d2 = 1.0 - dArray2[0] * dArray[0] - dArray2[0] * dArray[1] - dArray2[1] * dArray[0] - dArray2[1] * dArray[1];
            dArray2[1] = dArray2[1] + (d2 *= dArray2[0] + dArray2[1]);
        }
    }

    private static void quadMult(double[] dArray, double[] dArray2, double[] dArray3) {
        double[] dArray4 = new double[2];
        double[] dArray5 = new double[2];
        double[] dArray6 = new double[2];
        FastMathCalc.split(dArray[0], dArray4);
        FastMathCalc.split(dArray2[0], dArray5);
        FastMathCalc.splitMult(dArray4, dArray5, dArray6);
        dArray3[0] = dArray6[0];
        dArray3[1] = dArray6[1];
        FastMathCalc.split(dArray2[1], dArray5);
        FastMathCalc.splitMult(dArray4, dArray5, dArray6);
        double d2 = dArray3[0] + dArray6[0];
        dArray3[1] = dArray3[1] - (d2 - dArray3[0] - dArray6[0]);
        dArray3[0] = d2;
        d2 = dArray3[0] + dArray6[1];
        dArray3[1] = dArray3[1] - (d2 - dArray3[0] - dArray6[1]);
        dArray3[0] = d2;
        FastMathCalc.split(dArray[1], dArray4);
        FastMathCalc.split(dArray2[0], dArray5);
        FastMathCalc.splitMult(dArray4, dArray5, dArray6);
        d2 = dArray3[0] + dArray6[0];
        dArray3[1] = dArray3[1] - (d2 - dArray3[0] - dArray6[0]);
        dArray3[0] = d2;
        d2 = dArray3[0] + dArray6[1];
        dArray3[1] = dArray3[1] - (d2 - dArray3[0] - dArray6[1]);
        dArray3[0] = d2;
        FastMathCalc.split(dArray[1], dArray4);
        FastMathCalc.split(dArray2[1], dArray5);
        FastMathCalc.splitMult(dArray4, dArray5, dArray6);
        d2 = dArray3[0] + dArray6[0];
        dArray3[1] = dArray3[1] - (d2 - dArray3[0] - dArray6[0]);
        dArray3[0] = d2;
        d2 = dArray3[0] + dArray6[1];
        dArray3[1] = dArray3[1] - (d2 - dArray3[0] - dArray6[1]);
        dArray3[0] = d2;
    }

    static double expint(int n, double[] dArray) {
        double[] dArray2 = new double[2];
        double[] dArray3 = new double[2];
        double[] dArray4 = new double[2];
        dArray2[0] = Math.E;
        dArray2[1] = 1.4456468917292502E-16;
        FastMathCalc.split(1.0, dArray4);
        while (n > 0) {
            if ((n & 1) != 0) {
                FastMathCalc.quadMult(dArray4, dArray2, dArray3);
                dArray4[0] = dArray3[0];
                dArray4[1] = dArray3[1];
            }
            FastMathCalc.quadMult(dArray2, dArray2, dArray3);
            dArray2[0] = dArray3[0];
            dArray2[1] = dArray3[1];
            n >>= 1;
        }
        if (dArray != null) {
            dArray[0] = dArray4[0];
            dArray[1] = dArray4[1];
            FastMathCalc.resplit(dArray);
        }
        return dArray4[0] + dArray4[1];
    }

    static double[] slowLog(double d2) {
        double[] dArray = new double[2];
        double[] dArray2 = new double[2];
        double[] dArray3 = new double[2];
        double[] dArray4 = new double[2];
        FastMathCalc.split(d2, dArray);
        dArray[0] = dArray[0] + 1.0;
        FastMathCalc.resplit(dArray);
        FastMathCalc.splitReciprocal(dArray, dArray4);
        dArray[0] = dArray[0] - 2.0;
        FastMathCalc.resplit(dArray);
        FastMathCalc.splitMult(dArray, dArray4, dArray3);
        dArray[0] = dArray3[0];
        dArray[1] = dArray3[1];
        FastMathCalc.splitMult(dArray, dArray, dArray2);
        dArray3[0] = LN_SPLIT_COEF[LN_SPLIT_COEF.length - 1][0];
        dArray3[1] = LN_SPLIT_COEF[LN_SPLIT_COEF.length - 1][1];
        for (int i2 = LN_SPLIT_COEF.length - 2; i2 >= 0; --i2) {
            FastMathCalc.splitMult(dArray3, dArray2, dArray4);
            dArray3[0] = dArray4[0];
            dArray3[1] = dArray4[1];
            FastMathCalc.splitAdd(dArray3, LN_SPLIT_COEF[i2], dArray4);
            dArray3[0] = dArray4[0];
            dArray3[1] = dArray4[1];
        }
        FastMathCalc.splitMult(dArray3, dArray, dArray4);
        dArray3[0] = dArray4[0];
        dArray3[1] = dArray4[1];
        return dArray3;
    }

    static void printarray(PrintStream printStream, String string, int n, double[][] dArray) {
        printStream.println(string);
        FastMathCalc.checkLen(n, dArray.length);
        printStream.println("    { ");
        int n2 = 0;
        double[][] dArray2 = dArray;
        int n3 = dArray.length;
        for (int i2 = 0; i2 < n3; ++i2) {
            double[] dArray3 = dArray2[i2];
            printStream.print("        {");
            for (double d2 : dArray3) {
                printStream.printf("%-25.25s", FastMathCalc.format(d2));
            }
            printStream.println("}, // " + n2++);
        }
        printStream.println(TABLE_END_DECL);
    }

    static void printarray(PrintStream printStream, String object, int n, double[] dArray) {
        printStream.println((String)object + "=");
        FastMathCalc.checkLen(n, dArray.length);
        printStream.println(TABLE_START_DECL);
        object = dArray;
        n = dArray.length;
        for (int i2 = 0; i2 < n; ++i2) {
            Object object2 = object[i2];
            printStream.printf("        %s%n", FastMathCalc.format((double)object2));
        }
        printStream.println(TABLE_END_DECL);
    }

    static String format(double d2) {
        double d3 = d2;
        if (d3 != d3) {
            return "Double.NaN,";
        }
        return (d2 >= 0.0 ? "+" : "") + Double.toString(d2) + "d,";
    }

    private static void checkLen(int n, int n2) {
        if (n != n2) {
            throw new DimensionMismatchException(n2, n);
        }
    }
}

