/*
 * Decompiled with CFR 0.152.
 */
package games.aquastudios.aquaclient.shaded.apache.commons.math3.util;

import games.aquastudios.aquaclient.shaded.apache.commons.math3.exception.MathArithmeticException;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.exception.util.LocalizedFormats;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.util.FastMath$CodyWaite;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.util.FastMath$ExpFracTable;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.util.FastMath$ExpIntTable;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.util.FastMath$Split;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.util.FastMath$lnMant;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.util.FastMathCalc;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.util.Precision;
import java.io.PrintStream;

public class FastMath {
    public static final double PI = Math.PI;
    public static final double E = Math.E;
    static final int EXP_INT_TABLE_MAX_INDEX = 750;
    static final int EXP_INT_TABLE_LEN = 1500;
    static final int LN_MANT_LEN = 1024;
    static final int EXP_FRAC_TABLE_LEN = 1025;
    private static final double LOG_MAX_VALUE = StrictMath.log(Double.MAX_VALUE);
    private static final boolean RECOMPUTE_TABLES_AT_RUNTIME = false;
    private static final double LN_2_A = 0.6931470632553101;
    private static final double LN_2_B = 1.1730463525082348E-7;
    private static final double[][] LN_QUICK_COEF = new double[][]{{1.0, 5.669184079525E-24}, {-0.25, -0.25}, {0.3333333134651184, 1.986821492305628E-8}, {-0.25, -6.663542893624021E-14}, {0.19999998807907104, 1.1921056801463227E-8}, {-0.1666666567325592, -7.800414592973399E-9}, {0.1428571343421936, 5.650007086920087E-9}, {-0.1250253f, -7.44321345601866E-11}, {0.11113807559013367, 9.219544613762692E-9}};
    private static final double[][] LN_HI_PREC_COEF = new double[][]{{1.0, -6.032174644509064E-23}, {-0.25, -0.25}, {0.3333333134651184, 1.9868161777724352E-8}, {-0.2499999701976776, -2.957007209750105E-8}, {0.19999954104423523, 1.5830993332061267E-10}, {-0.1662488f, -2.6033824355191673E-8}};
    private static final int SINE_TABLE_LEN = 14;
    private static final double[] SINE_TABLE_A = new double[]{0.0, 0.1246747374534607, 0.24740394949913025, 0.366272509098053, 0.4794255495071411, 0.5850973129272461, 0.6816387176513672, 0.7675435543060303, 0.8414709568023682, 0.902267575263977, 0.9489846229553223, 0.980893f, 0.9974949359893799, 0.9985313415527344};
    private static final double[] SINE_TABLE_B = new double[]{0.0, -4.068233003401932E-9, 9.755392680573412E-9, 1.9987994582857286E-8, -1.0902938113007961E-8, -3.9986783938944604E-8, 4.23719669792332E-8, -5.207000323380292E-8, 2.800552834259E-8, 1.883511811213715E-8, -3.5997360512765566E-9, 4.116164446561962E-8, 5.0614674548127384E-8, -1.0129027912496858E-9};
    private static final double[] COSINE_TABLE_A = new double[]{1.0, 0.9921976327896118, 0.9689123630523682, 0.9305076599121094, 0.8775825500488281, 0.8109631538391113, 0.7316888570785522, 0.6409968137741089, 0.5403022766113281, 0.4311765432357788, 0.3153223395347595, 0.19454771280288696, 0.0707372f, -0.05417713522911072};
    private static final double[] COSINE_TABLE_B = new double[]{0.0, 3.4439717236742845E-8, 5.865827662008209E-8, -3.7999795083850525E-8, 1.184154459111628E-8, -3.43338934259355E-8, 1.1795268640216787E-8, 4.438921624363781E-8, 2.925681159240093E-8, -2.6437112632041807E-8, 2.2860509143963117E-8, -4.813899778443457E-9, 3.6725170580355583E-9, 2.0217439756338078E-10};
    private static final double[] TANGENT_TABLE_A = new double[]{0.0, 0.1256551444530487, 0.25534194707870483, 0.3936265707015991, 0.5463024377822876, 0.7214844226837158, 0.9315965175628662, 1.1974215507507324, 1.5574076175689697, 2.092571258544922, 3.0095696449279785, 5.041914939880371, 14.101419448852539, -18.430862426757812};
    private static final double[] TANGENT_TABLE_B = new double[]{0.0, -7.877917738262007E-9, -2.5857668567479893E-8, 5.2240336371356666E-9, 5.206150291559893E-8, 1.8307188599677033E-8, -5.7618793749770706E-8, 7.848361555046424E-8, 1.0708593250394448E-7, 1.7827257129423813E-8, 2.893485277253286E-8, 3.1660099222737955E-7, 4.983191803254889E-7, -3.356118100840571E-7};
    private static final long[] RECIP_2PI = new long[]{2935890503282001226L, 9154082963658192752L, 3952090531849364496L, 9193070505571053912L, 7910884519577875640L, 113236205062349959L, 4577762542105553359L, -5034868814120038111L, 4208363204685324176L, 5648769086999809661L, 2819561105158720014L, -4035746434778044925L, -302932621132653753L, -2644281811660520851L, -3183605296591799669L, 6722166367014452318L, -3512299194304650054L, -7278142539171889152L};
    private static final long[] PI_O_4_BITS = new long[]{-3958705157555305932L, -4267615245585081135L};
    private static final double[] EIGHTHS = new double[]{0.0, 0.125, 0.25, 0.375, 0.5, 0.625, 0.75, 0.875, 1.0, 1.125, 1.25, 1.375, 1.5, 1.625};
    private static final double[] CBRTTWO = new double[]{0.6299605249474366, 0.7937005259840998, 1.0, 1.2599210498948732, 1.5874010519681994};
    private static final long HEX_40000000 = 0x40000000L;
    private static final long MASK_30BITS = -1073741824L;
    private static final int MASK_NON_SIGN_INT = Integer.MAX_VALUE;
    private static final long MASK_NON_SIGN_LONG = Long.MAX_VALUE;
    private static final long MASK_DOUBLE_EXPONENT = 0x7FF0000000000000L;
    private static final long MASK_DOUBLE_MANTISSA = 0xFFFFFFFFFFFFFL;
    private static final long IMPLICIT_HIGH_BIT = 0x10000000000000L;
    private static final double TWO_POWER_52 = 4.503599627370496E15;
    private static final double F_1_3 = 0.3333333333333333;
    private static final double F_1_5 = 0.2;
    private static final double F_1_7 = 0.14285714285714285;
    private static final double F_1_9 = 0.1111111111111111;
    private static final double F_1_11 = 0.09090909090909091;
    private static final double F_1_13 = 0.07692307692307693;
    private static final double F_1_15 = 0.06666666666666667;
    private static final double F_1_17 = 0.058823529411764705;
    private static final double F_3_4 = 0.75;
    private static final double F_15_16 = 0.9375;
    private static final double F_13_14 = 0.9285714285714286;
    private static final double F_11_12 = 0.9166666666666666;
    private static final double F_9_10 = 0.9;
    private static final double F_7_8 = 0.875;
    private static final double F_5_6 = 0.8333333333333334;
    private static final double F_1_2 = 0.5;
    private static final double F_1_4 = 0.25;

    private FastMath() {
    }

    private static double doubleHighPart(double d2) {
        if (d2 > -Precision.SAFE_MIN && d2 < Precision.SAFE_MIN) {
            return d2;
        }
        long l = Double.doubleToRawLongBits(d2);
        return Double.longBitsToDouble(l &= 0xFFFFFFFFC0000000L);
    }

    public static double sqrt(double d2) {
        return Math.sqrt(d2);
    }

    public static double cosh(double d2) {
        double d3 = d2;
        if (d3 != d3) {
            return d2;
        }
        if (d2 > 20.0) {
            if (d2 >= LOG_MAX_VALUE) {
                double d4 = FastMath.exp(d2 * 0.5);
                return d4 * 0.5 * d4;
            }
            return 0.5 * FastMath.exp(d2);
        }
        if (d2 < -20.0) {
            if (d2 <= -LOG_MAX_VALUE) {
                double d5 = FastMath.exp(d2 * -0.5);
                return d5 * 0.5 * d5;
            }
            return 0.5 * FastMath.exp(-d2);
        }
        double[] dArray = new double[2];
        if (d2 < 0.0) {
            d2 = -d2;
        }
        FastMath.exp(d2, 0.0, dArray);
        double d6 = dArray[0] + dArray[1];
        double d7 = -(d6 - dArray[0] - dArray[1]);
        double d8 = d6 * 1.073741824E9;
        double d9 = d6 + d8 - d8;
        double d10 = d6 - d9;
        double d11 = 1.0 / d6;
        d8 = d11 * 1.073741824E9;
        double d12 = d11 + d8 - d8;
        double d13 = d11 - d12;
        d13 += (1.0 - d9 * d12 - d9 * d13 - d10 * d12 - d10 * d13) * d11;
        d13 += -d7 * d11 * d11;
        d8 = d6 + d12;
        d7 -= d8 - d6 - d12;
        d6 = d8;
        d8 = d6 + d13;
        d7 -= d8 - d6 - d13;
        d6 = d8;
        double d14 = d6 + d7;
        return d14 *= 0.5;
    }

    public static double sinh(double d2) {
        double d3;
        boolean bl = false;
        double d4 = d2;
        if (d4 != d4) {
            return d2;
        }
        if (d2 > 20.0) {
            if (d2 >= LOG_MAX_VALUE) {
                double d5 = FastMath.exp(d2 * 0.5);
                return d5 * 0.5 * d5;
            }
            return 0.5 * FastMath.exp(d2);
        }
        if (d2 < -20.0) {
            if (d2 <= -LOG_MAX_VALUE) {
                double d6 = FastMath.exp(d2 * -0.5);
                return d6 * -0.5 * d6;
            }
            return -0.5 * FastMath.exp(-d2);
        }
        if (d2 == 0.0) {
            return d2;
        }
        if (d2 < 0.0) {
            d2 = -d2;
            bl = true;
        }
        if (d2 > 0.25) {
            double[] dArray = new double[2];
            FastMath.exp(d2, 0.0, dArray);
            double d7 = dArray[0] + dArray[1];
            double d8 = -(d7 - dArray[0] - dArray[1]);
            double d9 = d7 * 1.073741824E9;
            double d10 = d7 + d9 - d9;
            double d11 = d7 - d10;
            double d12 = 1.0 / d7;
            d9 = d12 * 1.073741824E9;
            double d13 = d12 + d9 - d9;
            double d14 = d12 - d13;
            d14 += (1.0 - d10 * d13 - d10 * d14 - d11 * d13 - d11 * d14) * d12;
            d14 += -d8 * d12 * d12;
            d13 = -d13;
            d14 = -d14;
            d9 = d7 + d13;
            d8 -= d9 - d7 - d13;
            d7 = d9;
            d9 = d7 + d14;
            d8 -= d9 - d7 - d14;
            d7 = d9;
            d3 = d7 + d8;
            d3 *= 0.5;
        } else {
            double[] dArray = new double[2];
            FastMath.expm1(d2, dArray);
            double d15 = dArray[0] + dArray[1];
            double d16 = -(d15 - dArray[0] - dArray[1]);
            double d17 = d15 + 1.0;
            double d18 = 1.0 / d17;
            double d19 = -(d17 - 1.0 - d15) + d16;
            double d20 = d15 * d18;
            double d21 = d20 * 1.073741824E9;
            double d22 = d20 + d21 - d21;
            double d23 = d20 - d22;
            d21 = d17 * 1.073741824E9;
            double d24 = d17 + d21 - d21;
            double d25 = d17 - d24;
            d23 += (d15 - d24 * d22 - d24 * d23 - d25 * d22 - d25 * d23) * d18;
            d23 += d16 * d18;
            d23 += -d15 * d19 * d18 * d18;
            d21 = d15 + d22;
            d16 -= d21 - d15 - d22;
            d15 = d21;
            d21 = d15 + d23;
            d16 -= d21 - d15 - d23;
            d15 = d21;
            d3 = d15 + d16;
            d3 *= 0.5;
        }
        if (bl) {
            d3 = -d3;
        }
        return d3;
    }

    public static double tanh(double d2) {
        double d3;
        boolean bl = false;
        double d4 = d2;
        if (d4 != d4) {
            return d2;
        }
        if (d2 > 20.0) {
            return 1.0;
        }
        if (d2 < -20.0) {
            return -1.0;
        }
        if (d2 == 0.0) {
            return d2;
        }
        if (d2 < 0.0) {
            d2 = -d2;
            bl = true;
        }
        if (d2 >= 0.5) {
            double[] dArray = new double[2];
            FastMath.exp(d2 * 2.0, 0.0, dArray);
            double d5 = dArray[0] + dArray[1];
            double d6 = -(d5 - dArray[0] - dArray[1]);
            double d7 = d5 + -1.0;
            double d8 = -(d7 + 1.0 - d5);
            double d9 = d7 + d6;
            d8 -= d9 - d7 - d6;
            d7 = d9;
            double d10 = d5 + 1.0;
            double d11 = -(d10 - 1.0 - d5);
            d9 = d10 + d6;
            d11 -= d9 - d10 - d6;
            d10 = d9;
            d9 = d10 * 1.073741824E9;
            double d12 = d10 + d9 - d9;
            double d13 = d10 - d12;
            double d14 = d7 / d10;
            d9 = d14 * 1.073741824E9;
            double d15 = d14 + d9 - d9;
            double d16 = d14 - d15;
            d16 += (d7 - d12 * d15 - d12 * d16 - d13 * d15 - d13 * d16) / d10;
            d16 += d8 / d10;
            d3 = d15 + (d16 += -d11 * d7 / d10 / d10);
        } else {
            double[] dArray = new double[2];
            FastMath.expm1(d2 * 2.0, dArray);
            double d17 = dArray[0] + dArray[1];
            double d18 = -(d17 - dArray[0] - dArray[1]);
            double d19 = d17;
            double d20 = d18;
            double d21 = d17 + 2.0;
            double d22 = -(d21 - 2.0 - d17);
            double d23 = d21 + d18;
            d22 -= d23 - d21 - d18;
            d21 = d23;
            d23 = d21 * 1.073741824E9;
            double d24 = d21 + d23 - d23;
            double d25 = d21 - d24;
            double d26 = d19 / d21;
            d23 = d26 * 1.073741824E9;
            double d27 = d26 + d23 - d23;
            double d28 = d26 - d27;
            d28 += (d19 - d24 * d27 - d24 * d28 - d25 * d27 - d25 * d28) / d21;
            d28 += d20 / d21;
            d3 = d27 + (d28 += -d22 * d19 / d21 / d21);
        }
        if (bl) {
            d3 = -d3;
        }
        return d3;
    }

    public static double acosh(double d2) {
        double d3 = d2;
        return FastMath.log(d3 + FastMath.sqrt(d3 * d2 - 1.0));
    }

    public static double asinh(double d2) {
        double d3;
        boolean bl = false;
        if (d2 < 0.0) {
            bl = true;
            d2 = -d2;
        }
        if (d2 > 0.167) {
            double d4 = d2;
            d3 = FastMath.log(FastMath.sqrt(d4 * d4 + 1.0) + d2);
        } else {
            double d5 = d2;
            double d6 = d5 * d5;
            d3 = d2 > 0.097 ? d2 * (1.0 - d6 * (0.3333333333333333 - d6 * (0.2 - d6 * (0.14285714285714285 - d6 * (0.1111111111111111 - d6 * (0.09090909090909091 - d6 * (0.07692307692307693 - d6 * (0.06666666666666667 - d6 * 0.058823529411764705 * 0.9375) * 0.9285714285714286) * 0.9166666666666666) * 0.9) * 0.875) * 0.8333333333333334) * 0.75) * 0.5) : (d2 > 0.036 ? d2 * (1.0 - d6 * (0.3333333333333333 - d6 * (0.2 - d6 * (0.14285714285714285 - d6 * (0.1111111111111111 - d6 * (0.09090909090909091 - d6 * 0.07692307692307693 * 0.9166666666666666) * 0.9) * 0.875) * 0.8333333333333334) * 0.75) * 0.5) : (d2 > 0.0036 ? d2 * (1.0 - d6 * (0.3333333333333333 - d6 * (0.2 - d6 * (0.14285714285714285 - d6 * 0.1111111111111111 * 0.875) * 0.8333333333333334) * 0.75) * 0.5) : d2 * (1.0 - d6 * (0.3333333333333333 - d6 * 0.2 * 0.75) * 0.5)));
        }
        if (bl) {
            return -d3;
        }
        return d3;
    }

    public static double atanh(double d2) {
        double d3;
        boolean bl = false;
        if (d2 < 0.0) {
            bl = true;
            d2 = -d2;
        }
        if (d2 > 0.15) {
            d3 = 0.5 * FastMath.log((d2 + 1.0) / (1.0 - d2));
        } else {
            double d4 = d2;
            double d5 = d4 * d4;
            d3 = d2 > 0.087 ? d2 * (1.0 + d5 * (0.3333333333333333 + d5 * (0.2 + d5 * (0.14285714285714285 + d5 * (0.1111111111111111 + d5 * (0.09090909090909091 + d5 * (0.07692307692307693 + d5 * (0.06666666666666667 + d5 * 0.058823529411764705)))))))) : (d2 > 0.031 ? d2 * (1.0 + d5 * (0.3333333333333333 + d5 * (0.2 + d5 * (0.14285714285714285 + d5 * (0.1111111111111111 + d5 * (0.09090909090909091 + d5 * 0.07692307692307693)))))) : (d2 > 0.003 ? d2 * (1.0 + d5 * (0.3333333333333333 + d5 * (0.2 + d5 * (0.14285714285714285 + d5 * 0.1111111111111111)))) : d2 * (1.0 + d5 * (0.3333333333333333 + d5 * 0.2))));
        }
        if (bl) {
            return -d3;
        }
        return d3;
    }

    public static double signum(double d2) {
        if (d2 < 0.0) {
            return -1.0;
        }
        if (d2 > 0.0) {
            return 1.0;
        }
        return d2;
    }

    public static float signum(float f2) {
        if (f2 < 0.0f) {
            return -1.0f;
        }
        if (f2 > 0.0f) {
            return 1.0f;
        }
        return f2;
    }

    public static double nextUp(double d2) {
        return FastMath.nextAfter(d2, Double.POSITIVE_INFINITY);
    }

    public static float nextUp(float f2) {
        return FastMath.nextAfter(f2, Double.POSITIVE_INFINITY);
    }

    public static double nextDown(double d2) {
        return FastMath.nextAfter(d2, Double.NEGATIVE_INFINITY);
    }

    public static float nextDown(float f2) {
        return FastMath.nextAfter(f2, Double.NEGATIVE_INFINITY);
    }

    public static double random() {
        return Math.random();
    }

    public static double exp(double d2) {
        return FastMath.exp(d2, 0.0, null);
    }

    private static double exp(double d2, double d3, double[] dArray) {
        int n = (int)d2;
        if (d2 < 0.0) {
            if (d2 < -746.0) {
                if (dArray != null) {
                    dArray[0] = 0.0;
                    dArray[1] = 0.0;
                }
                return 0.0;
            }
            if (n < -709) {
                double d4 = FastMath.exp(d2 + 40.19140625, d3, dArray) / 2.8504009514401178E17;
                if (dArray != null) {
                    dArray[0] = dArray[0] / 2.8504009514401178E17;
                    dArray[1] = dArray[1] / 2.8504009514401178E17;
                }
                return d4;
            }
            if (n == -709) {
                double d5 = FastMath.exp(d2 + 1.494140625, d3, dArray) / 4.455505956692757;
                if (dArray != null) {
                    dArray[0] = dArray[0] / 4.455505956692757;
                    dArray[1] = dArray[1] / 4.455505956692757;
                }
                return d5;
            }
            --n;
        } else if (n > 709) {
            if (dArray != null) {
                dArray[0] = Double.POSITIVE_INFINITY;
                dArray[1] = 0.0;
            }
            return Double.POSITIVE_INFINITY;
        }
        double d6 = FastMath$ExpIntTable.access$000()[n + 750];
        double d7 = FastMath$ExpIntTable.access$100()[n + 750];
        int n2 = (int)((d2 - (double)n) * 1024.0);
        double d8 = FastMath$ExpFracTable.access$200()[n2];
        double d9 = FastMath$ExpFracTable.access$300()[n2];
        double d10 = d2 - ((double)n + (double)n2 / 1024.0);
        double d11 = d10 * 0.04168701738764507 + 0.1666666505023083;
        d11 = d11 * d10 + 0.5000000000042687;
        d11 = d11 * d10 + 1.0;
        d11 = d11 * d10 + -3.940510424527919E-20;
        double d12 = d6 * d8;
        double d13 = d6 * d9 + d7 * d8 + d7 * d9;
        double d14 = d13 + d12;
        if (d14 == Double.POSITIVE_INFINITY) {
            return Double.POSITIVE_INFINITY;
        }
        double d15 = d3 != 0.0 ? d14 * d3 * d11 + d14 * d3 + d14 * d11 + d13 + d12 : d14 * d11 + d13 + d12;
        if (dArray != null) {
            dArray[0] = d12;
            dArray[1] = d14 * d3 * d11 + d14 * d3 + d14 * d11 + d13;
        }
        return d15;
    }

    public static double expm1(double d2) {
        return FastMath.expm1(d2, null);
    }

    private static double expm1(double d2, double[] dArray) {
        double d3 = d2;
        if (d3 != d3 || d2 == 0.0) {
            return d2;
        }
        if (d2 <= -1.0 || d2 >= 1.0) {
            double[] dArray2 = new double[2];
            FastMath.exp(d2, 0.0, dArray2);
            if (d2 > 0.0) {
                return -1.0 + dArray2[0] + dArray2[1];
            }
            double d4 = -1.0 + dArray2[0];
            double d5 = -(d4 + 1.0 - dArray2[0]);
            return d4 + (d5 += dArray2[1]);
        }
        boolean bl = false;
        if (d2 < 0.0) {
            d2 = -d2;
            bl = true;
        }
        int n = (int)(d2 * 1024.0);
        double d6 = FastMath$ExpFracTable.access$200()[n] - 1.0;
        double d7 = FastMath$ExpFracTable.access$300()[n];
        double d8 = d6 + d7;
        d7 = -(d8 - d6 - d7);
        d6 = d8;
        d8 = d6 * 1.073741824E9;
        double d9 = d6 + d8 - d8;
        double d10 = d7 + (d6 - d9);
        double d11 = d2 - (double)n / 1024.0;
        double d12 = d11 * 0.008336750013465571 + 0.041666663879186654;
        d12 = d12 * d11 + 0.16666666666745392;
        d12 = d12 * d11 + 0.49999999999999994;
        d12 *= d11;
        double d13 = d11;
        double d14 = d13 + (d12 *= d11);
        d12 = -(d14 - d13 - d12);
        d13 = d14;
        d14 = d13 * 1.073741824E9;
        d14 = d13 + d14 - d14;
        d12 += d13 - d14;
        d13 = d14;
        double d15 = d13 * d9;
        d14 = d15 + d13 * d10;
        double d16 = -(d14 - d15 - d13 * d10);
        d15 = d14;
        d14 = d15 + d12 * d9;
        d16 -= d14 - d15 - d12 * d9;
        d15 = d14;
        d14 = d15 + d12 * d10;
        d16 -= d14 - d15 - d12 * d10;
        d15 = d14;
        d14 = d15 + d9;
        d16 -= d14 - d9 - d15;
        d15 = d14;
        d14 = d15 + d13;
        d16 -= d14 - d15 - d13;
        d15 = d14;
        d14 = d15 + d10;
        d16 -= d14 - d15 - d10;
        d15 = d14;
        d14 = d15 + d12;
        d16 -= d14 - d15 - d12;
        d15 = d14;
        if (bl) {
            double d17 = d15 + 1.0;
            double d18 = 1.0 / d17;
            double d19 = -(d17 - 1.0 - d15) + d16;
            double d20 = d15 * d18;
            d14 = d20 * 1.073741824E9;
            double d21 = d20 + d14 - d14;
            double d22 = d20 - d21;
            d14 = d17 * 1.073741824E9;
            d13 = d17 + d14 - d14;
            d12 = d17 - d13;
            d22 += (d15 - d13 * d21 - d13 * d22 - d12 * d21 - d12 * d22) * d18;
            d22 += d16 * d18;
            d22 += -d15 * d19 * d18 * d18;
            d15 = -d21;
            d16 = -d22;
        }
        if (dArray != null) {
            dArray[0] = d15;
            dArray[1] = d16;
        }
        return d15 + d16;
    }

    public static double log(double d2) {
        return FastMath.log(d2, null);
    }

    private static double log(double d2, double[] dArray) {
        double d3;
        double d4;
        double d5;
        double d6;
        double d7;
        long l;
        block19: {
            block18: {
                if (d2 == 0.0) {
                    return Double.NEGATIVE_INFINITY;
                }
                l = Double.doubleToRawLongBits(d2);
                if ((l & Long.MIN_VALUE) != 0L) break block18;
                double d8 = d2;
                if (d8 == d8) break block19;
            }
            if (d2 != 0.0) {
                if (dArray != null) {
                    dArray[0] = Double.NaN;
                }
                return Double.NaN;
            }
        }
        if (d2 == Double.POSITIVE_INFINITY) {
            if (dArray != null) {
                dArray[0] = Double.POSITIVE_INFINITY;
            }
            return Double.POSITIVE_INFINITY;
        }
        int n = (int)(l >> 52) - 1023;
        if ((l & 0x7FF0000000000000L) == 0L) {
            if (d2 == 0.0) {
                if (dArray != null) {
                    dArray[0] = Double.NEGATIVE_INFINITY;
                }
                return Double.NEGATIVE_INFINITY;
            }
            while (((l <<= 1) & 0x10000000000000L) == 0L) {
                --n;
            }
        }
        if ((n == -1 || n == 0) && d2 < 1.01 && d2 > 0.99 && dArray == null) {
            double d9 = d2 - 1.0;
            double d10 = d9 * 1.073741824E9;
            double d11 = d9 + d10 - d10;
            double d12 = d9 - d11;
            d9 = d11;
            double d13 = d12;
            double[] dArray2 = LN_QUICK_COEF[LN_QUICK_COEF.length - 1];
            double d14 = dArray2[0];
            double d15 = dArray2[1];
            for (int i2 = LN_QUICK_COEF.length - 2; i2 >= 0; --i2) {
                d11 = d14 * d9;
                d12 = d14 * d13 + d15 * d9 + d15 * d13;
                d10 = d11 * 1.073741824E9;
                d14 = d11 + d10 - d10;
                d15 = d11 - d14 + d12;
                double[] dArray3 = LN_QUICK_COEF[i2];
                d11 = d14 + dArray3[0];
                d12 = d15 + dArray3[1];
                d10 = d11 * 1.073741824E9;
                d14 = d11 + d10 - d10;
                d15 = d11 - d14 + d12;
            }
            d11 = d14 * d9;
            d12 = d14 * d13 + d15 * d9 + d15 * d13;
            d10 = d11 * 1.073741824E9;
            d14 = d11 + d10 - d10;
            d15 = d11 - d14 + d12;
            return d14 + d15;
        }
        double[] dArray4 = FastMath$lnMant.access$400()[(int)((l & 0xFFC0000000000L) >> 42)];
        double d16 = (double)(l & 0x3FFFFFFFFFFL) / (4.503599627370496E15 + (double)(l & 0xFFC0000000000L));
        double d17 = 0.0;
        if (dArray != null) {
            d7 = d16 * 1.073741824E9;
            d6 = d16 + d7 - d7;
            d5 = d16 - d6;
            d4 = d6;
            double d18 = d5;
            double d19 = l & 0x3FFFFFFFFFFL;
            double d20 = 4.503599627370496E15 + (double)(l & 0xFFC0000000000L);
            d6 = d19 - d4 * d20 - d18 * d20;
            d18 += d6 / d20;
            double[] dArray5 = LN_HI_PREC_COEF[LN_HI_PREC_COEF.length - 1];
            double d21 = dArray5[0];
            double d22 = dArray5[1];
            for (int i3 = LN_HI_PREC_COEF.length - 2; i3 >= 0; --i3) {
                d6 = d21 * d4;
                d5 = d21 * d18 + d22 * d4 + d22 * d18;
                d7 = d6 * 1.073741824E9;
                d21 = d6 + d7 - d7;
                d22 = d6 - d21 + d5;
                double[] dArray6 = LN_HI_PREC_COEF[i3];
                d6 = d21 + dArray6[0];
                d5 = d22 + dArray6[1];
                d7 = d6 * 1.073741824E9;
                d21 = d6 + d7 - d7;
                d22 = d6 - d21 + d5;
            }
            d6 = d21 * d4;
            d5 = d21 * d18 + d22 * d4 + d22 * d18;
            d3 = d6 + d5;
            d17 = -(d3 - d6 - d5);
        } else {
            d3 = d16 * -0.16624882440418567 + 0.19999954120254515;
            d3 = d3 * d16 + -0.2499999997677497;
            d3 = d3 * d16 + 0.3333333333332802;
            d3 = d3 * d16 + -0.5;
            d3 = d3 * d16 + 1.0;
            d3 *= d16;
        }
        d7 = 0.6931470632553101 * (double)n;
        d5 = d7 + dArray4[0];
        d4 = -(d5 - d7 - dArray4[0]);
        d7 = d5;
        d6 = d4 + 0.0;
        d5 = d7 + d3;
        d4 = -(d5 - d7 - d3);
        d7 = d5;
        d6 += d4;
        d5 = d7 + 1.1730463525082348E-7 * (double)n;
        d4 = -(d5 - d7 - 1.1730463525082348E-7 * (double)n);
        d7 = d5;
        d6 += d4;
        d5 = d7 + dArray4[1];
        d4 = -(d5 - d7 - dArray4[1]);
        d7 = d5;
        d6 += d4;
        d5 = d7 + d17;
        d4 = -(d5 - d7 - d17);
        d7 = d5;
        d6 += d4;
        if (dArray != null) {
            dArray[0] = d7;
            dArray[1] = d6;
        }
        return d7 + d6;
    }

    public static double log1p(double d2) {
        if (d2 == -1.0) {
            return Double.NEGATIVE_INFINITY;
        }
        if (d2 == Double.POSITIVE_INFINITY) {
            return Double.POSITIVE_INFINITY;
        }
        if (d2 > 1.0E-6 || d2 < -1.0E-6) {
            double d3 = d2 + 1.0;
            double d4 = -(d3 - 1.0 - d2);
            double[] dArray = new double[2];
            double d5 = FastMath.log(d3, dArray);
            if (Double.isInfinite(d5)) {
                return d5;
            }
            double d6 = d4 / d3;
            double d7 = d6 * 0.5 + 1.0;
            return d7 * d6 + dArray[1] + dArray[0];
        }
        double d8 = (d2 * 0.3333333333333333 - 0.5) * d2 + 1.0;
        return d8 * d2;
    }

    public static double log10(double d2) {
        double[] dArray = new double[2];
        double d3 = FastMath.log(d2, dArray);
        if (Double.isInfinite(d3)) {
            return d3;
        }
        double d4 = dArray[0] * 1.073741824E9;
        double d5 = dArray[0] + d4 - d4;
        double d6 = dArray[0] - d5 + dArray[1];
        return d6 * 1.9699272335463627E-8 + d5 * 1.9699272335463627E-8 + d6 * 0.4342944622039795 + d5 * 0.4342944622039795;
    }

    public static double log(double d2, double d3) {
        return FastMath.log(d3) / FastMath.log(d2);
    }

    public static double pow(double d2, double d3) {
        if (d3 == 0.0) {
            return 1.0;
        }
        long l = Double.doubleToRawLongBits(d3);
        int n = (int)((l & 0x7FF0000000000000L) >> 52);
        long l2 = l & 0xFFFFFFFFFFFFFL;
        long l3 = Double.doubleToRawLongBits(d2);
        int n2 = (int)((l3 & 0x7FF0000000000000L) >> 52);
        long l4 = l3 & 0xFFFFFFFFFFFFFL;
        if (n > 1085) {
            if (n == 2047 && l2 != 0L || n2 == 2047 && l4 != 0L) {
                return Double.NaN;
            }
            if (n2 == 1023 && l4 == 0L) {
                if (n == 2047) {
                    return Double.NaN;
                }
                return 1.0;
            }
            if (d3 > 0.0 ^ n2 < 1023) {
                return Double.POSITIVE_INFINITY;
            }
            return 0.0;
        }
        if (n >= 1023) {
            long l5 = 0x10000000000000L | l2;
            if (n < 1075) {
                long l6 = -1L << 1075 - n;
                if ((l5 & l6) == l5) {
                    long l7 = l5 >> 1075 - n;
                    return FastMath.pow(d2, d3 < 0.0 ? -l7 : l7);
                }
            } else {
                long l8 = l5 << n - 1075;
                return FastMath.pow(d2, d3 < 0.0 ? -l8 : l8);
            }
        }
        if (d2 == 0.0) {
            if (d3 < 0.0) {
                return Double.POSITIVE_INFINITY;
            }
            return 0.0;
        }
        if (n2 == 2047) {
            if (l4 == 0L) {
                if (d3 < 0.0) {
                    return 0.0;
                }
                return Double.POSITIVE_INFINITY;
            }
            return Double.NaN;
        }
        if (d2 < 0.0) {
            return Double.NaN;
        }
        double d4 = d3 * 1.073741824E9;
        double d5 = d3 + d4 - d4;
        double d6 = d3 - d5;
        double[] dArray = new double[2];
        double d7 = FastMath.log(d2, dArray);
        if (Double.isInfinite(d7)) {
            return d7;
        }
        double d8 = dArray[0];
        double d9 = dArray[1];
        double d10 = d8 * 1.073741824E9;
        double d11 = d8 + d10 - d10;
        d9 += d8 - d11;
        d8 = d11;
        double d12 = d8 * d5;
        double d13 = d8 * d6 + d9 * d5 + d9 * d6;
        d8 = d12 + d13;
        d9 = -(d8 - d12 - d13);
        double d14 = d9 * 0.008333333333333333 + 0.041666666666666664;
        d14 = d14 * d9 + 0.16666666666666666;
        d14 = d14 * d9 + 0.5;
        d14 = d14 * d9 + 1.0;
        double d15 = FastMath.exp(d8, d14 *= d9, null);
        return d15;
    }

    public static double pow(double d2, int n) {
        return FastMath.pow(d2, (long)n);
    }

    public static double pow(double d2, long l) {
        if (l == 0L) {
            return 1.0;
        }
        if (l > 0L) {
            return FastMath$Split.access$600(FastMath$Split.access$500(new FastMath$Split(d2), l));
        }
        return FastMath$Split.access$600(FastMath$Split.access$500(new FastMath$Split(d2).reciprocal(), -l));
    }

    private static double polySine(double d2) {
        double d3 = d2;
        double d4 = d3 * d3;
        double d5 = d4 * 2.7553817452272217E-6 + -1.9841269659586505E-4;
        d5 = d5 * d4 + 0.008333333333329196;
        d5 = d5 * d4 + -0.16666666666666666;
        d5 = d5 * d4 * d2;
        return d5;
    }

    private static double polyCosine(double d2) {
        double d3 = d2;
        double d4 = d3 * d3;
        double d5 = d4 * 2.479773539153719E-5 + -0.0013888888689039883;
        d5 = d5 * d4 + 0.041666666666621166;
        d5 = d5 * d4 + -0.49999999999999994;
        return d5 *= d4;
    }

    private static double sinQ(double d2, double d3) {
        int n = (int)(d2 * 8.0 + 0.5);
        double d4 = d2 - EIGHTHS[n];
        double d5 = SINE_TABLE_A[n];
        double d6 = SINE_TABLE_B[n];
        double d7 = COSINE_TABLE_A[n];
        double d8 = COSINE_TABLE_B[n];
        double d9 = d4;
        double d10 = FastMath.polySine(d4);
        double d11 = FastMath.polyCosine(d4);
        double d12 = d9 * 1.073741824E9;
        double d13 = d9 + d12 - d12;
        d10 += d9 - d13;
        d9 = d13;
        double d14 = d5;
        double d15 = d14 + 0.0;
        double d16 = -(d15 - d14);
        double d17 = d15;
        double d18 = d16 + 0.0;
        d14 = d7 * d9;
        d15 = d17 + d14;
        d16 = -(d15 - d17 - d14);
        d17 = d15;
        d18 += d16;
        d18 = d18 + d5 * d11 + d7 * d10;
        d18 = d18 + d6 + d8 * d9 + d6 * d11 + d8 * d10;
        if (d3 != 0.0) {
            d14 = ((d7 + d8) * (d11 + 1.0) - (d5 + d6) * (d9 + d10)) * d3;
            d15 = d17 + d14;
            d16 = -(d15 - d17 - d14);
            d17 = d15;
            d18 += d16;
        }
        double d19 = d17 + d18;
        return d19;
    }

    private static double cosQ(double d2, double d3) {
        double d4 = 1.5707963267948966 - d2;
        double d5 = -(d4 - 1.5707963267948966 + d2);
        return FastMath.sinQ(d4, d5 += 6.123233995736766E-17 - d3);
    }

    private static double tanQ(double d2, double d3, boolean bl) {
        double d4;
        int n = (int)(d2 * 8.0 + 0.5);
        double d5 = d2 - EIGHTHS[n];
        double d6 = SINE_TABLE_A[n];
        double d7 = SINE_TABLE_B[n];
        double d8 = COSINE_TABLE_A[n];
        double d9 = COSINE_TABLE_B[n];
        double d10 = d5;
        double d11 = FastMath.polySine(d5);
        double d12 = FastMath.polyCosine(d5);
        double d13 = d10 * 1.073741824E9;
        double d14 = d10 + d13 - d13;
        d11 += d10 - d14;
        d10 = d14;
        double d15 = d6;
        double d16 = d15 + 0.0;
        double d17 = -(d16 - d15);
        double d18 = d16;
        double d19 = d17 + 0.0;
        d15 = d8 * d10;
        d16 = d18 + d15;
        d17 = -(d16 - d18 - d15);
        d18 = d16;
        d19 += d17;
        d19 += d6 * d12 + d8 * d11;
        double d20 = d18 + (d19 += d7 + d9 * d10 + d7 * d12 + d9 * d11);
        double d21 = -(d20 - d18 - d19);
        d15 = d8;
        d16 = d15 + 0.0;
        d17 = -(d16 - d15);
        d18 = d16;
        d19 = d17 + 0.0;
        d15 = -d6 * d10;
        d16 = d18 + d15;
        d17 = -(d16 - d18 - d15);
        d18 = d16;
        d19 += d17;
        d19 += d9 + d8 * d12 + d9 * d12;
        double d22 = d18 + (d19 -= d7 * d10 + d6 * d11 + d7 * d11);
        double d23 = -(d22 - d18 - d19);
        if (bl) {
            d4 = d22;
            d22 = d20;
            d20 = d4;
            d4 = d23;
            d23 = d21;
            d21 = d4;
        }
        d4 = d20 / d22;
        d13 = d4 * 1.073741824E9;
        double d24 = d4 + d13 - d13;
        double d25 = d4 - d24;
        d13 = d22 * 1.073741824E9;
        double d26 = d22 + d13 - d13;
        double d27 = d22 - d26;
        double d28 = (d20 - d24 * d26 - d24 * d27 - d25 * d26 - d25 * d27) / d22;
        d28 += d21 / d22;
        d28 += -d20 * d23 / d22 / d22;
        if (d3 != 0.0) {
            double d29 = d4;
            double d30 = d3 + d29 * d29 * d3;
            if (bl) {
                d30 = -d30;
            }
            d28 += d30;
        }
        return d4 + d28;
    }

    private static void reducePayneHanek(double d2, double[] dArray) {
        boolean bl;
        long l;
        long l2;
        long l3;
        int n;
        long l4 = Double.doubleToRawLongBits(d2);
        int n2 = (int)(l4 >> 52 & 0x7FFL) - 1023;
        l4 &= 0xFFFFFFFFFFFFFL;
        l4 |= 0x10000000000000L;
        ++n2;
        l4 <<= 11;
        if ((n2 -= (n = n2 >> 6) << 6) != 0) {
            l3 = n == 0 ? 0L : RECIP_2PI[n - 1] << n2;
            l3 = l3 | RECIP_2PI[n] >>> 64 - n2;
            l2 = RECIP_2PI[n] << n2 | RECIP_2PI[n + 1] >>> 64 - n2;
            l = RECIP_2PI[n + 1] << n2 | RECIP_2PI[n + 2] >>> 64 - n2;
        } else {
            l3 = n == 0 ? 0L : RECIP_2PI[n - 1];
            l2 = RECIP_2PI[n];
            l = RECIP_2PI[n + 1];
        }
        long l5 = l4 >>> 32;
        long l6 = l4 & 0xFFFFFFFFL;
        long l7 = l2 >>> 32;
        long l8 = l2 & 0xFFFFFFFFL;
        long l9 = l5 * l7;
        long l10 = l6 * l8;
        long l11 = l6 * l7;
        long l12 = l5 * l8;
        long l13 = l10 + (l12 << 32);
        long l14 = l9 + (l12 >>> 32);
        n2 = (l10 & Long.MIN_VALUE) != 0L ? 1 : 0;
        n = (l12 & 0x80000000L) != 0L ? 1 : 0;
        boolean bl2 = bl = (l13 & Long.MIN_VALUE) != 0L;
        if (n2 != 0 && n != 0 || (n2 != 0 || n != 0) && !bl) {
            ++l14;
        }
        n2 = (l13 & Long.MIN_VALUE) != 0L ? 1 : 0;
        n = (l11 & 0x80000000L) != 0L ? 1 : 0;
        l14 += l11 >>> 32;
        boolean bl3 = bl = ((l13 += l11 << 32) & Long.MIN_VALUE) != 0L;
        if (n2 != 0 && n != 0 || (n2 != 0 || n != 0) && !bl) {
            ++l14;
        }
        l7 = l >>> 32;
        l8 = l & 0xFFFFFFFFL;
        l9 = l5 * l7;
        l11 = l6 * l7;
        l12 = l5 * l8;
        n2 = (l13 & Long.MIN_VALUE) != 0L ? 1 : 0;
        n = ((l9 += l11 + l12 >>> 32) & Long.MIN_VALUE) != 0L ? 1 : 0;
        boolean bl4 = bl = ((l13 += l9) & Long.MIN_VALUE) != 0L;
        if (n2 != 0 && n != 0 || (n2 != 0 || n != 0) && !bl) {
            ++l14;
        }
        l7 = l3 >>> 32;
        l8 = l3 & 0xFFFFFFFFL;
        l10 = l6 * l8;
        l11 = l6 * l7;
        l12 = l5 * l8;
        int n3 = (int)((l14 += l10 + (l11 + l12 << 32)) >>> 62);
        l14 <<= 2;
        l14 |= l13 >>> 62;
        l13 <<= 2;
        l5 = l14 >>> 32;
        l6 = l14 & 0xFFFFFFFFL;
        l7 = PI_O_4_BITS[0] >>> 32;
        l8 = PI_O_4_BITS[0] & 0xFFFFFFFFL;
        l9 = l5 * l7;
        l10 = l6 * l8;
        l11 = l6 * l7;
        l12 = l5 * l8;
        long l15 = l10 + (l12 << 32);
        long l16 = l9 + (l12 >>> 32);
        n2 = (l10 & Long.MIN_VALUE) != 0L ? 1 : 0;
        n = (l12 & 0x80000000L) != 0L ? 1 : 0;
        boolean bl5 = bl = (l15 & Long.MIN_VALUE) != 0L;
        if (n2 != 0 && n != 0 || (n2 != 0 || n != 0) && !bl) {
            ++l16;
        }
        n2 = (l15 & Long.MIN_VALUE) != 0L ? 1 : 0;
        n = (l11 & 0x80000000L) != 0L ? 1 : 0;
        l16 += l11 >>> 32;
        boolean bl6 = bl = ((l15 += l11 << 32) & Long.MIN_VALUE) != 0L;
        if (n2 != 0 && n != 0 || (n2 != 0 || n != 0) && !bl) {
            ++l16;
        }
        l7 = PI_O_4_BITS[1] >>> 32;
        l8 = PI_O_4_BITS[1] & 0xFFFFFFFFL;
        l9 = l5 * l7;
        l11 = l6 * l7;
        l12 = l5 * l8;
        n2 = (l15 & Long.MIN_VALUE) != 0L ? 1 : 0;
        n = ((l9 += l11 + l12 >>> 32) & Long.MIN_VALUE) != 0L ? 1 : 0;
        boolean bl7 = bl = ((l15 += l9) & Long.MIN_VALUE) != 0L;
        if (n2 != 0 && n != 0 || (n2 != 0 || n != 0) && !bl) {
            ++l16;
        }
        l5 = l13 >>> 32;
        l6 = l13 & 0xFFFFFFFFL;
        l7 = PI_O_4_BITS[0] >>> 32;
        l8 = PI_O_4_BITS[0] & 0xFFFFFFFFL;
        l9 = l5 * l7;
        l11 = l6 * l7;
        l12 = l5 * l8;
        n2 = (l15 & Long.MIN_VALUE) != 0L ? 1 : 0;
        n = ((l9 += l11 + l12 >>> 32) & Long.MIN_VALUE) != 0L ? 1 : 0;
        boolean bl8 = bl = ((l15 += l9) & Long.MIN_VALUE) != 0L;
        if (n2 != 0 && n != 0 || (n2 != 0 || n != 0) && !bl) {
            ++l16;
        }
        double d3 = (double)(l16 >>> 12) / 4.503599627370496E15;
        double d4 = (double)(((l16 & 0xFFFL) << 40) + (l15 >>> 24)) / 4.503599627370496E15 / 4.503599627370496E15;
        double d5 = d3 + d4;
        double d6 = -(d5 - d3 - d4);
        dArray[0] = n3;
        dArray[1] = d5 * 2.0;
        dArray[2] = d6 * 2.0;
    }

    public static double sin(double d2) {
        boolean bl = false;
        int n = 0;
        double d3 = 0.0;
        double d4 = d2;
        if (d2 < 0.0) {
            bl = true;
            d4 = -d4;
        }
        if (d4 == 0.0) {
            long l = Double.doubleToRawLongBits(d2);
            if (l < 0L) {
                return -0.0;
            }
            return 0.0;
        }
        double d5 = d4;
        if (d5 != d5 || d4 == Double.POSITIVE_INFINITY) {
            return Double.NaN;
        }
        if (d4 > 3294198.0) {
            double[] dArray = new double[3];
            FastMath.reducePayneHanek(d4, dArray);
            n = (int)dArray[0] & 3;
            d4 = dArray[1];
            d3 = dArray[2];
        } else if (d4 > 1.5707963267948966) {
            FastMath$CodyWaite fastMath$CodyWaite = new FastMath$CodyWaite(d4);
            n = fastMath$CodyWaite.getK() & 3;
            d4 = fastMath$CodyWaite.getRemA();
            d3 = fastMath$CodyWaite.getRemB();
        }
        if (bl) {
            n ^= 2;
        }
        switch (n) {
            case 0: {
                return FastMath.sinQ(d4, d3);
            }
            case 1: {
                return FastMath.cosQ(d4, d3);
            }
            case 2: {
                return -FastMath.sinQ(d4, d3);
            }
            case 3: {
                return -FastMath.cosQ(d4, d3);
            }
        }
        return Double.NaN;
    }

    public static double cos(double d2) {
        int n = 0;
        double d3 = d2;
        if (d2 < 0.0) {
            d3 = -d3;
        }
        double d4 = d3;
        if (d4 != d4 || d3 == Double.POSITIVE_INFINITY) {
            return Double.NaN;
        }
        double d5 = 0.0;
        if (d3 > 3294198.0) {
            double[] dArray = new double[3];
            FastMath.reducePayneHanek(d3, dArray);
            n = (int)dArray[0] & 3;
            d3 = dArray[1];
            d5 = dArray[2];
        } else if (d3 > 1.5707963267948966) {
            FastMath$CodyWaite fastMath$CodyWaite = new FastMath$CodyWaite(d3);
            n = fastMath$CodyWaite.getK() & 3;
            d3 = fastMath$CodyWaite.getRemA();
            d5 = fastMath$CodyWaite.getRemB();
        }
        switch (n) {
            case 0: {
                return FastMath.cosQ(d3, d5);
            }
            case 1: {
                return -FastMath.sinQ(d3, d5);
            }
            case 2: {
                return -FastMath.cosQ(d3, d5);
            }
            case 3: {
                return FastMath.sinQ(d3, d5);
            }
        }
        return Double.NaN;
    }

    public static double tan(double d2) {
        Object object;
        boolean bl = false;
        int n = 0;
        double d3 = d2;
        if (d2 < 0.0) {
            bl = true;
            d3 = -d3;
        }
        if (d3 == 0.0) {
            long l = Double.doubleToRawLongBits(d2);
            if (l < 0L) {
                return -0.0;
            }
            return 0.0;
        }
        double d4 = d3;
        if (d4 != d4 || d3 == Double.POSITIVE_INFINITY) {
            return Double.NaN;
        }
        double d5 = 0.0;
        if (d3 > 3294198.0) {
            object = new double[3];
            FastMath.reducePayneHanek(d3, (double[])object);
            n = (int)object[0] & 3;
            d3 = object[1];
            d5 = (double)object[2];
        } else if (d3 > 1.5707963267948966) {
            FastMath$CodyWaite fastMath$CodyWaite = new FastMath$CodyWaite(d3);
            object = fastMath$CodyWaite;
            n = fastMath$CodyWaite.getK() & 3;
            d3 = ((FastMath$CodyWaite)object).getRemA();
            d5 = ((FastMath$CodyWaite)object).getRemB();
        }
        if (d3 > 1.5) {
            double d6 = 1.5707963267948966 - d3;
            double d7 = -(d6 - 1.5707963267948966 + d3);
            d3 = d6 + (d7 += 6.123233995736766E-17 - d5);
            d5 = -(d3 - d6 - d7);
            n ^= 1;
            bl ^= true;
        }
        double d8 = !(n & true) ? FastMath.tanQ(d3, d5, false) : -FastMath.tanQ(d3, d5, true);
        if (bl) {
            d8 = -d8;
        }
        return d8;
    }

    public static double atan(double d2) {
        return FastMath.atan(d2, 0.0, false);
    }

    private static double atan(double d2, double d3, boolean bl) {
        double d4;
        double d5;
        double d6;
        double d7;
        double d8;
        double d9;
        double d10;
        int n;
        boolean bl2;
        if (d2 == 0.0) {
            if (bl) {
                return FastMath.copySign(Math.PI, d2);
            }
            return d2;
        }
        if (d2 < 0.0) {
            d2 = -d2;
            d3 = -d3;
            bl2 = true;
        } else {
            bl2 = false;
        }
        if (d2 > 1.633123935319537E16) {
            if (bl2 ^ bl) {
                return -1.5707963267948966;
            }
            return 1.5707963267948966;
        }
        if (d2 < 1.0) {
            n = (int)((d2 * -1.7168146928204135 * d2 + 8.0) * d2 + 0.5);
        } else {
            d10 = 1.0 / d2;
            n = (int)(-((d10 * -1.7168146928204135 * d10 + 8.0) * d10) + 13.07);
        }
        d10 = TANGENT_TABLE_A[n];
        double d11 = TANGENT_TABLE_B[n];
        double d12 = d2 - d10;
        double d13 = -(d12 - d2 + d10);
        double d14 = d12 + (d13 += d3 - d11);
        d13 = -(d14 - d12 - d13);
        d12 = d14;
        d14 = d2 * 1.073741824E9;
        double d15 = d2 + d14 - d14;
        double d16 = d3 + d2 - d15;
        d2 = d15;
        d3 += d16;
        if (n == 0) {
            d9 = 1.0 / (1.0 + (d2 + d3) * (d10 + d11));
            d15 = d12 * d9;
            d16 = d13 * d9;
        } else {
            d9 = d2 * d10;
            d8 = d9 + 1.0;
            d7 = -(d8 - 1.0 - d9);
            d9 = d3 * d10 + d2 * d11;
            d14 = d8 + d9;
            d7 -= d14 - d8 - d9;
            d8 = d14;
            d7 += d3 * d11;
            d15 = d12 / d8;
            d14 = d15 * 1.073741824E9;
            d6 = d15 + d14 - d14;
            d5 = d15 - d6;
            d14 = d8 * 1.073741824E9;
            d4 = d8 + d14 - d14;
            double d17 = d8 - d4;
            d16 = (d12 - d6 * d4 - d6 * d17 - d5 * d4 - d5 * d17) / d8;
            d16 += -d12 * d7 / d8 / d8;
            d16 += d13 / d8;
        }
        d12 = d15;
        d13 = d16;
        double d18 = d12;
        d9 = d18 * d18;
        d16 = d9 * 0.07490822288864472 - 0.09088450866185192;
        d16 = d16 * d9 + 0.11111095942313305;
        d16 = d16 * d9 - 0.1428571423679182;
        d16 = d16 * d9 + 0.19999999999923582;
        d16 = d16 * d9 - 0.33333333333333287;
        d16 = d16 * d9 * d12;
        d15 = d12;
        d14 = d15 + d16;
        d16 = -(d14 - d15 - d16);
        d15 = d14;
        double d19 = d12;
        d8 = EIGHTHS[n];
        d7 = d8 + d15;
        d6 = -(d7 - d8 - d15);
        d14 = d7 + (d16 += d13 / (1.0 + d19 * d19));
        d6 -= d14 - d7 - d16;
        d7 = d14;
        d5 = d7 + d6;
        if (bl) {
            d4 = -(d5 - d7 - d6);
            d7 = Math.PI - d5;
            d6 = -(d7 - Math.PI + d5);
            d5 = d7 + (d6 += 1.2246467991473532E-16 - d4);
        }
        if (bl2 ^ bl) {
            d5 = -d5;
        }
        return d5;
    }

    public static double atan2(double d2, double d3) {
        double d4;
        block26: {
            block25: {
                double d5 = d3;
                if (d5 != d5) break block25;
                double d6 = d2;
                if (d6 == d6) break block26;
            }
            return Double.NaN;
        }
        if (d2 == 0.0) {
            double d7 = d3 * d2;
            double d8 = 1.0 / d3;
            double d9 = 1.0 / d2;
            if (d8 == 0.0) {
                if (d3 > 0.0) {
                    return d2;
                }
                return FastMath.copySign(Math.PI, d2);
            }
            if (d3 < 0.0 || d8 < 0.0) {
                if (d2 < 0.0 || d9 < 0.0) {
                    return -Math.PI;
                }
                return Math.PI;
            }
            return d7;
        }
        if (d2 == Double.POSITIVE_INFINITY) {
            if (d3 == Double.POSITIVE_INFINITY) {
                return 0.7853981633974483;
            }
            if (d3 == Double.NEGATIVE_INFINITY) {
                return 2.356194490192345;
            }
            return 1.5707963267948966;
        }
        if (d2 == Double.NEGATIVE_INFINITY) {
            if (d3 == Double.POSITIVE_INFINITY) {
                return -0.7853981633974483;
            }
            if (d3 == Double.NEGATIVE_INFINITY) {
                return -2.356194490192345;
            }
            return -1.5707963267948966;
        }
        if (d3 == Double.POSITIVE_INFINITY) {
            if (d2 > 0.0 || 1.0 / d2 > 0.0) {
                return 0.0;
            }
            if (d2 < 0.0 || 1.0 / d2 < 0.0) {
                return -0.0;
            }
        }
        if (d3 == Double.NEGATIVE_INFINITY) {
            if (d2 > 0.0 || 1.0 / d2 > 0.0) {
                return Math.PI;
            }
            if (d2 < 0.0 || 1.0 / d2 < 0.0) {
                return -Math.PI;
            }
        }
        if (d3 == 0.0) {
            if (d2 > 0.0 || 1.0 / d2 > 0.0) {
                return 1.5707963267948966;
            }
            if (d2 < 0.0 || 1.0 / d2 < 0.0) {
                return -1.5707963267948966;
            }
        }
        if (Double.isInfinite(d4 = d2 / d3)) {
            return FastMath.atan(d4, 0.0, d3 < 0.0);
        }
        double d10 = FastMath.doubleHighPart(d4);
        double d11 = d4 - d10;
        double d12 = FastMath.doubleHighPart(d3);
        double d13 = d3 - d12;
        d11 += (d2 - d10 * d12 - d10 * d13 - d11 * d12 - d11 * d13) / d3;
        double d14 = d10 + d11;
        d11 = -(d14 - d10 - d11);
        d10 = d14;
        if (d10 == 0.0) {
            d10 = FastMath.copySign(0.0, d2);
        }
        double d15 = FastMath.atan(d10, d11, d3 < 0.0);
        return d15;
    }

    public static double asin(double d2) {
        double d3 = d2;
        if (d3 != d3) {
            return Double.NaN;
        }
        if (d2 > 1.0 || d2 < -1.0) {
            return Double.NaN;
        }
        if (d2 == 1.0) {
            return 1.5707963267948966;
        }
        if (d2 == -1.0) {
            return -1.5707963267948966;
        }
        if (d2 == 0.0) {
            return d2;
        }
        double d4 = d2 * 1.073741824E9;
        double d5 = d2 + d4 - d4;
        double d6 = d2 - d5;
        double d7 = d5;
        double d8 = d7 * d7;
        double d9 = d6;
        double d10 = d5 * d6 * 2.0 + d9 * d9;
        d8 = -d8;
        d10 = -d10;
        double d11 = d8 + 1.0;
        double d12 = -(d11 - 1.0 - d8);
        d4 = d11 + d10;
        d12 -= d4 - d11 - d10;
        d11 = d4;
        double d13 = FastMath.sqrt(d11);
        d4 = d13 * 1.073741824E9;
        d8 = d13 + d4 - d4;
        d10 = d13 - d8;
        double d14 = d8;
        double d15 = d10;
        d10 += (d11 - d14 * d14 - d8 * 2.0 * d10 - d15 * d15) / (d13 * 2.0);
        double d16 = d12 / (d13 * 2.0);
        double d17 = d2 / d13;
        d4 = d17 * 1.073741824E9;
        double d18 = d17 + d4 - d4;
        double d19 = d17 - d18;
        d19 += (d2 - d18 * d8 - d18 * d10 - d19 * d8 - d19 * d10) / d13;
        d4 = d18 + (d19 += -d2 * d16 / d13 / d13);
        d19 = -(d4 - d18 - d19);
        d18 = d4;
        return FastMath.atan(d18, d19, false);
    }

    public static double acos(double d2) {
        double d3 = d2;
        if (d3 != d3) {
            return Double.NaN;
        }
        if (d2 > 1.0 || d2 < -1.0) {
            return Double.NaN;
        }
        if (d2 == -1.0) {
            return Math.PI;
        }
        if (d2 == 1.0) {
            return 0.0;
        }
        if (d2 == 0.0) {
            return 1.5707963267948966;
        }
        double d4 = d2 * 1.073741824E9;
        double d5 = d2 + d4 - d4;
        double d6 = d2 - d5;
        double d7 = d5;
        double d8 = d7 * d7;
        double d9 = d6;
        double d10 = d5 * d6 * 2.0 + d9 * d9;
        d8 = -d8;
        d10 = -d10;
        double d11 = d8 + 1.0;
        double d12 = -(d11 - 1.0 - d8);
        d4 = d11 + d10;
        d12 -= d4 - d11 - d10;
        d11 = d4;
        double d13 = FastMath.sqrt(d11);
        d4 = d13 * 1.073741824E9;
        d8 = d13 + d4 - d4;
        d10 = d13 - d8;
        double d14 = d8;
        double d15 = d10;
        d10 += (d11 - d14 * d14 - d8 * 2.0 * d10 - d15 * d15) / (d13 * 2.0);
        d10 += d12 / (d13 * 2.0);
        d13 = d8 + d10;
        d10 = -(d13 - d8 - d10);
        double d16 = d13 / d2;
        if (Double.isInfinite(d16)) {
            return 1.5707963267948966;
        }
        double d17 = FastMath.doubleHighPart(d16);
        double d18 = d16 - d17;
        d18 += (d13 - d17 * d5 - d17 * d6 - d18 * d5 - d18 * d6) / d2;
        d4 = d17 + (d18 += d10 / d2);
        d18 = -(d4 - d17 - d18);
        d17 = d4;
        return FastMath.atan(d17, d18, d2 < 0.0);
    }

    public static double cbrt(double d2) {
        long l = Double.doubleToRawLongBits(d2);
        int n = (int)(l >> 52 & 0x7FFL) - 1023;
        boolean bl = false;
        if (n == -1023) {
            if (d2 == 0.0) {
                return d2;
            }
            bl = true;
            l = Double.doubleToRawLongBits(d2 *= 1.8014398509481984E16);
            n = (int)(l >> 52 & 0x7FFL) - 1023;
        }
        if (n == 1024) {
            return d2;
        }
        int n2 = n / 3;
        double d3 = Double.longBitsToDouble(l & Long.MIN_VALUE | (long)(n2 + 1023 & 0x7FF) << 52);
        double d4 = Double.longBitsToDouble(l & 0xFFFFFFFFFFFFFL | 0x3FF0000000000000L);
        double d5 = d4 * -0.010714690733195933 + 0.0875862700108075;
        d5 = d5 * d4 + -0.3058015757857271;
        d5 = d5 * d4 + 0.7249995199969751;
        d5 = d5 * d4 + 0.5039018405998233;
        double d6 = d3;
        double d7 = d2 / (d6 * d6 * d3);
        double d8 = d5 *= CBRTTWO[n % 3 + 2];
        d5 += (d7 - d8 * d8 * d5) / (d5 * 3.0 * d5);
        double d9 = d5;
        d5 += (d7 - d9 * d9 * d5) / (d5 * 3.0 * d5);
        double d10 = d5 * 1.073741824E9;
        double d11 = d5 + d10 - d10;
        double d12 = d5 - d11;
        double d13 = d11;
        double d14 = d13 * d13;
        double d15 = d12;
        double d16 = d11 * d12 * 2.0 + d15 * d15;
        d10 = d14 * 1.073741824E9;
        double d17 = d14 + d10 - d10;
        d16 += d14 - d17;
        d14 = d17;
        d16 = d14 * d12 + d11 * d16 + d16 * d12;
        double d18 = d7 - (d14 *= d11);
        double d19 = -(d18 - d7 + d14);
        d5 += (d18 + (d19 -= d16)) / (d5 * 3.0 * d5);
        d5 *= d3;
        if (bl) {
            d5 *= 3.814697265625E-6;
        }
        return d5;
    }

    public static double toRadians(double d2) {
        if (Double.isInfinite(d2) || d2 == 0.0) {
            return d2;
        }
        double d3 = FastMath.doubleHighPart(d2);
        double d4 = d2 - d3;
        double d5 = d4 * 1.997844754509471E-9 + d4 * 0.01745329052209854 + d3 * 1.997844754509471E-9 + d3 * 0.01745329052209854;
        if (d5 == 0.0) {
            d5 *= d2;
        }
        return d5;
    }

    public static double toDegrees(double d2) {
        if (Double.isInfinite(d2) || d2 == 0.0) {
            return d2;
        }
        double d3 = FastMath.doubleHighPart(d2);
        double d4 = d2 - d3;
        return d4 * 3.145894820876798E-6 + d4 * 57.2957763671875 + d3 * 3.145894820876798E-6 + d3 * 57.2957763671875;
    }

    public static int abs(int n) {
        int n2 = n >>> 31;
        return (n ^ ~n2 + 1) + n2;
    }

    public static long abs(long l) {
        long l2 = l >>> 63;
        return (l ^ (l2 ^ 0xFFFFFFFFFFFFFFFFL) + 1L) + l2;
    }

    public static float abs(float f2) {
        return Float.intBitsToFloat(Integer.MAX_VALUE & Float.floatToRawIntBits(f2));
    }

    public static double abs(double d2) {
        return Double.longBitsToDouble(Long.MAX_VALUE & Double.doubleToRawLongBits(d2));
    }

    public static double ulp(double d2) {
        if (Double.isInfinite(d2)) {
            return Double.POSITIVE_INFINITY;
        }
        double d3 = d2;
        return FastMath.abs(d3 - Double.longBitsToDouble(Double.doubleToRawLongBits(d3) ^ 1L));
    }

    public static float ulp(float f2) {
        if (Float.isInfinite(f2)) {
            return Float.POSITIVE_INFINITY;
        }
        float f3 = f2;
        return FastMath.abs(f3 - Float.intBitsToFloat(Float.floatToIntBits(f3) ^ 1));
    }

    public static double scalb(double d2, int n) {
        if (n > -1023 && n < 1024) {
            return d2 * Double.longBitsToDouble((long)(n + 1023) << 52);
        }
        if (Double.isNaN(d2) || Double.isInfinite(d2) || d2 == 0.0) {
            return d2;
        }
        if (n < -2098) {
            if (d2 > 0.0) {
                return 0.0;
            }
            return -0.0;
        }
        if (n > 2097) {
            if (d2 > 0.0) {
                return Double.POSITIVE_INFINITY;
            }
            return Double.NEGATIVE_INFINITY;
        }
        long l = Double.doubleToRawLongBits(d2);
        long l2 = l & Long.MIN_VALUE;
        int n2 = (int)(l >>> 52) & 0x7FF;
        long l3 = l & 0xFFFFFFFFFFFFFL;
        int n3 = n2 + n;
        if (n < 0) {
            if (n3 > 0) {
                return Double.longBitsToDouble(l2 | (long)n3 << 52 | l3);
            }
            if (n3 > -53) {
                long l4 = (l3 |= 0x10000000000000L) & 1L << -n3;
                l3 >>>= 1 - n3;
                if (l4 != 0L) {
                    ++l3;
                }
                return Double.longBitsToDouble(l2 | l3);
            }
            if (l2 == 0L) {
                return 0.0;
            }
            return -0.0;
        }
        if (n2 == 0) {
            while (l3 >>> 52 != 1L) {
                l3 <<= 1;
                --n3;
            }
            l3 &= 0xFFFFFFFFFFFFFL;
            if (++n3 < 2047) {
                return Double.longBitsToDouble(l2 | (long)n3 << 52 | l3);
            }
            if (l2 == 0L) {
                return Double.POSITIVE_INFINITY;
            }
            return Double.NEGATIVE_INFINITY;
        }
        if (n3 < 2047) {
            return Double.longBitsToDouble(l2 | (long)n3 << 52 | l3);
        }
        if (l2 == 0L) {
            return Double.POSITIVE_INFINITY;
        }
        return Double.NEGATIVE_INFINITY;
    }

    public static float scalb(float f2, int n) {
        if (n > -127 && n < 128) {
            return f2 * Float.intBitsToFloat(n + 127 << 23);
        }
        if (Float.isNaN(f2) || Float.isInfinite(f2) || f2 == 0.0f) {
            return f2;
        }
        if (n < -277) {
            if (f2 > 0.0f) {
                return 0.0f;
            }
            return -0.0f;
        }
        if (n > 276) {
            if (f2 > 0.0f) {
                return Float.POSITIVE_INFINITY;
            }
            return Float.NEGATIVE_INFINITY;
        }
        int n2 = Float.floatToIntBits(f2);
        int n3 = n2 & Integer.MIN_VALUE;
        int n4 = n2 >>> 23 & 0xFF;
        n2 &= 0x7FFFFF;
        int n5 = n4 + n;
        if (n < 0) {
            if (n5 > 0) {
                return Float.intBitsToFloat(n3 | n5 << 23 | n2);
            }
            if (n5 > -24) {
                n = (n2 |= 0x800000) & 1 << -n5;
                n2 >>>= 1 - n5;
                if (n != 0) {
                    ++n2;
                }
                return Float.intBitsToFloat(n3 | n2);
            }
            if (n3 == 0) {
                return 0.0f;
            }
            return -0.0f;
        }
        if (n4 == 0) {
            while (n2 >>> 23 != 1) {
                n2 <<= 1;
                --n5;
            }
            n2 &= 0x7FFFFF;
            if (++n5 < 255) {
                return Float.intBitsToFloat(n3 | n5 << 23 | n2);
            }
            if (n3 == 0) {
                return Float.POSITIVE_INFINITY;
            }
            return Float.NEGATIVE_INFINITY;
        }
        if (n5 < 255) {
            return Float.intBitsToFloat(n3 | n5 << 23 | n2);
        }
        if (n3 == 0) {
            return Float.POSITIVE_INFINITY;
        }
        return Float.NEGATIVE_INFINITY;
    }

    public static double nextAfter(double d2, double d3) {
        long l;
        long l2;
        if (Double.isNaN(d2) || Double.isNaN(d3)) {
            return Double.NaN;
        }
        if (d2 == d3) {
            return d3;
        }
        if (Double.isInfinite(d2)) {
            if (d2 < 0.0) {
                return -1.7976931348623157E308;
            }
            return Double.MAX_VALUE;
        }
        if (d2 == 0.0) {
            if (d3 < 0.0) {
                return -4.9E-324;
            }
            return Double.MIN_VALUE;
        }
        if (d3 < d2 ^ (l2 = (l = Double.doubleToRawLongBits(d2)) & Long.MIN_VALUE) == 0L) {
            return Double.longBitsToDouble(l2 | (l & Long.MAX_VALUE) + 1L);
        }
        return Double.longBitsToDouble(l2 | (l & Long.MAX_VALUE) - 1L);
    }

    public static float nextAfter(float f2, double d2) {
        int n;
        int n2;
        if (Double.isNaN(f2) || Double.isNaN(d2)) {
            return Float.NaN;
        }
        if ((double)f2 == d2) {
            return (float)d2;
        }
        if (Float.isInfinite(f2)) {
            if (f2 < 0.0f) {
                return -3.4028235E38f;
            }
            return Float.MAX_VALUE;
        }
        if (f2 == 0.0f) {
            if (d2 < 0.0) {
                return -1.4E-45f;
            }
            return Float.MIN_VALUE;
        }
        if (d2 < (double)f2 ^ (n2 = (n = Float.floatToIntBits(f2)) & Integer.MIN_VALUE) == 0) {
            return Float.intBitsToFloat(n2 | (n & Integer.MAX_VALUE) + 1);
        }
        return Float.intBitsToFloat(n2 | (n & Integer.MAX_VALUE) - 1);
    }

    public static double floor(double d2) {
        double d3 = d2;
        if (d3 != d3) {
            return d2;
        }
        if (d2 >= 4.503599627370496E15 || d2 <= -4.503599627370496E15) {
            return d2;
        }
        long l = (long)d2;
        if (d2 < 0.0 && (double)l != d2) {
            --l;
        }
        if (l == 0L) {
            return d2 * (double)l;
        }
        return l;
    }

    public static double ceil(double d2) {
        double d3 = d2;
        if (d3 != d3) {
            return d2;
        }
        double d4 = FastMath.floor(d2);
        if (d4 == d2) {
            return d4;
        }
        if ((d4 += 1.0) == 0.0) {
            return d2 * d4;
        }
        return d4;
    }

    public static double rint(double d2) {
        double d3;
        double d4 = FastMath.floor(d2);
        double d5 = d2 - d4;
        if (d3 > 0.5) {
            if (d4 == -1.0) {
                return -0.0;
            }
            return d4 + 1.0;
        }
        if (d5 < 0.5) {
            return d4;
        }
        long l = (long)d4;
        if ((l & 1L) == 0L) {
            return d4;
        }
        return d4 + 1.0;
    }

    public static long round(double d2) {
        return (long)FastMath.floor(d2 + 0.5);
    }

    public static int round(float f2) {
        return (int)FastMath.floor(f2 + 0.5f);
    }

    public static int min(int n, int n2) {
        if (n <= n2) {
            return n;
        }
        return n2;
    }

    public static long min(long l, long l2) {
        if (l <= l2) {
            return l;
        }
        return l2;
    }

    public static float min(float f2, float f3) {
        if (f2 > f3) {
            return f3;
        }
        if (f2 < f3) {
            return f2;
        }
        if (f2 != f3) {
            return Float.NaN;
        }
        int n = Float.floatToRawIntBits(f2);
        if (n == Integer.MIN_VALUE) {
            return f2;
        }
        return f3;
    }

    public static double min(double d2, double d3) {
        if (d2 > d3) {
            return d3;
        }
        if (d2 < d3) {
            return d2;
        }
        if (d2 != d3) {
            return Double.NaN;
        }
        long l = Double.doubleToRawLongBits(d2);
        if (l == Long.MIN_VALUE) {
            return d2;
        }
        return d3;
    }

    public static int max(int n, int n2) {
        if (n <= n2) {
            return n2;
        }
        return n;
    }

    public static long max(long l, long l2) {
        if (l <= l2) {
            return l2;
        }
        return l;
    }

    public static float max(float f2, float f3) {
        if (f2 > f3) {
            return f2;
        }
        if (f2 < f3) {
            return f3;
        }
        if (f2 != f3) {
            return Float.NaN;
        }
        int n = Float.floatToRawIntBits(f2);
        if (n == Integer.MIN_VALUE) {
            return f3;
        }
        return f2;
    }

    public static double max(double d2, double d3) {
        if (d2 > d3) {
            return d2;
        }
        if (d2 < d3) {
            return d3;
        }
        if (d2 != d3) {
            return Double.NaN;
        }
        long l = Double.doubleToRawLongBits(d2);
        if (l == Long.MIN_VALUE) {
            return d3;
        }
        return d2;
    }

    public static double hypot(double d2, double d3) {
        int n;
        if (Double.isInfinite(d2) || Double.isInfinite(d3)) {
            return Double.POSITIVE_INFINITY;
        }
        if (Double.isNaN(d2) || Double.isNaN(d3)) {
            return Double.NaN;
        }
        int n2 = FastMath.getExponent(d2);
        if (n2 > (n = FastMath.getExponent(d3)) + 27) {
            return FastMath.abs(d2);
        }
        if (n > n2 + 27) {
            return FastMath.abs(d3);
        }
        n2 = (n2 + n) / 2;
        double d4 = FastMath.scalb(d2, -n2);
        double d5 = FastMath.scalb(d3, -n2);
        double d6 = d4;
        double d7 = d5;
        double d8 = FastMath.sqrt(d6 * d6 + d7 * d7);
        return FastMath.scalb(d8, n2);
    }

    public static double IEEEremainder(double d2, double d3) {
        return StrictMath.IEEEremainder(d2, d3);
    }

    public static int toIntExact(long l) {
        if (l < Integer.MIN_VALUE || l > Integer.MAX_VALUE) {
            throw new MathArithmeticException(LocalizedFormats.OVERFLOW, new Object[0]);
        }
        return (int)l;
    }

    public static int incrementExact(int n) {
        if (n == Integer.MAX_VALUE) {
            throw new MathArithmeticException(LocalizedFormats.OVERFLOW_IN_ADDITION, n, 1);
        }
        return n + 1;
    }

    public static long incrementExact(long l) {
        if (l == Long.MAX_VALUE) {
            throw new MathArithmeticException(LocalizedFormats.OVERFLOW_IN_ADDITION, l, 1);
        }
        return l + 1L;
    }

    public static int decrementExact(int n) {
        if (n == Integer.MIN_VALUE) {
            throw new MathArithmeticException(LocalizedFormats.OVERFLOW_IN_SUBTRACTION, n, 1);
        }
        return n - 1;
    }

    public static long decrementExact(long l) {
        if (l == Long.MIN_VALUE) {
            throw new MathArithmeticException(LocalizedFormats.OVERFLOW_IN_SUBTRACTION, l, 1);
        }
        return l - 1L;
    }

    public static int addExact(int n, int n2) {
        int n3 = n + n2;
        if ((n ^ n2) >= 0 && (n3 ^ n2) < 0) {
            throw new MathArithmeticException(LocalizedFormats.OVERFLOW_IN_ADDITION, n, n2);
        }
        return n3;
    }

    public static long addExact(long l, long l2) {
        long l3 = l + l2;
        if ((l ^ l2) >= 0L && (l3 ^ l2) < 0L) {
            throw new MathArithmeticException(LocalizedFormats.OVERFLOW_IN_ADDITION, l, l2);
        }
        return l3;
    }

    public static int subtractExact(int n, int n2) {
        int n3 = n - n2;
        if ((n ^ n2) < 0 && (n3 ^ n2) >= 0) {
            throw new MathArithmeticException(LocalizedFormats.OVERFLOW_IN_SUBTRACTION, n, n2);
        }
        return n3;
    }

    public static long subtractExact(long l, long l2) {
        long l3 = l - l2;
        if ((l ^ l2) < 0L && (l3 ^ l2) >= 0L) {
            throw new MathArithmeticException(LocalizedFormats.OVERFLOW_IN_SUBTRACTION, l, l2);
        }
        return l3;
    }

    public static int multiplyExact(int n, int n2) {
        if (n2 > 0 && (n > Integer.MAX_VALUE / n2 || n < Integer.MIN_VALUE / n2) || n2 < -1 && (n > Integer.MIN_VALUE / n2 || n < Integer.MAX_VALUE / n2) || n2 == -1 && n == Integer.MIN_VALUE) {
            throw new MathArithmeticException(LocalizedFormats.OVERFLOW_IN_MULTIPLICATION, n, n2);
        }
        return n * n2;
    }

    public static long multiplyExact(long l, long l2) {
        if (l2 > 0L && (l > Long.MAX_VALUE / l2 || l < Long.MIN_VALUE / l2) || l2 < -1L && (l > Long.MIN_VALUE / l2 || l < Long.MAX_VALUE / l2) || l2 == -1L && l == Long.MIN_VALUE) {
            throw new MathArithmeticException(LocalizedFormats.OVERFLOW_IN_MULTIPLICATION, l, l2);
        }
        return l * l2;
    }

    public static int floorDiv(int n, int n2) {
        if (n2 == 0) {
            throw new MathArithmeticException(LocalizedFormats.ZERO_DENOMINATOR, new Object[0]);
        }
        int n3 = n % n2;
        if ((n ^ n2) >= 0 || n3 == 0) {
            return n / n2;
        }
        return n / n2 - 1;
    }

    public static long floorDiv(long l, long l2) {
        if (l2 == 0L) {
            throw new MathArithmeticException(LocalizedFormats.ZERO_DENOMINATOR, new Object[0]);
        }
        long l3 = l % l2;
        if ((l ^ l2) >= 0L || l3 == 0L) {
            return l / l2;
        }
        return l / l2 - 1L;
    }

    public static int floorMod(int n, int n2) {
        if (n2 == 0) {
            throw new MathArithmeticException(LocalizedFormats.ZERO_DENOMINATOR, new Object[0]);
        }
        int n3 = n % n2;
        if ((n ^ n2) >= 0 || n3 == 0) {
            return n3;
        }
        return n2 + n3;
    }

    public static long floorMod(long l, long l2) {
        if (l2 == 0L) {
            throw new MathArithmeticException(LocalizedFormats.ZERO_DENOMINATOR, new Object[0]);
        }
        long l3 = l % l2;
        if ((l ^ l2) >= 0L || l3 == 0L) {
            return l3;
        }
        return l2 + l3;
    }

    public static double copySign(double d2, double d3) {
        long l;
        long l2 = Double.doubleToRawLongBits(d2);
        if ((l2 ^ (l = Double.doubleToRawLongBits(d3))) >= 0L) {
            return d2;
        }
        return -d2;
    }

    public static float copySign(float f2, float f3) {
        int n;
        int n2 = Float.floatToRawIntBits(f2);
        if ((n2 ^ (n = Float.floatToRawIntBits(f3))) >= 0) {
            return f2;
        }
        return -f2;
    }

    public static int getExponent(double d2) {
        return (int)(Double.doubleToRawLongBits(d2) >>> 52 & 0x7FFL) - 1023;
    }

    public static int getExponent(float f2) {
        return (Float.floatToRawIntBits(f2) >>> 23 & 0xFF) - 127;
    }

    public static void main(String[] object) {
        object = System.out;
        FastMathCalc.printarray((PrintStream)object, "EXP_INT_TABLE_A", 1500, FastMath$ExpIntTable.access$000());
        FastMathCalc.printarray((PrintStream)object, "EXP_INT_TABLE_B", 1500, FastMath$ExpIntTable.access$100());
        FastMathCalc.printarray((PrintStream)object, "EXP_FRAC_TABLE_A", 1025, FastMath$ExpFracTable.access$200());
        FastMathCalc.printarray((PrintStream)object, "EXP_FRAC_TABLE_B", 1025, FastMath$ExpFracTable.access$300());
        FastMathCalc.printarray((PrintStream)object, "LN_MANT", 1024, FastMath$lnMant.access$400());
        FastMathCalc.printarray((PrintStream)object, "SINE_TABLE_A", 14, SINE_TABLE_A);
        FastMathCalc.printarray((PrintStream)object, "SINE_TABLE_B", 14, SINE_TABLE_B);
        FastMathCalc.printarray((PrintStream)object, "COSINE_TABLE_A", 14, COSINE_TABLE_A);
        FastMathCalc.printarray((PrintStream)object, "COSINE_TABLE_B", 14, COSINE_TABLE_B);
        FastMathCalc.printarray((PrintStream)object, "TANGENT_TABLE_A", 14, TANGENT_TABLE_A);
        FastMathCalc.printarray((PrintStream)object, "TANGENT_TABLE_B", 14, TANGENT_TABLE_B);
    }
}

