/*
 * Decompiled with CFR 0.152.
 */
package games.aquastudios.aquaclient.shaded.apache.commons.math3.util;

import games.aquastudios.aquaclient.shaded.apache.commons.math3.Field;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.RealFieldElement;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.exception.DimensionMismatchException;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.util.Decimal64Field;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.util.FastMath;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.util.MathArrays;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Decimal64
extends Number
implements RealFieldElement<Decimal64>,
Comparable<Decimal64> {
    public static final Decimal64 ZERO = new Decimal64(0.0);
    public static final Decimal64 ONE = new Decimal64(1.0);
    public static final Decimal64 NEGATIVE_INFINITY = new Decimal64(Double.NEGATIVE_INFINITY);
    public static final Decimal64 POSITIVE_INFINITY = new Decimal64(Double.POSITIVE_INFINITY);
    public static final Decimal64 NAN = new Decimal64(Double.NaN);
    private static final long serialVersionUID = 20120227L;
    private final double value;

    public Decimal64(double d2) {
        this.value = d2;
    }

    @Override
    public Field<Decimal64> getField() {
        return Decimal64Field.getInstance();
    }

    @Override
    public Decimal64 add(Decimal64 decimal64) {
        return new Decimal64(this.value + decimal64.value);
    }

    @Override
    public Decimal64 subtract(Decimal64 decimal64) {
        return new Decimal64(this.value - decimal64.value);
    }

    @Override
    public Decimal64 negate() {
        return new Decimal64(-this.value);
    }

    @Override
    public Decimal64 multiply(Decimal64 decimal64) {
        return new Decimal64(this.value * decimal64.value);
    }

    @Override
    public Decimal64 multiply(int n) {
        return new Decimal64((double)n * this.value);
    }

    @Override
    public Decimal64 divide(Decimal64 decimal64) {
        return new Decimal64(this.value / decimal64.value);
    }

    @Override
    public Decimal64 reciprocal() {
        return new Decimal64(1.0 / this.value);
    }

    @Override
    public byte byteValue() {
        return (byte)this.value;
    }

    @Override
    public short shortValue() {
        return (short)this.value;
    }

    @Override
    public int intValue() {
        return (int)this.value;
    }

    @Override
    public long longValue() {
        return (long)this.value;
    }

    @Override
    public float floatValue() {
        return (float)this.value;
    }

    @Override
    public double doubleValue() {
        return this.value;
    }

    @Override
    public int compareTo(Decimal64 decimal64) {
        return Double.compare(this.value, decimal64.value);
    }

    public boolean equals(Object object) {
        if (object instanceof Decimal64) {
            object = (Decimal64)object;
            return Double.doubleToLongBits(this.value) == Double.doubleToLongBits(((Decimal64)object).value);
        }
        return false;
    }

    public int hashCode() {
        long l = Double.doubleToLongBits(this.value);
        return (int)(l ^ l >>> 32);
    }

    public String toString() {
        return Double.toString(this.value);
    }

    public boolean isInfinite() {
        return Double.isInfinite(this.value);
    }

    public boolean isNaN() {
        return Double.isNaN(this.value);
    }

    @Override
    public double getReal() {
        return this.value;
    }

    @Override
    public Decimal64 add(double d2) {
        return new Decimal64(this.value + d2);
    }

    @Override
    public Decimal64 subtract(double d2) {
        return new Decimal64(this.value - d2);
    }

    @Override
    public Decimal64 multiply(double d2) {
        return new Decimal64(this.value * d2);
    }

    @Override
    public Decimal64 divide(double d2) {
        return new Decimal64(this.value / d2);
    }

    @Override
    public Decimal64 remainder(double d2) {
        return new Decimal64(FastMath.IEEEremainder(this.value, d2));
    }

    @Override
    public Decimal64 remainder(Decimal64 decimal64) {
        return new Decimal64(FastMath.IEEEremainder(this.value, decimal64.value));
    }

    @Override
    public Decimal64 abs() {
        return new Decimal64(FastMath.abs(this.value));
    }

    @Override
    public Decimal64 ceil() {
        return new Decimal64(FastMath.ceil(this.value));
    }

    @Override
    public Decimal64 floor() {
        return new Decimal64(FastMath.floor(this.value));
    }

    @Override
    public Decimal64 rint() {
        return new Decimal64(FastMath.rint(this.value));
    }

    @Override
    public long round() {
        return FastMath.round(this.value);
    }

    @Override
    public Decimal64 signum() {
        return new Decimal64(FastMath.signum(this.value));
    }

    @Override
    public Decimal64 copySign(Decimal64 decimal64) {
        return new Decimal64(FastMath.copySign(this.value, decimal64.value));
    }

    @Override
    public Decimal64 copySign(double d2) {
        return new Decimal64(FastMath.copySign(this.value, d2));
    }

    @Override
    public Decimal64 scalb(int n) {
        return new Decimal64(FastMath.scalb(this.value, n));
    }

    @Override
    public Decimal64 hypot(Decimal64 decimal64) {
        return new Decimal64(FastMath.hypot(this.value, decimal64.value));
    }

    @Override
    public Decimal64 sqrt() {
        return new Decimal64(FastMath.sqrt(this.value));
    }

    @Override
    public Decimal64 cbrt() {
        return new Decimal64(FastMath.cbrt(this.value));
    }

    @Override
    public Decimal64 rootN(int n) {
        if (this.value < 0.0) {
            return new Decimal64(-FastMath.pow(-this.value, 1.0 / (double)n));
        }
        return new Decimal64(FastMath.pow(this.value, 1.0 / (double)n));
    }

    @Override
    public Decimal64 pow(double d2) {
        return new Decimal64(FastMath.pow(this.value, d2));
    }

    @Override
    public Decimal64 pow(int n) {
        return new Decimal64(FastMath.pow(this.value, n));
    }

    @Override
    public Decimal64 pow(Decimal64 decimal64) {
        return new Decimal64(FastMath.pow(this.value, decimal64.value));
    }

    @Override
    public Decimal64 exp() {
        return new Decimal64(FastMath.exp(this.value));
    }

    @Override
    public Decimal64 expm1() {
        return new Decimal64(FastMath.expm1(this.value));
    }

    @Override
    public Decimal64 log() {
        return new Decimal64(FastMath.log(this.value));
    }

    @Override
    public Decimal64 log1p() {
        return new Decimal64(FastMath.log1p(this.value));
    }

    public Decimal64 log10() {
        return new Decimal64(FastMath.log10(this.value));
    }

    @Override
    public Decimal64 cos() {
        return new Decimal64(FastMath.cos(this.value));
    }

    @Override
    public Decimal64 sin() {
        return new Decimal64(FastMath.sin(this.value));
    }

    @Override
    public Decimal64 tan() {
        return new Decimal64(FastMath.tan(this.value));
    }

    @Override
    public Decimal64 acos() {
        return new Decimal64(FastMath.acos(this.value));
    }

    @Override
    public Decimal64 asin() {
        return new Decimal64(FastMath.asin(this.value));
    }

    @Override
    public Decimal64 atan() {
        return new Decimal64(FastMath.atan(this.value));
    }

    @Override
    public Decimal64 atan2(Decimal64 decimal64) {
        return new Decimal64(FastMath.atan2(this.value, decimal64.value));
    }

    @Override
    public Decimal64 cosh() {
        return new Decimal64(FastMath.cosh(this.value));
    }

    @Override
    public Decimal64 sinh() {
        return new Decimal64(FastMath.sinh(this.value));
    }

    @Override
    public Decimal64 tanh() {
        return new Decimal64(FastMath.tanh(this.value));
    }

    @Override
    public Decimal64 acosh() {
        return new Decimal64(FastMath.acosh(this.value));
    }

    @Override
    public Decimal64 asinh() {
        return new Decimal64(FastMath.asinh(this.value));
    }

    @Override
    public Decimal64 atanh() {
        return new Decimal64(FastMath.atanh(this.value));
    }

    public Decimal64 linearCombination(Decimal64[] decimal64Array, Decimal64[] decimal64Array2) {
        if (decimal64Array.length != decimal64Array2.length) {
            throw new DimensionMismatchException(decimal64Array.length, decimal64Array2.length);
        }
        double[] dArray = new double[decimal64Array.length];
        double[] dArray2 = new double[decimal64Array2.length];
        for (int i2 = 0; i2 < decimal64Array.length; ++i2) {
            dArray[i2] = decimal64Array[i2].value;
            dArray2[i2] = decimal64Array2[i2].value;
        }
        return new Decimal64(MathArrays.linearCombination(dArray, dArray2));
    }

    public Decimal64 linearCombination(double[] dArray, Decimal64[] decimal64Array) {
        if (dArray.length != decimal64Array.length) {
            throw new DimensionMismatchException(dArray.length, decimal64Array.length);
        }
        double[] dArray2 = new double[decimal64Array.length];
        for (int i2 = 0; i2 < dArray.length; ++i2) {
            dArray2[i2] = decimal64Array[i2].value;
        }
        return new Decimal64(MathArrays.linearCombination(dArray, dArray2));
    }

    @Override
    public Decimal64 linearCombination(Decimal64 decimal64, Decimal64 decimal642, Decimal64 decimal643, Decimal64 decimal644) {
        return new Decimal64(MathArrays.linearCombination(decimal64.value, decimal642.value, decimal643.value, decimal644.value));
    }

    @Override
    public Decimal64 linearCombination(double d2, Decimal64 decimal64, double d3, Decimal64 decimal642) {
        return new Decimal64(MathArrays.linearCombination(d2, decimal64.value, d3, decimal642.value));
    }

    @Override
    public Decimal64 linearCombination(Decimal64 decimal64, Decimal64 decimal642, Decimal64 decimal643, Decimal64 decimal644, Decimal64 decimal645, Decimal64 decimal646) {
        return new Decimal64(MathArrays.linearCombination(decimal64.value, decimal642.value, decimal643.value, decimal644.value, decimal645.value, decimal646.value));
    }

    @Override
    public Decimal64 linearCombination(double d2, Decimal64 decimal64, double d3, Decimal64 decimal642, double d4, Decimal64 decimal643) {
        return new Decimal64(MathArrays.linearCombination(d2, decimal64.value, d3, decimal642.value, d4, decimal643.value));
    }

    @Override
    public Decimal64 linearCombination(Decimal64 decimal64, Decimal64 decimal642, Decimal64 decimal643, Decimal64 decimal644, Decimal64 decimal645, Decimal64 decimal646, Decimal64 decimal647, Decimal64 decimal648) {
        return new Decimal64(MathArrays.linearCombination(decimal64.value, decimal642.value, decimal643.value, decimal644.value, decimal645.value, decimal646.value, decimal647.value, decimal648.value));
    }

    @Override
    public Decimal64 linearCombination(double d2, Decimal64 decimal64, double d3, Decimal64 decimal642, double d4, Decimal64 decimal643, double d5, Decimal64 decimal644) {
        return new Decimal64(MathArrays.linearCombination(d2, decimal64.value, d3, decimal642.value, d4, decimal643.value, d5, decimal644.value));
    }
}

