/*
 * Decompiled with CFR 0.152.
 */
package games.aquastudios.aquaclient.shaded.apache.commons.math3.util;

import java.text.FieldPosition;
import java.text.NumberFormat;
import java.text.ParsePosition;
import java.util.Locale;

public class CompositeFormat {
    private CompositeFormat() {
    }

    public static NumberFormat getDefaultNumberFormat() {
        return CompositeFormat.getDefaultNumberFormat(Locale.getDefault());
    }

    public static NumberFormat getDefaultNumberFormat(Locale cloneable) {
        cloneable = NumberFormat.getInstance(cloneable);
        ((NumberFormat)cloneable).setMaximumFractionDigits(10);
        return cloneable;
    }

    public static void parseAndIgnoreWhitespace(String string, ParsePosition parsePosition) {
        CompositeFormat.parseNextCharacter(string, parsePosition);
        ParsePosition parsePosition2 = parsePosition;
        parsePosition2.setIndex(parsePosition2.getIndex() - 1);
    }

    public static char parseNextCharacter(String string, ParsePosition parsePosition) {
        int n = parsePosition.getIndex();
        int n2 = string.length();
        char c2 = '\u0000';
        if (n < n2) {
            char c3;
            while (Character.isWhitespace(c3 = string.charAt(n++)) && n < n2) {
            }
            parsePosition.setIndex(n);
            if (n < n2) {
                c2 = c3;
            }
        }
        return c2;
    }

    private static Number parseNumber(String string, double d2, ParsePosition parsePosition) {
        Double d3 = null;
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append('(');
        stringBuilder.append(d2);
        stringBuilder.append(')');
        int n = stringBuilder.length();
        int n2 = parsePosition.getIndex();
        n = n2 + n;
        if (n < string.length() && string.substring(n2, n).compareTo(stringBuilder.toString()) == 0) {
            d3 = d2;
            parsePosition.setIndex(n);
        }
        return d3;
    }

    public static Number parseNumber(String string, NumberFormat serializable, ParsePosition parsePosition) {
        int n = parsePosition.getIndex();
        serializable = serializable.parse(string, parsePosition);
        int n2 = parsePosition.getIndex();
        if (n == n2) {
            double[] dArray = new double[]{Double.NaN, Double.POSITIVE_INFINITY, Double.NEGATIVE_INFINITY};
            for (n2 = 0; n2 < dArray.length && (serializable = CompositeFormat.parseNumber(string, dArray[n2], parsePosition)) == null; ++n2) {
            }
        }
        return serializable;
    }

    public static boolean parseFixedstring(String string, String string2, ParsePosition parsePosition) {
        int n = parsePosition.getIndex();
        int n2 = n + string2.length();
        if (n >= string.length() || n2 > string.length() || string.substring(n, n2).compareTo(string2) != 0) {
            parsePosition.setIndex(n);
            parsePosition.setErrorIndex(n);
            return false;
        }
        parsePosition.setIndex(n2);
        return true;
    }

    public static StringBuffer formatDouble(double d2, NumberFormat numberFormat, StringBuffer stringBuffer, FieldPosition fieldPosition) {
        if (Double.isNaN(d2) || Double.isInfinite(d2)) {
            stringBuffer.append('(');
            stringBuffer.append(d2);
            stringBuffer.append(')');
        } else {
            numberFormat.format(d2, stringBuffer, fieldPosition);
        }
        return stringBuffer;
    }
}

