/*
 * Decompiled with CFR 0.152.
 */
package games.aquastudios.aquaclient.shaded.apache.commons.math3.util;

import games.aquastudios.aquaclient.shaded.apache.commons.math3.exception.MathArithmeticException;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.exception.NotPositiveException;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.exception.NumberIsTooLargeException;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.exception.util.Localizable;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.exception.util.LocalizedFormats;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.util.ArithmeticUtils;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.util.Combinations;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.util.FastMath;
import java.util.Iterator;
import java.util.concurrent.atomic.AtomicReference;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class CombinatoricsUtils {
    static final long[] FACTORIALS = new long[]{1L, 1L, 2L, 6L, 24L, 120L, 720L, 5040L, 40320L, 362880L, 3628800L, 39916800L, 479001600L, 6227020800L, 87178291200L, 1307674368000L, 20922789888000L, 355687428096000L, 6402373705728000L, 121645100408832000L, 2432902008176640000L};
    static final AtomicReference<long[][]> STIRLING_S2 = new AtomicReference<Object>(null);

    private CombinatoricsUtils() {
    }

    public static long binomialCoefficient(int n, int n2) {
        while (true) {
            CombinatoricsUtils.checkBinomial(n, n2);
            if (n == n2 || n2 == 0) {
                return 1L;
            }
            if (n2 == 1 || n2 == n - 1) {
                return n;
            }
            if (n2 <= n / 2) break;
            n2 = n - n2;
        }
        long l = 1L;
        if (n <= 61) {
            n = n - n2 + 1;
            for (int i2 = 1; i2 <= n2; ++i2) {
                l = l * (long)n / (long)i2;
                ++n;
            }
        } else if (n <= 66) {
            n = n - n2 + 1;
            for (int i3 = 1; i3 <= n2; ++i3) {
                long l2 = ArithmeticUtils.gcd(n, i3);
                l = l / ((long)i3 / l2) * ((long)n / l2);
                ++n;
            }
        } else {
            n = n - n2 + 1;
            for (int i4 = 1; i4 <= n2; ++i4) {
                long l3 = ArithmeticUtils.gcd(n, i4);
                l = ArithmeticUtils.mulAndCheck(l / ((long)i4 / l3), (long)n / l3);
                ++n;
            }
        }
        return l;
    }

    public static double binomialCoefficientDouble(int n, int n2) {
        while (true) {
            CombinatoricsUtils.checkBinomial(n, n2);
            if (n == n2 || n2 == 0) {
                return 1.0;
            }
            if (n2 == 1 || n2 == n - 1) {
                return n;
            }
            if (n2 <= n / 2) break;
            n2 = n - n2;
        }
        if (n < 67) {
            return CombinatoricsUtils.binomialCoefficient(n, n2);
        }
        double d2 = 1.0;
        for (int i2 = 1; i2 <= n2; ++i2) {
            d2 *= (double)(n - n2 + i2) / (double)i2;
        }
        return FastMath.floor(d2 + 0.5);
    }

    public static double binomialCoefficientLog(int n, int n2) {
        int n3;
        while (true) {
            CombinatoricsUtils.checkBinomial(n, n2);
            if (n == n2 || n2 == 0) {
                return 0.0;
            }
            if (n2 == 1 || n2 == n - 1) {
                return FastMath.log(n);
            }
            if (n < 67) {
                return FastMath.log(CombinatoricsUtils.binomialCoefficient(n, n2));
            }
            if (n < 1030) {
                return FastMath.log(CombinatoricsUtils.binomialCoefficientDouble(n, n2));
            }
            if (n2 <= n / 2) break;
            n2 = n - n2;
        }
        double d2 = 0.0;
        for (n3 = n - n2 + 1; n3 <= n; ++n3) {
            d2 += FastMath.log(n3);
        }
        for (n3 = 2; n3 <= n2; ++n3) {
            d2 -= FastMath.log(n3);
        }
        return d2;
    }

    public static long factorial(int n) {
        if (n < 0) {
            throw new NotPositiveException((Localizable)LocalizedFormats.FACTORIAL_NEGATIVE_PARAMETER, n);
        }
        if (n > 20) {
            throw new MathArithmeticException();
        }
        return FACTORIALS[n];
    }

    public static double factorialDouble(int n) {
        if (n < 0) {
            throw new NotPositiveException((Localizable)LocalizedFormats.FACTORIAL_NEGATIVE_PARAMETER, n);
        }
        if (n < 21) {
            return FACTORIALS[n];
        }
        return FastMath.floor(FastMath.exp(CombinatoricsUtils.factorialLog(n)) + 0.5);
    }

    public static double factorialLog(int n) {
        if (n < 0) {
            throw new NotPositiveException((Localizable)LocalizedFormats.FACTORIAL_NEGATIVE_PARAMETER, n);
        }
        if (n < 21) {
            return FastMath.log(FACTORIALS[n]);
        }
        double d2 = 0.0;
        for (int i2 = 2; i2 <= n; ++i2) {
            d2 += FastMath.log(i2);
        }
        return d2;
    }

    public static long stirlingS2(int n, int n2) {
        if (n2 < 0) {
            throw new NotPositiveException(n2);
        }
        if (n2 > n) {
            throw new NumberIsTooLargeException(n2, (Number)n, true);
        }
        Object object = STIRLING_S2.get();
        if (object == null) {
            long[][] lArrayArray = new long[26][];
            object = lArrayArray;
            lArrayArray[0] = new long[]{1L};
            for (int i2 = 1; i2 < ((long[][])object).length; ++i2) {
                int n3 = i2;
                object[n3] = new long[n3 + 1];
                object[i2][0] = 0L;
                object[i2][1] = 1L;
                object[i2][i2] = 1L;
                for (int i3 = 2; i3 < i2; ++i3) {
                    int n4 = i3;
                    object[i2][n4] = (long)n4 * object[i2 - 1][i3] + object[i2 - 1][i3 - 1];
                }
            }
            STIRLING_S2.compareAndSet((long[][])null, (long[][])object);
        }
        if (n < ((long[][])object).length) {
            return object[n][n2];
        }
        if (n2 == 0) {
            return 0L;
        }
        if (n2 == 1 || n2 == n) {
            return 1L;
        }
        if (n2 == 2) {
            return (1L << n - 1) - 1L;
        }
        if (n2 == n - 1) {
            return CombinatoricsUtils.binomialCoefficient(n, 2);
        }
        long l = 0L;
        long l2 = (n2 & 1) == 0 ? 1L : -1L;
        for (int i4 = 1; i4 <= n2; ++i4) {
            if ((l += (l2 = -l2) * CombinatoricsUtils.binomialCoefficient(n2, i4) * (long)ArithmeticUtils.pow(i4, n)) >= 0L) continue;
            throw new MathArithmeticException(LocalizedFormats.ARGUMENT_OUTSIDE_DOMAIN, n, 0, ((long[][])object).length - 1);
        }
        return l / CombinatoricsUtils.factorial(n2);
    }

    public static Iterator<int[]> combinationsIterator(int n, int n2) {
        return new Combinations(n, n2).iterator();
    }

    public static void checkBinomial(int n, int n2) {
        if (n < n2) {
            throw new NumberIsTooLargeException((Localizable)LocalizedFormats.BINOMIAL_INVALID_PARAMETERS_ORDER, (Number)n2, n, true);
        }
        if (n < 0) {
            throw new NotPositiveException((Localizable)LocalizedFormats.BINOMIAL_NEGATIVE_PARAMETER, n);
        }
    }
}

