/*
 * Decompiled with CFR 0.152.
 */
package games.aquastudios.aquaclient.shaded.apache.commons.math3.util;

import games.aquastudios.aquaclient.shaded.apache.commons.math3.exception.MathInternalError;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.util.Combinations$IterationOrder;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.util.Combinations$LexicographicComparator;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.util.Combinations$LexicographicIterator;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.util.Combinations$SingletonIterator;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.util.CombinatoricsUtils;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.util.MathArrays;
import java.util.Comparator;
import java.util.Iterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Combinations
implements Iterable<int[]> {
    private final int n;
    private final int k;
    private final Combinations$IterationOrder iterationOrder;

    public Combinations(int n, int n2) {
        this(n, n2, Combinations$IterationOrder.LEXICOGRAPHIC);
    }

    private Combinations(int n, int n2, Combinations$IterationOrder combinations$IterationOrder) {
        CombinatoricsUtils.checkBinomial(n, n2);
        this.n = n;
        this.k = n2;
        this.iterationOrder = combinations$IterationOrder;
    }

    public int getN() {
        return this.n;
    }

    public int getK() {
        return this.k;
    }

    @Override
    public Iterator<int[]> iterator() {
        if (this.k == 0 || this.k == this.n) {
            return new Combinations$SingletonIterator(MathArrays.natural(this.k));
        }
        switch (this.iterationOrder) {
            case LEXICOGRAPHIC: {
                return new Combinations$LexicographicIterator(this.n, this.k);
            }
        }
        throw new MathInternalError();
    }

    public Comparator<int[]> comparator() {
        return new Combinations$LexicographicComparator(this.n, this.k);
    }
}

