/*
 * Decompiled with CFR 0.152.
 */
package games.aquastudios.aquaclient.shaded.apache.commons.math3.util;

import games.aquastudios.aquaclient.shaded.apache.commons.math3.exception.DimensionMismatchException;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.exception.OutOfRangeException;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.util.ArithmeticUtils;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.util.MathArrays;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Comparator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class Combinations$LexicographicComparator
implements Serializable,
Comparator<int[]> {
    private static final long serialVersionUID = 20130906L;
    private final int n;
    private final int k;

    Combinations$LexicographicComparator(int n, int n2) {
        this.n = n;
        this.k = n2;
    }

    @Override
    public int compare(int[] nArray, int[] nArray2) {
        if (nArray.length != this.k) {
            throw new DimensionMismatchException(nArray.length, this.k);
        }
        if (nArray2.length != this.k) {
            throw new DimensionMismatchException(nArray2.length, this.k);
        }
        nArray = MathArrays.copyOf(nArray);
        Arrays.sort(nArray);
        nArray2 = MathArrays.copyOf(nArray2);
        Arrays.sort(nArray2);
        long l = this.lexNorm(nArray);
        long l2 = this.lexNorm(nArray2);
        if (l < l2) {
            return -1;
        }
        if (l > l2) {
            return 1;
        }
        return 0;
    }

    private long lexNorm(int[] nArray) {
        long l = 0L;
        for (int i2 = 0; i2 < nArray.length; ++i2) {
            int n = nArray[i2];
            if (n < 0 || n >= this.n) {
                throw new OutOfRangeException(n, (Number)0, this.n - 1);
            }
            l += (long)(nArray[i2] * ArithmeticUtils.pow(this.n, i2));
        }
        return l;
    }
}

