/*
 * Decompiled with CFR 0.152.
 */
package games.aquastudios.aquaclient.shaded.apache.commons.math3.transform;

import games.aquastudios.aquaclient.shaded.apache.commons.math3.complex.Complex;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.exception.DimensionMismatchException;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.exception.MathIllegalArgumentException;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.exception.util.LocalizedFormats;
import java.util.Arrays;

public class TransformUtils {
    private static final int[] POWERS_OF_TWO = new int[]{1, 2, 4, 8, 16, 32, 64, 128, 256, 512, 1024, 2048, 4096, 8192, 16384, 32768, 65536, 131072, 262144, 524288, 0x100000, 0x200000, 0x400000, 0x800000, 0x1000000, 0x2000000, 0x4000000, 0x8000000, 0x10000000, 0x20000000, 0x40000000};

    private TransformUtils() {
    }

    public static double[] scaleArray(double[] dArray, double d2) {
        int n = 0;
        while (n < dArray.length) {
            int n2 = n++;
            dArray[n2] = dArray[n2] * d2;
        }
        return dArray;
    }

    public static Complex[] scaleArray(Complex[] complexArray, double d2) {
        for (int i2 = 0; i2 < complexArray.length; ++i2) {
            complexArray[i2] = new Complex(d2 * complexArray[i2].getReal(), d2 * complexArray[i2].getImaginary());
        }
        return complexArray;
    }

    public static double[][] createRealImaginaryArray(Complex[] complexArray) {
        double[][] dArray = new double[2][complexArray.length];
        double[] dArray2 = dArray[0];
        double[] dArray3 = dArray[1];
        for (int i2 = 0; i2 < complexArray.length; ++i2) {
            Complex complex = complexArray[i2];
            dArray2[i2] = complex.getReal();
            dArray3[i2] = complex.getImaginary();
        }
        return dArray;
    }

    public static Complex[] createComplexArray(double[][] object) {
        if (((double[][])object).length != 2) {
            throw new DimensionMismatchException(((double[][])object).length, 2);
        }
        double[] dArray = object[0];
        if (dArray.length != ((double[][])(object = (Object)object[1])).length) {
            throw new DimensionMismatchException(((double[][])object).length, dArray.length);
        }
        int n = dArray.length;
        Complex[] complexArray = new Complex[n];
        for (int i2 = 0; i2 < n; ++i2) {
            complexArray[i2] = new Complex(dArray[i2], (double)object[i2]);
        }
        return complexArray;
    }

    public static int exactLog2(int n) {
        int n2 = Arrays.binarySearch(POWERS_OF_TWO, n);
        if (n2 < 0) {
            throw new MathIllegalArgumentException(LocalizedFormats.NOT_POWER_OF_TWO_CONSIDER_PADDING, n);
        }
        return n2;
    }
}

