/*
 * Decompiled with CFR 0.152.
 */
package games.aquastudios.aquaclient.shaded.apache.commons.math3.transform;

import games.aquastudios.aquaclient.shaded.apache.commons.math3.analysis.FunctionUtils;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.analysis.UnivariateFunction;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.complex.Complex;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.exception.MathIllegalArgumentException;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.exception.util.LocalizedFormats;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.transform.DftNormalization;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.transform.DstNormalization;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.transform.FastFourierTransformer;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.transform.RealTransformer;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.transform.TransformType;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.transform.TransformUtils;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.util.ArithmeticUtils;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.util.FastMath;
import java.io.Serializable;

public class FastSineTransformer
implements RealTransformer,
Serializable {
    static final long serialVersionUID = 20120211L;
    private final DstNormalization normalization;

    public FastSineTransformer(DstNormalization dstNormalization) {
        this.normalization = dstNormalization;
    }

    public double[] transform(double[] dArray, TransformType transformType) {
        if (this.normalization == DstNormalization.ORTHOGONAL_DST_I) {
            double d2 = FastMath.sqrt(2.0 / (double)dArray.length);
            return TransformUtils.scaleArray(this.fst(dArray), d2);
        }
        if (transformType == TransformType.FORWARD) {
            return this.fst(dArray);
        }
        double d3 = 2.0 / (double)dArray.length;
        return TransformUtils.scaleArray(this.fst(dArray), d3);
    }

    public double[] transform(UnivariateFunction object, double d2, double d3, int n, TransformType transformType) {
        double[] dArray = FunctionUtils.sample((UnivariateFunction)object, d2, d3, n);
        object = dArray;
        dArray[0] = 0.0;
        return this.transform((double[])object, transformType);
    }

    protected double[] fst(double[] dArray) {
        double[] dArray2 = new double[dArray.length];
        if (!ArithmeticUtils.isPowerOfTwo(dArray.length)) {
            throw new MathIllegalArgumentException(LocalizedFormats.NOT_POWER_OF_TWO_CONSIDER_PADDING, dArray.length);
        }
        if (dArray[0] != 0.0) {
            throw new MathIllegalArgumentException(LocalizedFormats.FIRST_ELEMENT_NOT_ZERO, dArray[0]);
        }
        int n = dArray.length;
        if (n == 1) {
            dArray2[0] = 0.0;
            return dArray2;
        }
        double[] dArray3 = new double[n];
        double[] dArray4 = dArray3;
        dArray3[0] = 0.0;
        dArray4[n >> 1] = 2.0 * dArray[n >> 1];
        for (int i2 = 1; i2 < n >> 1; ++i2) {
            double d2 = FastMath.sin((double)i2 * Math.PI / (double)n) * (dArray[i2] + dArray[n - i2]);
            double d3 = 0.5 * (dArray[i2] - dArray[n - i2]);
            dArray4[i2] = d2 + d3;
            dArray4[n - i2] = d2 - d3;
        }
        FastFourierTransformer fastFourierTransformer = new FastFourierTransformer(DftNormalization.STANDARD);
        Complex[] complexArray = fastFourierTransformer.transform(dArray4, TransformType.FORWARD);
        dArray2[0] = 0.0;
        dArray2[1] = 0.5 * complexArray[0].getReal();
        for (int i3 = 1; i3 < n >> 1; ++i3) {
            dArray2[2 * i3] = -complexArray[i3].getImaginary();
            dArray2[2 * i3 + 1] = complexArray[i3].getReal() + dArray2[2 * i3 - 1];
        }
        return dArray2;
    }
}

