/*
 * Decompiled with CFR 0.152.
 */
package games.aquastudios.aquaclient.shaded.apache.commons.math3.transform;

import games.aquastudios.aquaclient.shaded.apache.commons.math3.analysis.FunctionUtils;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.analysis.UnivariateFunction;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.exception.MathIllegalArgumentException;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.exception.util.LocalizedFormats;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.transform.RealTransformer;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.transform.TransformType;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.transform.TransformUtils;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.util.ArithmeticUtils;
import java.io.Serializable;

public class FastHadamardTransformer
implements RealTransformer,
Serializable {
    static final long serialVersionUID = 20120211L;

    public double[] transform(double[] dArray, TransformType transformType) {
        if (transformType == TransformType.FORWARD) {
            return this.fht(dArray);
        }
        return TransformUtils.scaleArray(this.fht(dArray), 1.0 / (double)dArray.length);
    }

    public double[] transform(UnivariateFunction univariateFunction, double d2, double d3, int n, TransformType transformType) {
        return this.transform(FunctionUtils.sample(univariateFunction, d2, d3, n), transformType);
    }

    public int[] transform(int[] nArray) {
        return this.fht(nArray);
    }

    protected double[] fht(double[] dArray) {
        int n = dArray.length;
        int n2 = n / 2;
        if (!ArithmeticUtils.isPowerOfTwo(n)) {
            throw new MathIllegalArgumentException(LocalizedFormats.NOT_POWER_OF_TWO, n);
        }
        double[] dArray2 = new double[n];
        dArray = (double[])dArray.clone();
        for (int i2 = 1; i2 < n; i2 <<= 1) {
            int n3;
            int n4;
            double[] dArray3 = dArray;
            dArray = dArray2;
            dArray2 = dArray3;
            for (n4 = 0; n4 < n2; ++n4) {
                n3 = 2 * n4;
                dArray[n4] = dArray2[n3] + dArray2[n3 + 1];
            }
            for (n4 = n2; n4 < n; ++n4) {
                n3 = 2 * n4;
                dArray[n4] = dArray2[n3 - n] - dArray2[n3 - n + 1];
            }
        }
        return dArray;
    }

    protected int[] fht(int[] nArray) {
        int n = nArray.length;
        int n2 = n / 2;
        if (!ArithmeticUtils.isPowerOfTwo(n)) {
            throw new MathIllegalArgumentException(LocalizedFormats.NOT_POWER_OF_TWO, n);
        }
        int[] nArray2 = new int[n];
        nArray = (int[])nArray.clone();
        for (int i2 = 1; i2 < n; i2 <<= 1) {
            int n3;
            int n4;
            int[] nArray3 = nArray;
            nArray = nArray2;
            nArray2 = nArray3;
            for (n4 = 0; n4 < n2; ++n4) {
                n3 = 2 * n4;
                nArray[n4] = nArray2[n3] + nArray2[n3 + 1];
            }
            for (n4 = n2; n4 < n; ++n4) {
                n3 = 2 * n4;
                nArray[n4] = nArray2[n3 - n] - nArray2[n3 - n + 1];
            }
        }
        return nArray;
    }
}

