/*
 * Decompiled with CFR 0.152.
 */
package games.aquastudios.aquaclient.shaded.apache.commons.math3.transform;

import games.aquastudios.aquaclient.shaded.apache.commons.math3.analysis.FunctionUtils;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.analysis.UnivariateFunction;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.complex.Complex;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.exception.DimensionMismatchException;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.exception.MathIllegalArgumentException;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.exception.MathIllegalStateException;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.exception.util.LocalizedFormats;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.transform.DftNormalization;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.transform.FastFourierTransformer$MultiDimensionalComplexMatrix;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.transform.TransformType;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.transform.TransformUtils;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.util.ArithmeticUtils;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.util.FastMath;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.util.MathArrays;
import java.io.Serializable;

public class FastFourierTransformer
implements Serializable {
    static final long serialVersionUID = 20120210L;
    private static final double[] W_SUB_N_R = new double[]{1.0, -1.0, 6.123233995736766E-17, 0.7071067811865476, 0.9238795325112867, 0.9807852804032304, 0.9951847266721969, 0.9987954562051724, 0.9996988186962042, 0.9999247018391445, 0.9999811752826011, 0.9999952938095762, 0.9999988234517019, 0.9999997058628822, 0.9999999264657179, 0.9999999816164293, 0.9999999954041073, 0.9999999988510269, 0.9999999997127567, 0.9999999999281892, 0.9999999999820472, 0.9999999999955118, 0.999999999998878, 0.9999999999997194, 0.9999999999999298, 0.9999999999999825, 0.9999999999999957, 0.9999999999999989, 0.9999999999999998, 0.9999999999999999, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0};
    private static final double[] W_SUB_N_I = new double[]{2.4492935982947064E-16, -1.2246467991473532E-16, -1.0, -0.7071067811865475, -0.3826834323650898, -0.19509032201612825, -0.0980171403295606, -0.049067674327418015, -0.024541228522912288, -0.012271538285719925, -0.006135884649154475, -0.003067956762965976, -0.0015339801862847655, -7.669903187427045E-4, -3.8349518757139556E-4, -1.917475973107033E-4, -9.587379909597734E-5, -4.793689960306688E-5, -2.396844980841822E-5, -1.1984224905069705E-5, -5.9921124526424275E-6, -2.996056226334661E-6, -1.4980281131690111E-6, -7.490140565847157E-7, -3.7450702829238413E-7, -1.8725351414619535E-7, -9.362675707309808E-8, -4.681337853654909E-8, -2.340668926827455E-8, -1.1703344634137277E-8, -5.8516723170686385E-9, -2.9258361585343192E-9, -1.4629180792671596E-9, -7.314590396335798E-10, -3.657295198167899E-10, -1.8286475990839495E-10, -9.143237995419748E-11, -4.571618997709874E-11, -2.285809498854937E-11, -1.1429047494274685E-11, -5.714523747137342E-12, -2.857261873568671E-12, -1.4286309367843356E-12, -7.143154683921678E-13, -3.571577341960839E-13, -1.7857886709804195E-13, -8.928943354902097E-14, -4.4644716774510487E-14, -2.2322358387255243E-14, -1.1161179193627622E-14, -5.580589596813811E-15, -2.7902947984069054E-15, -1.3951473992034527E-15, -6.975736996017264E-16, -3.487868498008632E-16, -1.743934249004316E-16, -8.71967124502158E-17, -4.35983562251079E-17, -2.179917811255395E-17, -1.0899589056276974E-17, -5.449794528138487E-18, -2.7248972640692436E-18, -1.3624486320346218E-18};
    private final DftNormalization normalization;

    public FastFourierTransformer(DftNormalization dftNormalization) {
        this.normalization = dftNormalization;
    }

    private static void bitReversalShuffle2(double[] dArray, double[] dArray2) {
        int n = dArray.length;
        assert (dArray2.length == n);
        int n2 = n >> 1;
        int n3 = 0;
        for (int i2 = 0; i2 < n; ++i2) {
            int n4;
            if (i2 < n3) {
                double d2 = dArray[i2];
                dArray[i2] = dArray[n3];
                dArray[n3] = d2;
                d2 = dArray2[i2];
                dArray2[i2] = dArray2[n3];
                dArray2[n3] = d2;
            }
            for (n4 = n2; n4 <= n3 && n4 > 0; n3 -= n4, n4 >>= 1) {
            }
            n3 += n4;
        }
    }

    private static void normalizeTransformedData(double[][] object, DftNormalization dftNormalization, TransformType transformType) {
        double[] dArray = object[0];
        object = object[1];
        int n = dArray.length;
        assert (((double[][])object).length == n);
        switch (dftNormalization) {
            case STANDARD: {
                if (transformType != TransformType.INVERSE) break;
                double d2 = 1.0 / (double)n;
                int n2 = 0;
                while (n2 < n) {
                    int n3 = n2;
                    dArray[n3] = dArray[n3] * d2;
                    int n4 = n2++;
                    object[n4] = object[n4] * d2;
                }
                return;
            }
            case UNITARY: {
                double d3 = 1.0 / FastMath.sqrt(n);
                int n5 = 0;
                while (n5 < n) {
                    int n6 = n5;
                    dArray[n6] = dArray[n6] * d3;
                    int n7 = n5++;
                    object[n7] = object[n7] * d3;
                }
                return;
            }
            default: {
                throw new MathIllegalStateException();
            }
        }
    }

    public static void transformInPlace(double[][] dArray, DftNormalization dftNormalization, TransformType transformType) {
        double d2;
        double d3;
        double d4;
        double d5;
        double d6;
        double d7;
        double d8;
        double d9;
        int n;
        int n2;
        int n3;
        int n4;
        if (dArray.length != 2) {
            throw new DimensionMismatchException(dArray.length, 2);
        }
        double[] dArray2 = dArray[0];
        double[] dArray3 = dArray[1];
        if (dArray2.length != dArray3.length) {
            throw new DimensionMismatchException(dArray3.length, dArray2.length);
        }
        int n5 = dArray2.length;
        if (!ArithmeticUtils.isPowerOfTwo(n5)) {
            throw new MathIllegalArgumentException(LocalizedFormats.NOT_POWER_OF_TWO_CONSIDER_PADDING, n5);
        }
        if (n5 == 1) {
            return;
        }
        if (n5 == 2) {
            double d10 = dArray2[0];
            double d11 = dArray3[0];
            double d12 = dArray2[1];
            double d13 = dArray3[1];
            dArray2[0] = d10 + d12;
            dArray3[0] = d11 + d13;
            dArray2[1] = d10 - d12;
            dArray3[1] = d11 - d13;
            FastFourierTransformer.normalizeTransformedData(dArray, dftNormalization, transformType);
            return;
        }
        FastFourierTransformer.bitReversalShuffle2(dArray2, dArray3);
        if (transformType == TransformType.INVERSE) {
            for (n4 = 0; n4 < n5; n4 += 4) {
                n3 = n4 + 1;
                n2 = n4 + 2;
                n = n4 + 3;
                d9 = dArray2[n4];
                d8 = dArray3[n4];
                d7 = dArray2[n2];
                d6 = dArray3[n2];
                d5 = dArray2[n3];
                d4 = dArray3[n3];
                d3 = dArray2[n];
                d2 = dArray3[n];
                dArray2[n4] = d9 + d7 + d5 + d3;
                dArray3[n4] = d8 + d6 + d4 + d2;
                dArray2[n3] = d9 - d5 + (d2 - d6);
                dArray3[n3] = d8 - d4 + (d7 - d3);
                dArray2[n2] = d9 - d7 + d5 - d3;
                dArray3[n2] = d8 - d6 + d4 - d2;
                dArray2[n] = d9 - d5 + (d6 - d2);
                dArray3[n] = d8 - d4 + (d3 - d7);
            }
        } else {
            for (n4 = 0; n4 < n5; n4 += 4) {
                n3 = n4 + 1;
                n2 = n4 + 2;
                n = n4 + 3;
                d9 = dArray2[n4];
                d8 = dArray3[n4];
                d7 = dArray2[n2];
                d6 = dArray3[n2];
                d5 = dArray2[n3];
                d4 = dArray3[n3];
                d3 = dArray2[n];
                d2 = dArray3[n];
                dArray2[n4] = d9 + d7 + d5 + d3;
                dArray3[n4] = d8 + d6 + d4 + d2;
                dArray2[n3] = d9 - d5 + (d6 - d2);
                dArray3[n3] = d8 - d4 + (d3 - d7);
                dArray2[n2] = d9 - d7 + d5 - d3;
                dArray3[n2] = d8 - d6 + d4 - d2;
                dArray2[n] = d9 - d5 + (d2 - d6);
                dArray3[n] = d8 - d4 + (d7 - d3);
            }
        }
        n4 = 4;
        n3 = 2;
        while (n4 < n5) {
            n2 = n4 << 1;
            n = n3 + 1;
            d9 = W_SUB_N_R[n];
            d8 = W_SUB_N_I[n];
            if (transformType == TransformType.INVERSE) {
                d8 = -d8;
            }
            for (int i2 = 0; i2 < n5; i2 += n2) {
                int n6 = i2 + n4;
                d6 = 1.0;
                d5 = 0.0;
                for (int i3 = 0; i3 < n4; ++i3) {
                    double d14 = dArray2[i2 + i3];
                    double d15 = dArray3[i2 + i3];
                    double d16 = dArray2[n6 + i3];
                    double d17 = dArray3[n6 + i3];
                    dArray2[i2 + i3] = d14 + d6 * d16 - d5 * d17;
                    dArray3[i2 + i3] = d15 + d6 * d17 + d5 * d16;
                    dArray2[n6 + i3] = d14 - (d6 * d16 - d5 * d17);
                    dArray3[n6 + i3] = d15 - (d6 * d17 + d5 * d16);
                    double d18 = d6 * d9 - d5 * d8;
                    double d19 = d6 * d8 + d5 * d9;
                    d6 = d18;
                    d5 = d19;
                }
            }
            n4 = n2;
            n3 = n;
        }
        FastFourierTransformer.normalizeTransformedData(dArray, dftNormalization, transformType);
    }

    public Complex[] transform(double[] object, TransformType transformType) {
        double[][] dArrayArray = new double[][]{MathArrays.copyOf(object, ((double[])object).length), new double[((double[])object).length]};
        object = dArrayArray;
        FastFourierTransformer.transformInPlace(dArrayArray, this.normalization, transformType);
        return TransformUtils.createComplexArray((double[][])object);
    }

    public Complex[] transform(UnivariateFunction object, double d2, double d3, int n, TransformType transformType) {
        object = FunctionUtils.sample((UnivariateFunction)object, d2, d3, n);
        return this.transform((double[])object, transformType);
    }

    public Complex[] transform(Complex[] object, TransformType transformType) {
        double[][] dArray = TransformUtils.createRealImaginaryArray(object);
        object = dArray;
        FastFourierTransformer.transformInPlace(dArray, this.normalization, transformType);
        return TransformUtils.createComplexArray((double[][])object);
    }

    @Deprecated
    public Object mdfft(Object object, TransformType transformType) {
        object = (FastFourierTransformer$MultiDimensionalComplexMatrix)new FastFourierTransformer$MultiDimensionalComplexMatrix(object).clone();
        int[] nArray = ((FastFourierTransformer$MultiDimensionalComplexMatrix)object).getDimensionSizes();
        for (int i2 = 0; i2 < nArray.length; ++i2) {
            this.mdfft((FastFourierTransformer$MultiDimensionalComplexMatrix)object, transformType, i2, new int[0]);
        }
        return ((FastFourierTransformer$MultiDimensionalComplexMatrix)object).getArray();
    }

    @Deprecated
    private void mdfft(FastFourierTransformer$MultiDimensionalComplexMatrix fastFourierTransformer$MultiDimensionalComplexMatrix, TransformType transformType, int n, int[] nArray) {
        int[] nArray2 = fastFourierTransformer$MultiDimensionalComplexMatrix.getDimensionSizes();
        if (nArray.length == nArray2.length) {
            int n2;
            Complex[] complexArray = new Complex[nArray2[n]];
            for (n2 = 0; n2 < nArray2[n]; ++n2) {
                nArray[n] = n2;
                complexArray[n2] = fastFourierTransformer$MultiDimensionalComplexMatrix.get(nArray);
            }
            complexArray = this.transform(complexArray, transformType);
            for (n2 = 0; n2 < nArray2[n]; ++n2) {
                nArray[n] = n2;
                fastFourierTransformer$MultiDimensionalComplexMatrix.set(complexArray[n2], nArray);
            }
            return;
        }
        int[] nArray3 = new int[nArray.length + 1];
        System.arraycopy(nArray, 0, nArray3, 0, nArray.length);
        if (nArray.length == n) {
            nArray3[n] = 0;
            this.mdfft(fastFourierTransformer$MultiDimensionalComplexMatrix, transformType, n, nArray3);
            return;
        }
        int n3 = 0;
        while (n3 < nArray2[nArray.length]) {
            nArray3[nArray.length] = n3++;
            this.mdfft(fastFourierTransformer$MultiDimensionalComplexMatrix, transformType, n, nArray3);
        }
    }
}

