/*
 * Decompiled with CFR 0.152.
 */
package games.aquastudios.aquaclient.shaded.apache.commons.math3.transform;

import games.aquastudios.aquaclient.shaded.apache.commons.math3.analysis.FunctionUtils;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.analysis.UnivariateFunction;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.complex.Complex;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.exception.MathIllegalArgumentException;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.exception.util.LocalizedFormats;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.transform.DctNormalization;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.transform.DftNormalization;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.transform.FastFourierTransformer;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.transform.RealTransformer;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.transform.TransformType;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.transform.TransformUtils;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.util.ArithmeticUtils;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.util.FastMath;
import java.io.Serializable;

public class FastCosineTransformer
implements RealTransformer,
Serializable {
    static final long serialVersionUID = 20120212L;
    private final DctNormalization normalization;

    public FastCosineTransformer(DctNormalization dctNormalization) {
        this.normalization = dctNormalization;
    }

    public double[] transform(double[] dArray, TransformType transformType) {
        if (transformType == TransformType.FORWARD) {
            if (this.normalization == DctNormalization.ORTHOGONAL_DCT_I) {
                double d2 = FastMath.sqrt(2.0 / (double)(dArray.length - 1));
                return TransformUtils.scaleArray(this.fct(dArray), d2);
            }
            return this.fct(dArray);
        }
        double d3 = 2.0 / (double)(dArray.length - 1);
        double d4 = this.normalization == DctNormalization.ORTHOGONAL_DCT_I ? FastMath.sqrt(d3) : d3;
        return TransformUtils.scaleArray(this.fct(dArray), d4);
    }

    public double[] transform(UnivariateFunction object, double d2, double d3, int n, TransformType transformType) {
        object = FunctionUtils.sample((UnivariateFunction)object, d2, d3, n);
        return this.transform((double[])object, transformType);
    }

    protected double[] fct(double[] dArray) {
        double[] dArray2 = new double[dArray.length];
        int n = dArray.length - 1;
        if (!ArithmeticUtils.isPowerOfTwo(n)) {
            throw new MathIllegalArgumentException(LocalizedFormats.NOT_POWER_OF_TWO_PLUS_ONE, dArray.length);
        }
        if (n == 1) {
            dArray2[0] = 0.5 * (dArray[0] + dArray[1]);
            dArray2[1] = 0.5 * (dArray[0] - dArray[1]);
            return dArray2;
        }
        double[] dArray3 = new double[n];
        double[] dArray4 = dArray3;
        dArray3[0] = 0.5 * (dArray[0] + dArray[n]);
        dArray4[n >> 1] = dArray[n >> 1];
        double d2 = 0.5 * (dArray[0] - dArray[n]);
        for (int i2 = 1; i2 < n >> 1; ++i2) {
            double d3 = 0.5 * (dArray[i2] + dArray[n - i2]);
            double d4 = FastMath.sin((double)i2 * Math.PI / (double)n) * (dArray[i2] - dArray[n - i2]);
            double d5 = FastMath.cos((double)i2 * Math.PI / (double)n) * (dArray[i2] - dArray[n - i2]);
            dArray4[i2] = d3 - d4;
            dArray4[n - i2] = d3 + d4;
            d2 += d5;
        }
        FastFourierTransformer fastFourierTransformer = new FastFourierTransformer(DftNormalization.STANDARD);
        Complex[] complexArray = fastFourierTransformer.transform(dArray4, TransformType.FORWARD);
        dArray2[0] = complexArray[0].getReal();
        dArray2[1] = d2;
        for (int i3 = 1; i3 < n >> 1; ++i3) {
            dArray2[2 * i3] = complexArray[i3].getReal();
            dArray2[2 * i3 + 1] = dArray2[2 * i3 - 1] - complexArray[i3].getImaginary();
        }
        dArray2[n] = complexArray[n >> 1].getReal();
        return dArray2;
    }
}

