/*
 * Decompiled with CFR 0.152.
 */
package games.aquastudios.aquaclient.shaded.apache.commons.math3.stat.regression;

import games.aquastudios.aquaclient.shaded.apache.commons.math3.linear.Array2DRowRealMatrix;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.linear.LUDecomposition;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.linear.QRDecomposition;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.linear.RealMatrix;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.linear.RealVector;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.stat.StatUtils;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.stat.descriptive.AbstractUnivariateStatistic;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.stat.descriptive.moment.SecondMoment;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.stat.regression.AbstractMultipleLinearRegression;

public class OLSMultipleLinearRegression
extends AbstractMultipleLinearRegression {
    private QRDecomposition qr = null;
    private final double threshold;

    public OLSMultipleLinearRegression() {
        this(0.0);
    }

    public OLSMultipleLinearRegression(double d2) {
        this.threshold = d2;
    }

    public void newSampleData(double[] dArray, double[][] dArray2) {
        this.validateSampleData(dArray2, dArray);
        this.newYSampleData(dArray);
        this.newXSampleData(dArray2);
    }

    public void newSampleData(double[] dArray, int n, int n2) {
        super.newSampleData(dArray, n, n2);
        this.qr = new QRDecomposition(this.getX(), this.threshold);
    }

    public RealMatrix calculateHat() {
        int n;
        RealMatrix realMatrix = this.qr.getQ();
        int n2 = this.qr.getR().getColumnDimension();
        int n3 = n = realMatrix.getColumnDimension();
        Array2DRowRealMatrix array2DRowRealMatrix = new Array2DRowRealMatrix(n3, n3);
        double[][] dArray = array2DRowRealMatrix.getDataRef();
        for (int i2 = 0; i2 < n; ++i2) {
            for (int i3 = 0; i3 < n; ++i3) {
                dArray[i2][i3] = i2 == i3 && i2 < n2 ? 1.0 : 0.0;
            }
        }
        return realMatrix.multiply(array2DRowRealMatrix).multiply(realMatrix.transpose());
    }

    public double calculateTotalSumOfSquares() {
        if (this.isNoIntercept()) {
            return StatUtils.sumSq(this.getY().toArray());
        }
        return ((AbstractUnivariateStatistic)new SecondMoment()).evaluate(this.getY().toArray());
    }

    public double calculateResidualSumOfSquares() {
        RealVector realVector = this.calculateResiduals();
        return realVector.dotProduct(realVector);
    }

    public double calculateRSquared() {
        return 1.0 - this.calculateResidualSumOfSquares() / this.calculateTotalSumOfSquares();
    }

    public double calculateAdjustedRSquared() {
        double d2 = this.getX().getRowDimension();
        if (this.isNoIntercept()) {
            double d3 = d2;
            return 1.0 - (1.0 - this.calculateRSquared()) * (d3 / (d3 - (double)this.getX().getColumnDimension()));
        }
        return 1.0 - this.calculateResidualSumOfSquares() * (d2 - 1.0) / (this.calculateTotalSumOfSquares() * (d2 - (double)this.getX().getColumnDimension()));
    }

    protected void newXSampleData(double[][] dArray) {
        super.newXSampleData(dArray);
        this.qr = new QRDecomposition(this.getX(), this.threshold);
    }

    protected RealVector calculateBeta() {
        return this.qr.getSolver().solve(this.getY());
    }

    protected RealMatrix calculateBetaVariance() {
        int n = this.getX().getColumnDimension();
        RealMatrix realMatrix = this.qr.getR().getSubMatrix(0, n - 1, 0, n - 1);
        realMatrix = new LUDecomposition(realMatrix).getSolver().getInverse();
        return realMatrix.multiply(realMatrix.transpose());
    }
}

