/*
 * Decompiled with CFR 0.152.
 */
package games.aquastudios.aquaclient.shaded.apache.commons.math3.stat.regression;

import games.aquastudios.aquaclient.shaded.apache.commons.math3.exception.util.LocalizedFormats;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.stat.regression.ModelSpecificationException;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.stat.regression.RegressionResults;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.stat.regression.UpdatingMultipleLinearRegression;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.util.FastMath;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.util.MathArrays;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.util.Precision;
import java.util.Arrays;

public class MillerUpdatingRegression
implements UpdatingMultipleLinearRegression {
    private final int nvars;
    private final double[] d;
    private final double[] rhs;
    private final double[] r;
    private final double[] tol;
    private final double[] rss;
    private final int[] vorder;
    private final double[] work_tolset;
    private long nobs = 0L;
    private double sserr = 0.0;
    private boolean rss_set = false;
    private boolean tol_set = false;
    private final boolean[] lindep;
    private final double[] x_sing;
    private final double[] work_sing;
    private double sumy = 0.0;
    private double sumsqy = 0.0;
    private boolean hasIntercept;
    private final double epsilon;

    private MillerUpdatingRegression() {
        this(-1, false, Double.NaN);
    }

    public MillerUpdatingRegression(int n, boolean bl, double d2) {
        if (n <= 0) {
            throw new ModelSpecificationException(LocalizedFormats.NO_REGRESSORS, new Object[0]);
        }
        this.nvars = bl ? n + 1 : n;
        this.hasIntercept = bl;
        this.nobs = 0L;
        this.d = new double[this.nvars];
        this.rhs = new double[this.nvars];
        this.r = new double[this.nvars * (this.nvars - 1) / 2];
        this.tol = new double[this.nvars];
        this.rss = new double[this.nvars];
        this.vorder = new int[this.nvars];
        this.x_sing = new double[this.nvars];
        this.work_sing = new double[this.nvars];
        this.work_tolset = new double[this.nvars];
        this.lindep = new boolean[this.nvars];
        n = 0;
        while (n < this.nvars) {
            int n2 = n++;
            this.vorder[n2] = n2;
        }
        if (d2 > 0.0) {
            this.epsilon = d2;
            return;
        }
        this.epsilon = -d2;
    }

    public MillerUpdatingRegression(int n, boolean bl) {
        this(n, bl, Precision.EPSILON);
    }

    public boolean hasIntercept() {
        return this.hasIntercept;
    }

    public long getN() {
        return this.nobs;
    }

    public void addObservation(double[] dArray, double d2) {
        if (!this.hasIntercept && dArray.length != this.nvars || this.hasIntercept && dArray.length + 1 != this.nvars) {
            throw new ModelSpecificationException(LocalizedFormats.INVALID_REGRESSION_OBSERVATION, dArray.length, this.nvars);
        }
        if (!this.hasIntercept) {
            this.include(MathArrays.copyOf(dArray, dArray.length), 1.0, d2);
        } else {
            double[] dArray2 = new double[dArray.length + 1];
            System.arraycopy(dArray, 0, dArray2, 1, dArray.length);
            dArray2[0] = 1.0;
            this.include(dArray2, 1.0, d2);
        }
        ++this.nobs;
    }

    public void addObservations(double[][] dArray, double[] dArray2) {
        if (dArray == null || dArray2 == null || dArray.length != dArray2.length) {
            throw new ModelSpecificationException(LocalizedFormats.DIMENSIONS_MISMATCH_SIMPLE, dArray == null ? 0 : dArray.length, dArray2 == null ? 0 : dArray2.length);
        }
        if (dArray.length == 0) {
            throw new ModelSpecificationException(LocalizedFormats.NO_DATA, new Object[0]);
        }
        if (dArray[0].length + 1 > dArray.length) {
            throw new ModelSpecificationException(LocalizedFormats.NOT_ENOUGH_DATA_FOR_NUMBER_OF_PREDICTORS, dArray.length, dArray[0].length);
        }
        for (int i2 = 0; i2 < dArray.length; ++i2) {
            this.addObservation(dArray[i2], dArray2[i2]);
        }
    }

    private void include(double[] dArray, double d2, double d3) {
        int n = 0;
        double d4 = d2;
        double d5 = d3;
        this.rss_set = false;
        this.sumy = this.smartAdd(d3, this.sumy);
        double d6 = d3;
        this.sumsqy = this.smartAdd(this.sumsqy, d6 * d6);
        for (int i2 = 0; i2 < dArray.length; ++i2) {
            double d7;
            double d8;
            if (d4 == 0.0) {
                return;
            }
            double d9 = dArray[i2];
            if (d9 == 0.0) {
                n += this.nvars - i2 - 1;
                continue;
            }
            double d10 = this.d[i2];
            double d11 = d4 * d9;
            double d12 = d4;
            if (d10 != 0.0) {
                double d13;
                d8 = this.smartAdd(d10, d11 * d9);
                double d14 = d11 * d9 / d10;
                if (FastMath.abs(d13) > Precision.EPSILON) {
                    d4 = d10 * d4 / d8;
                }
            } else {
                d8 = d11 * d9;
                d4 = 0.0;
            }
            this.d[i2] = d8;
            for (int i3 = i2 + 1; i3 < this.nvars; ++i3) {
                d7 = dArray[i3];
                dArray[i3] = this.smartAdd(d7, -d9 * this.r[n]);
                this.r[n] = d10 != 0.0 ? this.smartAdd(d10 * this.r[n], d12 * d9 * d7) / d8 : d7 / d9;
                ++n;
            }
            d7 = d5;
            d5 = this.smartAdd(d7, -d9 * this.rhs[i2]);
            this.rhs[i2] = d10 != 0.0 ? this.smartAdd(d10 * this.rhs[i2], d11 * d7) / d8 : d7 / d9;
        }
        this.sserr = this.smartAdd(this.sserr, d4 * d5 * d5);
    }

    private double smartAdd(double d2, double d3) {
        double d4;
        double d5 = FastMath.abs(d2);
        if (d5 > (d4 = FastMath.abs(d3))) {
            double d6 = d5 * Precision.EPSILON;
            if (d4 > d6) {
                return d2 + d3;
            }
            return d2;
        }
        double d7 = d4 * Precision.EPSILON;
        if (d5 > d7) {
            return d2 + d3;
        }
        return d3;
    }

    public void clear() {
        Arrays.fill(this.d, 0.0);
        Arrays.fill(this.rhs, 0.0);
        Arrays.fill(this.r, 0.0);
        Arrays.fill(this.tol, 0.0);
        Arrays.fill(this.rss, 0.0);
        Arrays.fill(this.work_tolset, 0.0);
        Arrays.fill(this.work_sing, 0.0);
        Arrays.fill(this.x_sing, 0.0);
        Arrays.fill(this.lindep, false);
        int n = 0;
        while (n < this.nvars) {
            int n2 = n++;
            this.vorder[n2] = n2;
        }
        this.nobs = 0L;
        this.sserr = 0.0;
        this.sumy = 0.0;
        this.sumsqy = 0.0;
        this.rss_set = false;
        this.tol_set = false;
    }

    private void tolset() {
        int n;
        double d2 = this.epsilon;
        for (n = 0; n < this.nvars; ++n) {
            this.work_tolset[n] = FastMath.sqrt(this.d[n]);
        }
        this.tol[0] = d2 * this.work_tolset[0];
        for (n = 1; n < this.nvars; ++n) {
            int n2 = n - 1;
            double d3 = this.work_tolset[n];
            for (int i2 = 0; i2 < n; ++i2) {
                d3 += FastMath.abs(this.r[n2]) * this.work_tolset[i2];
                n2 += this.nvars - i2 - 2;
            }
            this.tol[n] = d2 * d3;
        }
        this.tol_set = true;
    }

    private double[] regcf(int n) {
        int n2;
        if (n <= 0) {
            throw new ModelSpecificationException(LocalizedFormats.NO_REGRESSORS, new Object[0]);
        }
        if (n > this.nvars) {
            throw new ModelSpecificationException(LocalizedFormats.TOO_MANY_REGRESSORS, n, this.nvars);
        }
        if (!this.tol_set) {
            this.tolset();
        }
        double[] dArray = new double[n];
        boolean bl = false;
        for (n2 = n - 1; n2 >= 0; --n2) {
            if (FastMath.sqrt(this.d[n2]) < this.tol[n2]) {
                dArray[n2] = 0.0;
                this.d[n2] = 0.0;
                bl = true;
                continue;
            }
            dArray[n2] = this.rhs[n2];
            int n3 = n2 * (this.nvars + this.nvars - n2 - 1) / 2;
            for (int i2 = n2 + 1; i2 < n; ++i2) {
                dArray[n2] = this.smartAdd(dArray[n2], -this.r[n3] * dArray[i2]);
                ++n3;
            }
        }
        if (bl) {
            for (n2 = 0; n2 < n; ++n2) {
                if (!this.lindep[n2]) continue;
                dArray[n2] = Double.NaN;
            }
        }
        return dArray;
    }

    private void singcheck() {
        int n;
        for (n = 0; n < this.nvars; ++n) {
            this.work_sing[n] = FastMath.sqrt(this.d[n]);
        }
        for (n = 0; n < this.nvars; ++n) {
            int n2;
            double d2 = this.tol[n];
            int n3 = n - 1;
            for (n2 = 0; n2 < n - 1; ++n2) {
                if (FastMath.abs(this.r[n3]) * this.work_sing[n2] < d2) {
                    this.r[n3] = 0.0;
                }
                n3 += this.nvars - n2 - 2;
            }
            this.lindep[n] = false;
            if (!(this.work_sing[n] < d2)) continue;
            this.lindep[n] = true;
            if (n < this.nvars - 1) {
                Arrays.fill(this.x_sing, 0.0);
                n2 = n * (this.nvars + this.nvars - n - 1) / 2;
                int n4 = n + 1;
                while (n4 < this.nvars) {
                    this.x_sing[n4] = this.r[n2];
                    this.r[n2] = 0.0;
                    ++n4;
                    ++n2;
                }
                double d3 = this.rhs[n];
                double d4 = this.d[n];
                this.d[n] = 0.0;
                this.rhs[n] = 0.0;
                MillerUpdatingRegression millerUpdatingRegression = this;
                millerUpdatingRegression.include(millerUpdatingRegression.x_sing, d4, d3);
                continue;
            }
            this.sserr += this.d[n] * this.rhs[n] * this.rhs[n];
        }
    }

    private void ss() {
        double d2 = this.sserr;
        this.rss[this.nvars - 1] = this.sserr;
        for (int i2 = this.nvars - 1; i2 > 0; --i2) {
            this.rss[i2 - 1] = d2 += this.d[i2] * this.rhs[i2] * this.rhs[i2];
        }
        this.rss_set = true;
    }

    private double[] cov(int n) {
        if (this.nobs <= (long)n) {
            return null;
        }
        double d2 = 0.0;
        for (int i2 = 0; i2 < n; ++i2) {
            if (this.lindep[i2]) continue;
            d2 += 1.0;
        }
        double d3 = this.rss[n - 1] / ((double)this.nobs - d2);
        int n2 = n;
        double[] dArray = new double[n2 * (n2 - 1) / 2];
        this.inverse(dArray, n);
        int n3 = n;
        double[] dArray2 = new double[n3 * (n3 + 1) / 2];
        Arrays.fill(dArray2, Double.NaN);
        int n4 = 0;
        for (int i3 = 0; i3 < n; ++i3) {
            int n5 = n4;
            if (!this.lindep[i3]) {
                for (int i4 = i3; i4 < n; ++i4) {
                    if (!this.lindep[i4]) {
                        int n6 = n4 + i4 - i3;
                        double d4 = i3 == i4 ? 1.0 / this.d[i4] : dArray[n6 - 1] / this.d[i4];
                        for (int i5 = i4 + 1; i5 < n; ++i5) {
                            if (!this.lindep[i5]) {
                                d4 += dArray[n6] * dArray[n5] / this.d[i5];
                            }
                            ++n6;
                            ++n5;
                        }
                        dArray2[(i4 + 1) * i4 / 2 + i3] = d4 * d3;
                        continue;
                    }
                    n5 += n - i4 - 1;
                }
            }
            n4 += n - i3 - 1;
        }
        return dArray2;
    }

    private void inverse(double[] dArray, int n) {
        int n2 = n;
        int n3 = n2 * (n2 - 1) / 2 - 1;
        Arrays.fill(dArray, Double.NaN);
        for (int i2 = n - 1; i2 > 0; --i2) {
            if (!this.lindep[i2]) {
                int n4 = (i2 - 1) * (this.nvars + this.nvars - i2) / 2;
                for (int i3 = n; i3 > i2; --i3) {
                    int n5 = n4;
                    int n6 = n3;
                    double d2 = 0.0;
                    for (int i4 = i2; i4 < i3 - 1; ++i4) {
                        n6 += n - i4 - 1;
                        if (!this.lindep[i4]) {
                            d2 += -this.r[n5] * dArray[n6];
                        }
                        ++n5;
                    }
                    dArray[n3] = d2 - this.r[n5];
                    --n3;
                }
                continue;
            }
            n3 -= n - i2;
        }
    }

    public double[] getPartialCorrelations(int n) {
        int n2;
        int n3;
        double[] dArray = new double[(this.nvars - n + 1) * (this.nvars - n) / 2];
        int n4 = -n;
        int n5 = -(n + 1);
        double[] dArray2 = new double[this.nvars - n];
        double[] dArray3 = new double[this.nvars - n - 1];
        int n6 = (this.nvars - n) * (this.nvars - n - 1) / 2;
        if (n < -1 || n >= this.nvars) {
            return null;
        }
        int n7 = this.nvars - 1;
        int n8 = this.r.length - (n7 - n) * (n7 - n + 1) / 2;
        if (this.d[n] > 0.0) {
            dArray2[n + n4] = 1.0 / FastMath.sqrt(this.d[n]);
        }
        for (n3 = n + 1; n3 < this.nvars; ++n3) {
            n7 = n8 + n3 - 1 - n;
            double d2 = this.d[n3];
            for (n2 = n; n2 < n3; ++n2) {
                d2 += this.d[n2] * this.r[n7] * this.r[n7];
                n7 += this.nvars - n2 - 2;
            }
            dArray2[n3 + n4] = d2 > 0.0 ? 1.0 / FastMath.sqrt(d2) : 0.0;
        }
        double d3 = this.sserr;
        for (n3 = n; n3 < this.nvars; ++n3) {
            d3 += this.d[n3] * this.rhs[n3] * this.rhs[n3];
        }
        if (d3 > 0.0) {
            d3 = 1.0 / FastMath.sqrt(d3);
        }
        for (n3 = n; n3 < this.nvars; ++n3) {
            int n9;
            double d4 = 0.0;
            Arrays.fill(dArray3, 0.0);
            n7 = n8 + n3 - n - 1;
            for (n2 = n; n2 < n3; ++n2) {
                n9 = n7 + 1;
                for (int i2 = n3 + 1; i2 < this.nvars; ++i2) {
                    int n10 = i2 + n5;
                    dArray3[n10] = dArray3[n10] + this.d[n2] * this.r[n7] * this.r[n9];
                    ++n9;
                }
                d4 += this.d[n2] * this.r[n7] * this.rhs[n2];
                n7 += this.nvars - n2 - 2;
            }
            n9 = n7 + 1;
            for (n2 = n3 + 1; n2 < this.nvars; ++n2) {
                int n11 = n2 + n5;
                dArray3[n11] = dArray3[n11] + this.d[n3] * this.r[n9];
                ++n9;
                dArray[(n2 - 1 - n) * (n2 - n) / 2 + n3 - n] = dArray3[n2 + n5] * dArray2[n3 + n4] * dArray2[n2 + n4];
            }
            dArray[n3 + n4 + n6] = (d4 += this.d[n3] * this.rhs[n3]) * dArray2[n3 + n4] * d3;
        }
        return dArray;
    }

    private void vmove(int n, int n2) {
        int n3;
        int n4;
        int n5;
        boolean bl = false;
        if (n == n2) {
            return;
        }
        if (!this.rss_set) {
            this.ss();
        }
        if (n < n2) {
            n5 = n;
            n4 = 1;
            n3 = n2 - n;
        } else {
            n5 = n - 1;
            n4 = -1;
            n3 = n - n2;
        }
        int n6 = n5;
        for (int i2 = 0; i2 < n3; ++i2) {
            int n7;
            double d2;
            n = n6 * (this.nvars + this.nvars - n6 - 1) / 2;
            n2 = n + this.nvars - n6 - 1;
            int n8 = n6 + 1;
            double d3 = this.d[n6];
            double d4 = this.d[n8];
            if (d3 > this.epsilon || d4 > this.epsilon) {
                double d5;
                d2 = this.r[n];
                if (FastMath.abs(d5) * FastMath.sqrt(d3) < this.tol[n8]) {
                    d2 = 0.0;
                }
                if (d3 < this.epsilon || FastMath.abs(d2) < this.epsilon) {
                    this.d[n6] = d4;
                    this.d[n8] = d3;
                    this.r[n] = 0.0;
                    for (n7 = n6 + 2; n7 < this.nvars; ++n7) {
                        d2 = this.r[++n];
                        this.r[n] = this.r[n2];
                        this.r[n2] = d2;
                        ++n2;
                    }
                    d2 = this.rhs[n6];
                    this.rhs[n6] = this.rhs[n8];
                    this.rhs[n8] = d2;
                    bl = true;
                } else if (d4 < this.epsilon) {
                    this.d[n6] = d3 * d2 * d2;
                    this.r[n] = 1.0 / d2;
                    n7 = n + 1;
                    while (n7 < n + this.nvars - n6 - 1) {
                        int n9 = n7++;
                        this.r[n9] = this.r[n9] / d2;
                    }
                    int n10 = n6;
                    this.rhs[n10] = this.rhs[n10] / d2;
                    bl = true;
                }
                if (!bl) {
                    double d6;
                    double d7 = d4 + d3 * d2 * d2;
                    double d8 = d4 / d7;
                    double d9 = d2 * d3 / d7;
                    double d10 = d3 * d8;
                    this.d[n6] = d7;
                    this.d[n8] = d10;
                    this.r[n] = d9;
                    for (n7 = n6 + 2; n7 < this.nvars; ++n7) {
                        d6 = this.r[++n];
                        this.r[n] = d8 * this.r[n2] + d9 * d6;
                        this.r[n2] = d6 - d2 * this.r[n2];
                        ++n2;
                    }
                    d6 = this.rhs[n6];
                    this.rhs[n6] = d8 * this.rhs[n8] + d9 * d6;
                    this.rhs[n8] = d6 - d2 * this.rhs[n8];
                }
            }
            if (n6 > 0) {
                n = n6;
                for (n7 = 0; n7 < n6; ++n7) {
                    d2 = this.r[n];
                    this.r[n] = this.r[n - 1];
                    this.r[n - 1] = d2;
                    n += this.nvars - n7 - 2;
                }
            }
            n = this.vorder[n6];
            this.vorder[n6] = this.vorder[n8];
            this.vorder[n8] = n;
            d2 = this.tol[n6];
            this.tol[n6] = this.tol[n8];
            this.tol[n8] = d2;
            this.rss[n6] = this.rss[n8] + this.d[n8] * this.rhs[n8] * this.rhs[n8];
            n6 += n4;
        }
    }

    private int reorderRegressors(int[] nArray, int n) {
        if (nArray.length <= 0 || nArray.length > this.nvars + 1 - n) {
            return -1;
        }
        int n2 = n;
        block0: for (int i2 = n; i2 < this.nvars; ++i2) {
            int n3 = this.vorder[i2];
            for (int i3 = 0; i3 < nArray.length; ++i3) {
                if (n3 != nArray[i3] || i2 <= n2) continue;
                this.vmove(i2, n2);
                if (++n2 < nArray.length + n) continue block0;
                return 0;
            }
        }
        return 0;
    }

    public double getDiagonalOfHatMatrix(double[] dArray) {
        double[] dArray2;
        double[] dArray3 = new double[this.nvars];
        if (dArray.length > this.nvars) {
            return Double.NaN;
        }
        if (this.hasIntercept) {
            double[] dArray4 = new double[dArray.length + 1];
            dArray2 = dArray4;
            dArray4[0] = 1.0;
            System.arraycopy(dArray, 0, dArray2, 1, dArray.length);
        } else {
            dArray2 = dArray;
        }
        double d2 = 0.0;
        for (int i2 = 0; i2 < dArray2.length; ++i2) {
            if (FastMath.sqrt(this.d[i2]) < this.tol[i2]) {
                dArray3[i2] = 0.0;
                continue;
            }
            int n = i2 - 1;
            double d3 = dArray2[i2];
            for (int i3 = 0; i3 < i2; ++i3) {
                d3 = this.smartAdd(d3, -dArray3[i3] * this.r[n]);
                n += this.nvars - i3 - 2;
            }
            dArray3[i2] = d3;
            double d4 = d3;
            d2 = this.smartAdd(d2, d4 * d4 / this.d[i2]);
        }
        return d2;
    }

    public int[] getOrderOfRegressors() {
        return MathArrays.copyOf(this.vorder);
    }

    public RegressionResults regress() {
        MillerUpdatingRegression millerUpdatingRegression = this;
        return millerUpdatingRegression.regress(millerUpdatingRegression.nvars);
    }

    public RegressionResults regress(int n) {
        int n2;
        int n3;
        int n4;
        if (this.nobs <= (long)n) {
            throw new ModelSpecificationException(LocalizedFormats.NOT_ENOUGH_DATA_FOR_NUMBER_OF_PREDICTORS, this.nobs, n);
        }
        if (n > this.nvars) {
            throw new ModelSpecificationException(LocalizedFormats.TOO_MANY_REGRESSORS, n, this.nvars);
        }
        this.tolset();
        this.singcheck();
        double[] dArray = this.regcf(n);
        this.ss();
        double[] dArray2 = this.cov(n);
        int n5 = 0;
        for (n4 = 0; n4 < this.lindep.length; ++n4) {
            if (this.lindep[n4]) continue;
            ++n5;
        }
        n4 = 0;
        for (int i2 = 0; i2 < n; ++i2) {
            if (this.vorder[i2] == i2) continue;
            n4 = 1;
            break;
        }
        if (n4 == 0) {
            return new RegressionResults(dArray, new double[][]{dArray2}, true, this.nobs, n5, this.sumy, this.sumsqy, this.sserr, this.hasIntercept, false);
        }
        double[] dArray3 = new double[dArray.length];
        double[] dArray4 = new double[dArray2.length];
        int[] nArray = new int[dArray.length];
        for (n3 = 0; n3 < this.nvars; ++n3) {
            for (n2 = 0; n2 < n; ++n2) {
                if (this.vorder[n2] != n3) continue;
                dArray3[n3] = dArray[n2];
                nArray[n3] = n2;
            }
        }
        n3 = 0;
        for (int i3 = 0; i3 < dArray.length; ++i3) {
            n = nArray[i3];
            int n6 = 0;
            while (n6 <= i3) {
                n2 = nArray[n6];
                if (n > n2) {
                    int n7 = n;
                    n2 = n7 * (n7 + 1) / 2 + n2;
                } else {
                    int n8 = n2;
                    n2 = n8 * (n8 + 1) / 2 + n;
                }
                dArray4[n3] = dArray2[n2];
                ++n6;
                ++n3;
            }
        }
        return new RegressionResults(dArray3, new double[][]{dArray4}, true, this.nobs, n5, this.sumy, this.sumsqy, this.sserr, this.hasIntercept, false);
    }

    public RegressionResults regress(int[] nArray) {
        int n;
        int n2;
        int[] nArray2;
        if (nArray.length > this.nvars) {
            throw new ModelSpecificationException(LocalizedFormats.TOO_MANY_REGRESSORS, nArray.length, this.nvars);
        }
        if (this.nobs <= (long)this.nvars) {
            throw new ModelSpecificationException(LocalizedFormats.NOT_ENOUGH_DATA_FOR_NUMBER_OF_PREDICTORS, this.nobs, this.nvars);
        }
        Arrays.sort(nArray);
        int n3 = 0;
        for (int i2 = 0; i2 < nArray.length; ++i2) {
            if (i2 >= this.nvars) {
                throw new ModelSpecificationException(LocalizedFormats.INDEX_LARGER_THAN_MAX, i2, this.nvars);
            }
            if (i2 <= 0 || nArray[i2] != nArray[i2 - 1]) continue;
            nArray[i2] = -1;
            ++n3;
        }
        if (n3 > 0) {
            int n4 = 0;
            nArray2 = new int[nArray.length - n3];
            for (n3 = 0; n3 < nArray.length; ++n3) {
                if (nArray[n3] < 0) continue;
                nArray2[n4] = nArray[n3];
                ++n4;
            }
        } else {
            nArray2 = nArray;
        }
        this.reorderRegressors(nArray2, 0);
        this.tolset();
        this.singcheck();
        double[] dArray = this.regcf(nArray2.length);
        this.ss();
        double[] dArray2 = this.cov(nArray2.length);
        int n5 = 0;
        for (n2 = 0; n2 < this.lindep.length; ++n2) {
            if (this.lindep[n2]) continue;
            ++n5;
        }
        n2 = 0;
        for (int i3 = 0; i3 < this.nvars; ++i3) {
            if (this.vorder[i3] == nArray2[i3]) continue;
            n2 = 1;
            break;
        }
        if (n2 == 0) {
            return new RegressionResults(dArray, new double[][]{dArray2}, true, this.nobs, n5, this.sumy, this.sumsqy, this.sserr, this.hasIntercept, false);
        }
        double[] dArray3 = new double[dArray.length];
        int[] nArray3 = new int[dArray.length];
        for (int i4 = 0; i4 < nArray2.length; ++i4) {
            for (n = 0; n < this.vorder.length; ++n) {
                if (this.vorder[n] != nArray2[i4]) continue;
                dArray3[i4] = dArray[n];
                nArray3[i4] = n;
            }
        }
        double[] dArray4 = new double[dArray2.length];
        n = 0;
        for (int i5 = 0; i5 < dArray.length; ++i5) {
            int n6 = nArray3[i5];
            int n7 = 0;
            while (n7 <= i5) {
                int n8 = nArray3[n7];
                if (n6 > n8) {
                    int n9 = n6;
                    n8 = n9 * (n9 + 1) / 2 + n8;
                } else {
                    int n10 = n8;
                    n8 = n10 * (n10 + 1) / 2 + n6;
                }
                dArray4[n] = dArray2[n8];
                ++n7;
                ++n;
            }
        }
        return new RegressionResults(dArray3, new double[][]{dArray4}, true, this.nobs, n5, this.sumy, this.sumsqy, this.sserr, this.hasIntercept, false);
    }
}

