/*
 * Decompiled with CFR 0.152.
 */
package games.aquastudios.aquaclient.shaded.apache.commons.math3.stat.regression;

import games.aquastudios.aquaclient.shaded.apache.commons.math3.exception.DimensionMismatchException;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.exception.InsufficientDataException;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.exception.MathIllegalArgumentException;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.exception.NoDataException;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.exception.NullArgumentException;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.exception.util.LocalizedFormats;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.linear.Array2DRowRealMatrix;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.linear.ArrayRealVector;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.linear.NonSquareMatrixException;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.linear.RealMatrix;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.linear.RealVector;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.stat.descriptive.AbstractUnivariateStatistic;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.stat.descriptive.moment.Variance;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.stat.regression.MultipleLinearRegression;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.util.FastMath;

public abstract class AbstractMultipleLinearRegression
implements MultipleLinearRegression {
    private RealMatrix xMatrix;
    private RealVector yVector;
    private boolean noIntercept = false;

    protected RealMatrix getX() {
        return this.xMatrix;
    }

    protected RealVector getY() {
        return this.yVector;
    }

    public boolean isNoIntercept() {
        return this.noIntercept;
    }

    public void setNoIntercept(boolean bl) {
        this.noIntercept = bl;
    }

    public void newSampleData(double[] dArray, int n, int n2) {
        if (dArray == null) {
            throw new NullArgumentException();
        }
        if (dArray.length != n * (n2 + 1)) {
            throw new DimensionMismatchException(dArray.length, n * (n2 + 1));
        }
        if (n <= n2) {
            throw new InsufficientDataException(LocalizedFormats.INSUFFICIENT_OBSERVED_POINTS_IN_SAMPLE, n, n2 + 1);
        }
        double[] dArray2 = new double[n];
        n2 = this.noIntercept ? n2 : n2 + 1;
        double[][] dArray3 = new double[n][n2];
        int n3 = 0;
        for (int i2 = 0; i2 < n; ++i2) {
            int n4;
            dArray2[i2] = dArray[n3++];
            if (!this.noIntercept) {
                dArray3[i2][0] = 1.0;
            }
            int n5 = n4 = this.noIntercept ? 0 : 1;
            while (n4 < n2) {
                dArray3[i2][n4] = dArray[n3++];
                ++n4;
            }
        }
        this.xMatrix = new Array2DRowRealMatrix(dArray3);
        this.yVector = new ArrayRealVector(dArray2);
    }

    protected void newYSampleData(double[] dArray) {
        if (dArray == null) {
            throw new NullArgumentException();
        }
        if (dArray.length == 0) {
            throw new NoDataException();
        }
        this.yVector = new ArrayRealVector(dArray);
    }

    protected void newXSampleData(double[][] dArray) {
        if (dArray == null) {
            throw new NullArgumentException();
        }
        if (dArray.length == 0) {
            throw new NoDataException();
        }
        if (this.noIntercept) {
            this.xMatrix = new Array2DRowRealMatrix(dArray, true);
            return;
        }
        int n = dArray[0].length;
        double[][] dArray2 = new double[dArray.length][n + 1];
        for (int i2 = 0; i2 < dArray.length; ++i2) {
            if (dArray[i2].length != n) {
                throw new DimensionMismatchException(dArray[i2].length, n);
            }
            dArray2[i2][0] = 1.0;
            System.arraycopy(dArray[i2], 0, dArray2[i2], 1, n);
        }
        this.xMatrix = new Array2DRowRealMatrix(dArray2, false);
    }

    protected void validateSampleData(double[][] dArray, double[] dArray2) {
        if (dArray == null || dArray2 == null) {
            throw new NullArgumentException();
        }
        if (dArray.length != dArray2.length) {
            throw new DimensionMismatchException(dArray2.length, dArray.length);
        }
        if (dArray.length == 0) {
            throw new NoDataException();
        }
        if (dArray[0].length + 1 > dArray.length) {
            throw new MathIllegalArgumentException(LocalizedFormats.NOT_ENOUGH_DATA_FOR_NUMBER_OF_PREDICTORS, dArray.length, dArray[0].length);
        }
    }

    protected void validateCovarianceData(double[][] dArray, double[][] dArray2) {
        if (dArray.length != dArray2.length) {
            throw new DimensionMismatchException(dArray.length, dArray2.length);
        }
        if (dArray2.length > 0 && dArray2.length != dArray2[0].length) {
            throw new NonSquareMatrixException(dArray2.length, dArray2[0].length);
        }
    }

    public double[] estimateRegressionParameters() {
        RealVector realVector = this.calculateBeta();
        return realVector.toArray();
    }

    public double[] estimateResiduals() {
        RealVector realVector = this.calculateBeta();
        realVector = this.yVector.subtract(this.xMatrix.operate(realVector));
        return realVector.toArray();
    }

    public double[][] estimateRegressionParametersVariance() {
        return this.calculateBetaVariance().getData();
    }

    public double[] estimateRegressionParametersStandardErrors() {
        double[][] dArray = this.estimateRegressionParametersVariance();
        double d2 = this.calculateErrorVariance();
        int n = dArray[0].length;
        double[] dArray2 = new double[n];
        for (int i2 = 0; i2 < n; ++i2) {
            dArray2[i2] = FastMath.sqrt(d2 * dArray[i2][i2]);
        }
        return dArray2;
    }

    public double estimateRegressandVariance() {
        return this.calculateYVariance();
    }

    public double estimateErrorVariance() {
        return this.calculateErrorVariance();
    }

    public double estimateRegressionStandardError() {
        return FastMath.sqrt(this.estimateErrorVariance());
    }

    protected abstract RealVector calculateBeta();

    protected abstract RealMatrix calculateBetaVariance();

    protected double calculateYVariance() {
        return ((AbstractUnivariateStatistic)new Variance()).evaluate(this.yVector.toArray());
    }

    protected double calculateErrorVariance() {
        RealVector realVector = this.calculateResiduals();
        return realVector.dotProduct(realVector) / (double)(this.xMatrix.getRowDimension() - this.xMatrix.getColumnDimension());
    }

    protected RealVector calculateResiduals() {
        RealVector realVector = this.calculateBeta();
        return this.yVector.subtract(this.xMatrix.operate(realVector));
    }
}

