/*
 * Decompiled with CFR 0.152.
 */
package games.aquastudios.aquaclient.shaded.apache.commons.math3.stat.ranking;

import games.aquastudios.aquaclient.shaded.apache.commons.math3.exception.MathInternalError;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.exception.NotANumberException;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.random.RandomDataGenerator;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.random.RandomGenerator;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.stat.ranking.NaNStrategy;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.stat.ranking.NaturalRanking$IntDoublePair;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.stat.ranking.RankingAlgorithm;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.stat.ranking.TiesStrategy;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.util.FastMath;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NaturalRanking
implements RankingAlgorithm {
    public static final NaNStrategy DEFAULT_NAN_STRATEGY = NaNStrategy.FAILED;
    public static final TiesStrategy DEFAULT_TIES_STRATEGY = TiesStrategy.AVERAGE;
    private final NaNStrategy nanStrategy;
    private final TiesStrategy tiesStrategy;
    private final RandomDataGenerator randomData;

    public NaturalRanking() {
        this.tiesStrategy = DEFAULT_TIES_STRATEGY;
        this.nanStrategy = DEFAULT_NAN_STRATEGY;
        this.randomData = null;
    }

    public NaturalRanking(TiesStrategy tiesStrategy) {
        this.tiesStrategy = tiesStrategy;
        this.nanStrategy = DEFAULT_NAN_STRATEGY;
        this.randomData = new RandomDataGenerator();
    }

    public NaturalRanking(NaNStrategy naNStrategy) {
        this.nanStrategy = naNStrategy;
        this.tiesStrategy = DEFAULT_TIES_STRATEGY;
        this.randomData = null;
    }

    public NaturalRanking(NaNStrategy naNStrategy, TiesStrategy tiesStrategy) {
        this.nanStrategy = naNStrategy;
        this.tiesStrategy = tiesStrategy;
        this.randomData = new RandomDataGenerator();
    }

    public NaturalRanking(RandomGenerator randomGenerator) {
        this.tiesStrategy = TiesStrategy.RANDOM;
        this.nanStrategy = DEFAULT_NAN_STRATEGY;
        this.randomData = new RandomDataGenerator(randomGenerator);
    }

    public NaturalRanking(NaNStrategy naNStrategy, RandomGenerator randomGenerator) {
        this.nanStrategy = naNStrategy;
        this.tiesStrategy = TiesStrategy.RANDOM;
        this.randomData = new RandomDataGenerator(randomGenerator);
    }

    public NaNStrategy getNanStrategy() {
        return this.nanStrategy;
    }

    public TiesStrategy getTiesStrategy() {
        return this.tiesStrategy;
    }

    @Override
    public double[] rank(double[] dArray) {
        Object[] objectArray = new NaturalRanking$IntDoublePair[dArray.length];
        for (int i2 = 0; i2 < dArray.length; ++i2) {
            objectArray[i2] = new NaturalRanking$IntDoublePair(dArray[i2], i2);
        }
        List<Integer> list = null;
        switch (this.nanStrategy) {
            case MAXIMAL: {
                this.recodeNaNs((NaturalRanking$IntDoublePair[])objectArray, Double.POSITIVE_INFINITY);
                break;
            }
            case MINIMAL: {
                this.recodeNaNs((NaturalRanking$IntDoublePair[])objectArray, Double.NEGATIVE_INFINITY);
                break;
            }
            case REMOVED: {
                objectArray = this.removeNaNs((NaturalRanking$IntDoublePair[])objectArray);
                break;
            }
            case FIXED: {
                list = this.getNanPositions((NaturalRanking$IntDoublePair[])objectArray);
                break;
            }
            case FAILED: {
                list = this.getNanPositions((NaturalRanking$IntDoublePair[])objectArray);
                if (list.size() <= 0) break;
                throw new NotANumberException();
            }
            default: {
                throw new MathInternalError();
            }
        }
        Arrays.sort(objectArray);
        dArray = new double[objectArray.length];
        int n = 1;
        dArray[((NaturalRanking$IntDoublePair)objectArray[0]).getPosition()] = 1.0;
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        arrayList.add(((NaturalRanking$IntDoublePair)objectArray[0]).getPosition());
        for (int i3 = 1; i3 < objectArray.length; ++i3) {
            if (Double.compare(((NaturalRanking$IntDoublePair)objectArray[i3]).getValue(), ((NaturalRanking$IntDoublePair)objectArray[i3 - 1]).getValue()) > 0) {
                n = i3 + 1;
                if (arrayList.size() > 1) {
                    this.resolveTie(dArray, arrayList);
                }
                arrayList = new ArrayList<Integer>();
                arrayList.add(((NaturalRanking$IntDoublePair)objectArray[i3]).getPosition());
            } else {
                arrayList.add(((NaturalRanking$IntDoublePair)objectArray[i3]).getPosition());
            }
            dArray[((NaturalRanking$IntDoublePair)objectArray[i3]).getPosition()] = n;
        }
        if (arrayList.size() > 1) {
            this.resolveTie(dArray, arrayList);
        }
        if (this.nanStrategy == NaNStrategy.FIXED) {
            this.restoreNaNs(dArray, list);
        }
        return dArray;
    }

    private NaturalRanking$IntDoublePair[] removeNaNs(NaturalRanking$IntDoublePair[] naturalRanking$IntDoublePairArray) {
        if (!this.containsNaNs(naturalRanking$IntDoublePairArray)) {
            return naturalRanking$IntDoublePairArray;
        }
        NaturalRanking$IntDoublePair[] naturalRanking$IntDoublePairArray2 = new NaturalRanking$IntDoublePair[naturalRanking$IntDoublePairArray.length];
        int n = 0;
        for (int i2 = 0; i2 < naturalRanking$IntDoublePairArray.length; ++i2) {
            if (Double.isNaN(naturalRanking$IntDoublePairArray[i2].getValue())) {
                for (int i3 = i2 + 1; i3 < naturalRanking$IntDoublePairArray.length; ++i3) {
                    naturalRanking$IntDoublePairArray[i3] = new NaturalRanking$IntDoublePair(naturalRanking$IntDoublePairArray[i3].getValue(), naturalRanking$IntDoublePairArray[i3].getPosition() - 1);
                }
                continue;
            }
            naturalRanking$IntDoublePairArray2[n] = new NaturalRanking$IntDoublePair(naturalRanking$IntDoublePairArray[i2].getValue(), naturalRanking$IntDoublePairArray[i2].getPosition());
            ++n;
        }
        NaturalRanking$IntDoublePair[] naturalRanking$IntDoublePairArray3 = new NaturalRanking$IntDoublePair[n];
        System.arraycopy(naturalRanking$IntDoublePairArray2, 0, naturalRanking$IntDoublePairArray3, 0, n);
        return naturalRanking$IntDoublePairArray3;
    }

    private void recodeNaNs(NaturalRanking$IntDoublePair[] naturalRanking$IntDoublePairArray, double d2) {
        for (int i2 = 0; i2 < naturalRanking$IntDoublePairArray.length; ++i2) {
            if (!Double.isNaN(naturalRanking$IntDoublePairArray[i2].getValue())) continue;
            naturalRanking$IntDoublePairArray[i2] = new NaturalRanking$IntDoublePair(d2, naturalRanking$IntDoublePairArray[i2].getPosition());
        }
    }

    private boolean containsNaNs(NaturalRanking$IntDoublePair[] naturalRanking$IntDoublePairArray) {
        for (int i2 = 0; i2 < naturalRanking$IntDoublePairArray.length; ++i2) {
            if (!Double.isNaN(naturalRanking$IntDoublePairArray[i2].getValue())) continue;
            return true;
        }
        return false;
    }

    private void resolveTie(double[] dArray, List<Integer> iterator) {
        double d2 = dArray[iterator.get(0)];
        int n = iterator.size();
        switch (this.tiesStrategy) {
            case AVERAGE: {
                this.fill(dArray, (List<Integer>)((Object)iterator), (d2 * 2.0 + (double)n - 1.0) / 2.0);
                return;
            }
            case MAXIMUM: {
                this.fill(dArray, (List<Integer>)((Object)iterator), d2 + (double)n - 1.0);
                return;
            }
            case MINIMUM: {
                this.fill(dArray, (List<Integer>)((Object)iterator), d2);
                return;
            }
            case RANDOM: {
                iterator = iterator.iterator();
                long l = FastMath.round(d2);
                while (iterator.hasNext()) {
                    long l2 = l;
                    dArray[iterator.next().intValue()] = this.randomData.nextLong(l2, l2 + (long)n - 1L);
                }
                break;
            }
            case SEQUENTIAL: {
                iterator = iterator.iterator();
                long l = FastMath.round(d2);
                int n2 = 0;
                while (iterator.hasNext()) {
                    dArray[iterator.next().intValue()] = l + (long)n2++;
                }
                break;
            }
            default: {
                throw new MathInternalError();
            }
        }
    }

    private void fill(double[] dArray, List<Integer> object, double d2) {
        object = object.iterator();
        while (object.hasNext()) {
            dArray[((Integer)object.next()).intValue()] = d2;
        }
    }

    private void restoreNaNs(double[] dArray, List<Integer> object) {
        if (object.size() == 0) {
            return;
        }
        object = object.iterator();
        while (object.hasNext()) {
            dArray[((Integer)object.next()).intValue()] = Double.NaN;
        }
    }

    private List<Integer> getNanPositions(NaturalRanking$IntDoublePair[] naturalRanking$IntDoublePairArray) {
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        for (int i2 = 0; i2 < naturalRanking$IntDoublePairArray.length; ++i2) {
            if (!Double.isNaN(naturalRanking$IntDoublePairArray[i2].getValue())) continue;
            arrayList.add(i2);
        }
        return arrayList;
    }
}

