/*
 * Decompiled with CFR 0.152.
 */
package games.aquastudios.aquaclient.shaded.apache.commons.math3.stat.interval;

import games.aquastudios.aquaclient.shaded.apache.commons.math3.distribution.AbstractRealDistribution;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.distribution.NormalDistribution;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.stat.interval.BinomialConfidenceInterval;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.stat.interval.ConfidenceInterval;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.stat.interval.IntervalUtils;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.util.FastMath;

public class WilsonScoreInterval
implements BinomialConfidenceInterval {
    public ConfidenceInterval createInterval(int n, int n2, double d2) {
        IntervalUtils.checkParameters(n, n2, d2);
        double d3 = (1.0 - d2) / 2.0;
        NormalDistribution normalDistribution = new NormalDistribution();
        double d4 = ((AbstractRealDistribution)normalDistribution).inverseCumulativeProbability(1.0 - d3);
        double d5 = FastMath.pow(d4, 2);
        double d6 = (double)n2 / (double)n;
        double d7 = 1.0 / (1.0 + 1.0 / (double)n * d5);
        double d8 = d6 + 1.0 / (double)(2 * n) * d5;
        double d9 = d4 * FastMath.sqrt(1.0 / (double)n * d6 * (1.0 - d6) + 1.0 / (4.0 * FastMath.pow((double)n, 2)) * d5);
        double d10 = d7 * (d8 - d9);
        double d11 = d7 * (d8 + d9);
        return new ConfidenceInterval(d10, d11, d2);
    }
}

