/*
 * Decompiled with CFR 0.152.
 */
package games.aquastudios.aquaclient.shaded.apache.commons.math3.stat.interval;

import games.aquastudios.aquaclient.shaded.apache.commons.math3.distribution.AbstractRealDistribution;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.distribution.NormalDistribution;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.stat.interval.BinomialConfidenceInterval;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.stat.interval.ConfidenceInterval;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.stat.interval.IntervalUtils;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.util.FastMath;

public class NormalApproximationInterval
implements BinomialConfidenceInterval {
    public ConfidenceInterval createInterval(int n, int n2, double d2) {
        IntervalUtils.checkParameters(n, n2, d2);
        double d3 = (double)n2 / (double)n;
        double d4 = (1.0 - d2) / 2.0;
        NormalDistribution normalDistribution = new NormalDistribution();
        double d5 = ((AbstractRealDistribution)normalDistribution).inverseCumulativeProbability(1.0 - d4) * FastMath.sqrt(1.0 / (double)n * d3 * (1.0 - d3));
        return new ConfidenceInterval(d3 - d5, d3 + d5, d2);
    }
}

