/*
 * Decompiled with CFR 0.152.
 */
package games.aquastudios.aquaclient.shaded.apache.commons.math3.stat.interval;

import games.aquastudios.aquaclient.shaded.apache.commons.math3.exception.NotPositiveException;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.exception.NotStrictlyPositiveException;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.exception.NumberIsTooLargeException;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.exception.OutOfRangeException;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.exception.util.Localizable;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.exception.util.LocalizedFormats;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.stat.interval.AgrestiCoullInterval;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.stat.interval.BinomialConfidenceInterval;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.stat.interval.ClopperPearsonInterval;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.stat.interval.ConfidenceInterval;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.stat.interval.NormalApproximationInterval;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.stat.interval.WilsonScoreInterval;

public final class IntervalUtils {
    private static final BinomialConfidenceInterval AGRESTI_COULL = new AgrestiCoullInterval();
    private static final BinomialConfidenceInterval CLOPPER_PEARSON = new ClopperPearsonInterval();
    private static final BinomialConfidenceInterval NORMAL_APPROXIMATION = new NormalApproximationInterval();
    private static final BinomialConfidenceInterval WILSON_SCORE = new WilsonScoreInterval();

    private IntervalUtils() {
    }

    public static ConfidenceInterval getAgrestiCoullInterval(int n, int n2, double d2) {
        return AGRESTI_COULL.createInterval(n, n2, d2);
    }

    public static ConfidenceInterval getClopperPearsonInterval(int n, int n2, double d2) {
        return CLOPPER_PEARSON.createInterval(n, n2, d2);
    }

    public static ConfidenceInterval getNormalApproximationInterval(int n, int n2, double d2) {
        return NORMAL_APPROXIMATION.createInterval(n, n2, d2);
    }

    public static ConfidenceInterval getWilsonScoreInterval(int n, int n2, double d2) {
        return WILSON_SCORE.createInterval(n, n2, d2);
    }

    static void checkParameters(int n, int n2, double d2) {
        if (n <= 0) {
            throw new NotStrictlyPositiveException((Localizable)LocalizedFormats.NUMBER_OF_TRIALS, n);
        }
        if (n2 < 0) {
            throw new NotPositiveException((Localizable)LocalizedFormats.NEGATIVE_NUMBER_OF_SUCCESSES, n2);
        }
        if (n2 > n) {
            throw new NumberIsTooLargeException((Localizable)LocalizedFormats.NUMBER_OF_SUCCESS_LARGER_THAN_POPULATION_SIZE, (Number)n2, n, true);
        }
        if (d2 <= 0.0 || d2 >= 1.0) {
            throw new OutOfRangeException((Localizable)LocalizedFormats.OUT_OF_BOUNDS_CONFIDENCE_LEVEL, (Number)d2, 0, 1);
        }
    }
}

