/*
 * Decompiled with CFR 0.152.
 */
package games.aquastudios.aquaclient.shaded.apache.commons.math3.stat.interval;

import games.aquastudios.aquaclient.shaded.apache.commons.math3.distribution.FDistribution;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.stat.interval.BinomialConfidenceInterval;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.stat.interval.ConfidenceInterval;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.stat.interval.IntervalUtils;

public class ClopperPearsonInterval
implements BinomialConfidenceInterval {
    public ConfidenceInterval createInterval(int n, int n2, double d2) {
        IntervalUtils.checkParameters(n, n2, d2);
        double d3 = 0.0;
        double d4 = 0.0;
        double d5 = (1.0 - d2) / 2.0;
        FDistribution fDistribution = new FDistribution(2 * (n - n2 + 1), 2 * n2);
        double d6 = fDistribution.inverseCumulativeProbability(1.0 - d5);
        if (n2 > 0) {
            d3 = (double)n2 / ((double)n2 + (double)(n - n2 + 1) * d6);
        }
        fDistribution = new FDistribution(2 * (n2 + 1), 2 * (n - n2));
        double d7 = fDistribution.inverseCumulativeProbability(1.0 - d5);
        if (n2 > 0) {
            d4 = (double)(n2 + 1) * d7 / ((double)(n - n2) + (double)(n2 + 1) * d7);
        }
        return new ConfidenceInterval(d3, d4, d2);
    }
}

