/*
 * Decompiled with CFR 0.152.
 */
package games.aquastudios.aquaclient.shaded.apache.commons.math3.stat.inference;

import games.aquastudios.aquaclient.shaded.apache.commons.math3.distribution.NormalDistribution;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.exception.DimensionMismatchException;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.exception.NoDataException;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.exception.NullArgumentException;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.exception.NumberIsTooLargeException;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.stat.ranking.NaNStrategy;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.stat.ranking.NaturalRanking;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.stat.ranking.TiesStrategy;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.util.FastMath;

public class WilcoxonSignedRankTest {
    private NaturalRanking naturalRanking;

    public WilcoxonSignedRankTest() {
        this.naturalRanking = new NaturalRanking(NaNStrategy.FIXED, TiesStrategy.AVERAGE);
    }

    public WilcoxonSignedRankTest(NaNStrategy naNStrategy, TiesStrategy tiesStrategy) {
        this.naturalRanking = new NaturalRanking(naNStrategy, tiesStrategy);
    }

    private void ensureDataConformance(double[] dArray, double[] dArray2) {
        if (dArray == null || dArray2 == null) {
            throw new NullArgumentException();
        }
        if (dArray.length == 0 || dArray2.length == 0) {
            throw new NoDataException();
        }
        if (dArray2.length != dArray.length) {
            throw new DimensionMismatchException(dArray2.length, dArray.length);
        }
    }

    private double[] calculateDifferences(double[] dArray, double[] dArray2) {
        double[] dArray3 = new double[dArray.length];
        for (int i2 = 0; i2 < dArray.length; ++i2) {
            dArray3[i2] = dArray2[i2] - dArray[i2];
        }
        return dArray3;
    }

    private double[] calculateAbsoluteDifferences(double[] dArray) {
        if (dArray == null) {
            throw new NullArgumentException();
        }
        if (dArray.length == 0) {
            throw new NoDataException();
        }
        double[] dArray2 = new double[dArray.length];
        for (int i2 = 0; i2 < dArray.length; ++i2) {
            dArray2[i2] = FastMath.abs(dArray[i2]);
        }
        return dArray2;
    }

    public double wilcoxonSignedRank(double[] dArray, double[] dArray2) {
        int n;
        this.ensureDataConformance(dArray, dArray2);
        dArray2 = this.calculateDifferences(dArray, dArray2);
        double[] dArray3 = this.calculateAbsoluteDifferences(dArray2);
        dArray3 = this.naturalRanking.rank(dArray3);
        double d2 = 0.0;
        for (n = 0; n < dArray2.length; ++n) {
            if (!(dArray2[n] > 0.0)) continue;
            d2 += dArray3[n];
        }
        n = dArray.length;
        double d3 = (double)(n * (n + 1)) / 2.0 - d2;
        return FastMath.max(d2, d3);
    }

    private double calculateExactPValue(double d2, int n) {
        int n2 = 1 << n;
        int n3 = 0;
        for (int i2 = 0; i2 < n2; ++i2) {
            int n4 = 0;
            for (int i3 = 0; i3 < n; ++i3) {
                if ((i2 >> i3 & 1) != 1) continue;
                n4 += i3 + 1;
            }
            if (!((double)n4 >= d2)) continue;
            ++n3;
        }
        return 2.0 * (double)n3 / (double)n2;
    }

    private double calculateAsymptoticPValue(double d2, int n) {
        int n2 = n;
        double d3 = (double)(n2 * (n2 + 1)) / 4.0;
        double d4 = d3 * ((double)(2 * n + 1) / 6.0);
        double d5 = (d2 - d3 - 0.5) / FastMath.sqrt(d4);
        NormalDistribution normalDistribution = new NormalDistribution(null, 0.0, 1.0);
        return 2.0 * normalDistribution.cumulativeProbability(d5);
    }

    public double wilcoxonSignedRankTest(double[] dArray, double[] dArray2, boolean bl) {
        this.ensureDataConformance(dArray, dArray2);
        int n = dArray.length;
        double d2 = this.wilcoxonSignedRank(dArray, dArray2);
        if (bl && n > 30) {
            throw new NumberIsTooLargeException(n, (Number)30, true);
        }
        if (bl) {
            return this.calculateExactPValue(d2, n);
        }
        int n2 = n;
        double d3 = (double)(n2 * (n2 + 1)) / 2.0 - d2;
        return this.calculateAsymptoticPValue(d3, n);
    }
}

