/*
 * Decompiled with CFR 0.152.
 */
package games.aquastudios.aquaclient.shaded.apache.commons.math3.stat.inference;

import games.aquastudios.aquaclient.shaded.apache.commons.math3.distribution.TDistribution;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.exception.NullArgumentException;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.exception.NumberIsTooSmallException;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.exception.OutOfRangeException;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.exception.util.Localizable;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.exception.util.LocalizedFormats;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.stat.StatUtils;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.stat.descriptive.StatisticalSummary;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.util.FastMath;

public class TTest {
    public double pairedT(double[] dArray, double[] dArray2) {
        this.checkSampleData(dArray);
        this.checkSampleData(dArray2);
        double d2 = StatUtils.meanDifference(dArray, dArray2);
        return this.t(d2, 0.0, StatUtils.varianceDifference(dArray, dArray2, d2), dArray.length);
    }

    public double pairedTTest(double[] dArray, double[] dArray2) {
        double d2 = StatUtils.meanDifference(dArray, dArray2);
        return this.tTest(d2, 0.0, StatUtils.varianceDifference(dArray, dArray2, d2), dArray.length);
    }

    public boolean pairedTTest(double[] dArray, double[] dArray2, double d2) {
        this.checkSignificanceLevel(d2);
        return this.pairedTTest(dArray, dArray2) < d2;
    }

    public double t(double d2, double[] dArray) {
        this.checkSampleData(dArray);
        return this.t(StatUtils.mean(dArray), d2, StatUtils.variance(dArray), dArray.length);
    }

    public double t(double d2, StatisticalSummary statisticalSummary) {
        this.checkSampleData(statisticalSummary);
        return this.t(statisticalSummary.getMean(), d2, statisticalSummary.getVariance(), statisticalSummary.getN());
    }

    public double homoscedasticT(double[] dArray, double[] dArray2) {
        this.checkSampleData(dArray);
        this.checkSampleData(dArray2);
        return this.homoscedasticT(StatUtils.mean(dArray), StatUtils.mean(dArray2), StatUtils.variance(dArray), StatUtils.variance(dArray2), dArray.length, dArray2.length);
    }

    public double t(double[] dArray, double[] dArray2) {
        this.checkSampleData(dArray);
        this.checkSampleData(dArray2);
        return this.t(StatUtils.mean(dArray), StatUtils.mean(dArray2), StatUtils.variance(dArray), StatUtils.variance(dArray2), dArray.length, dArray2.length);
    }

    public double t(StatisticalSummary statisticalSummary, StatisticalSummary statisticalSummary2) {
        this.checkSampleData(statisticalSummary);
        this.checkSampleData(statisticalSummary2);
        return this.t(statisticalSummary.getMean(), statisticalSummary2.getMean(), statisticalSummary.getVariance(), statisticalSummary2.getVariance(), statisticalSummary.getN(), statisticalSummary2.getN());
    }

    public double homoscedasticT(StatisticalSummary statisticalSummary, StatisticalSummary statisticalSummary2) {
        this.checkSampleData(statisticalSummary);
        this.checkSampleData(statisticalSummary2);
        return this.homoscedasticT(statisticalSummary.getMean(), statisticalSummary2.getMean(), statisticalSummary.getVariance(), statisticalSummary2.getVariance(), statisticalSummary.getN(), statisticalSummary2.getN());
    }

    public double tTest(double d2, double[] dArray) {
        this.checkSampleData(dArray);
        return this.tTest(StatUtils.mean(dArray), d2, StatUtils.variance(dArray), dArray.length);
    }

    public boolean tTest(double d2, double[] dArray, double d3) {
        this.checkSignificanceLevel(d3);
        return this.tTest(d2, dArray) < d3;
    }

    public double tTest(double d2, StatisticalSummary statisticalSummary) {
        this.checkSampleData(statisticalSummary);
        return this.tTest(statisticalSummary.getMean(), d2, statisticalSummary.getVariance(), statisticalSummary.getN());
    }

    public boolean tTest(double d2, StatisticalSummary statisticalSummary, double d3) {
        this.checkSignificanceLevel(d3);
        return this.tTest(d2, statisticalSummary) < d3;
    }

    public double tTest(double[] dArray, double[] dArray2) {
        this.checkSampleData(dArray);
        this.checkSampleData(dArray2);
        return this.tTest(StatUtils.mean(dArray), StatUtils.mean(dArray2), StatUtils.variance(dArray), StatUtils.variance(dArray2), dArray.length, dArray2.length);
    }

    public double homoscedasticTTest(double[] dArray, double[] dArray2) {
        this.checkSampleData(dArray);
        this.checkSampleData(dArray2);
        return this.homoscedasticTTest(StatUtils.mean(dArray), StatUtils.mean(dArray2), StatUtils.variance(dArray), StatUtils.variance(dArray2), dArray.length, dArray2.length);
    }

    public boolean tTest(double[] dArray, double[] dArray2, double d2) {
        this.checkSignificanceLevel(d2);
        return this.tTest(dArray, dArray2) < d2;
    }

    public boolean homoscedasticTTest(double[] dArray, double[] dArray2, double d2) {
        this.checkSignificanceLevel(d2);
        return this.homoscedasticTTest(dArray, dArray2) < d2;
    }

    public double tTest(StatisticalSummary statisticalSummary, StatisticalSummary statisticalSummary2) {
        this.checkSampleData(statisticalSummary);
        this.checkSampleData(statisticalSummary2);
        return this.tTest(statisticalSummary.getMean(), statisticalSummary2.getMean(), statisticalSummary.getVariance(), statisticalSummary2.getVariance(), statisticalSummary.getN(), statisticalSummary2.getN());
    }

    public double homoscedasticTTest(StatisticalSummary statisticalSummary, StatisticalSummary statisticalSummary2) {
        this.checkSampleData(statisticalSummary);
        this.checkSampleData(statisticalSummary2);
        return this.homoscedasticTTest(statisticalSummary.getMean(), statisticalSummary2.getMean(), statisticalSummary.getVariance(), statisticalSummary2.getVariance(), statisticalSummary.getN(), statisticalSummary2.getN());
    }

    public boolean tTest(StatisticalSummary statisticalSummary, StatisticalSummary statisticalSummary2, double d2) {
        this.checkSignificanceLevel(d2);
        return this.tTest(statisticalSummary, statisticalSummary2) < d2;
    }

    protected double df(double d2, double d3, double d4, double d5) {
        double d6 = d2;
        double d7 = d4;
        double d8 = d3;
        double d9 = d5;
        return (d2 / d4 + d3 / d5) * (d2 / d4 + d3 / d5) / (d6 * d6 / (d7 * d7 * (d4 - 1.0)) + d8 * d8 / (d9 * d9 * (d5 - 1.0)));
    }

    protected double t(double d2, double d3, double d4, double d5) {
        return (d2 - d3) / FastMath.sqrt(d4 / d5);
    }

    protected double t(double d2, double d3, double d4, double d5, double d6, double d7) {
        return (d2 - d3) / FastMath.sqrt(d4 / d6 + d5 / d7);
    }

    protected double homoscedasticT(double d2, double d3, double d4, double d5, double d6, double d7) {
        double d8 = ((d6 - 1.0) * d4 + (d7 - 1.0) * d5) / (d6 + d7 - 2.0);
        return (d2 - d3) / FastMath.sqrt(d8 * (1.0 / d6 + 1.0 / d7));
    }

    protected double tTest(double d2, double d3, double d4, double d5) {
        double d6 = FastMath.abs(this.t(d2, d3, d4, d5));
        TDistribution tDistribution = new TDistribution(null, d5 - 1.0);
        return 2.0 * tDistribution.cumulativeProbability(-d6);
    }

    protected double tTest(double d2, double d3, double d4, double d5, double d6, double d7) {
        double d8 = FastMath.abs(this.t(d2, d3, d4, d5, d6, d7));
        double d9 = this.df(d4, d5, d6, d7);
        TDistribution tDistribution = new TDistribution(null, d9);
        return 2.0 * tDistribution.cumulativeProbability(-d8);
    }

    protected double homoscedasticTTest(double d2, double d3, double d4, double d5, double d6, double d7) {
        double d8 = FastMath.abs(this.homoscedasticT(d2, d3, d4, d5, d6, d7));
        double d9 = d6 + d7 - 2.0;
        TDistribution tDistribution = new TDistribution(null, d9);
        return 2.0 * tDistribution.cumulativeProbability(-d8);
    }

    private void checkSignificanceLevel(double d2) {
        if (d2 <= 0.0 || d2 > 0.5) {
            throw new OutOfRangeException((Localizable)LocalizedFormats.SIGNIFICANCE_LEVEL, (Number)d2, 0.0, 0.5);
        }
    }

    private void checkSampleData(double[] dArray) {
        if (dArray == null) {
            throw new NullArgumentException();
        }
        if (dArray.length < 2) {
            throw new NumberIsTooSmallException((Localizable)LocalizedFormats.INSUFFICIENT_DATA_FOR_T_STATISTIC, (Number)dArray.length, 2, true);
        }
    }

    private void checkSampleData(StatisticalSummary statisticalSummary) {
        if (statisticalSummary == null) {
            throw new NullArgumentException();
        }
        if (statisticalSummary.getN() < 2L) {
            throw new NumberIsTooSmallException((Localizable)LocalizedFormats.INSUFFICIENT_DATA_FOR_T_STATISTIC, (Number)statisticalSummary.getN(), 2, true);
        }
    }
}

