/*
 * Decompiled with CFR 0.152.
 */
package games.aquastudios.aquaclient.shaded.apache.commons.math3.stat.inference;

import games.aquastudios.aquaclient.shaded.apache.commons.math3.distribution.FDistribution;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.exception.DimensionMismatchException;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.exception.OutOfRangeException;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.exception.util.Localizable;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.exception.util.LocalizedFormats;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.stat.descriptive.SummaryStatistics;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.stat.inference.OneWayAnova$AnovaStats;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.util.MathUtils;
import java.util.ArrayList;
import java.util.Collection;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OneWayAnova {
    public double anovaFValue(Collection<double[]> object) {
        object = this.anovaStats((Collection<double[]>)object);
        return OneWayAnova$AnovaStats.access$000((OneWayAnova$AnovaStats)object);
    }

    public double anovaPValue(Collection<double[]> object) {
        object = this.anovaStats((Collection<double[]>)object);
        FDistribution fDistribution = new FDistribution(null, (double)OneWayAnova$AnovaStats.access$100((OneWayAnova$AnovaStats)object), (double)OneWayAnova$AnovaStats.access$200((OneWayAnova$AnovaStats)object));
        return 1.0 - fDistribution.cumulativeProbability(OneWayAnova$AnovaStats.access$000((OneWayAnova$AnovaStats)object));
    }

    public double anovaPValue(Collection<SummaryStatistics> object, boolean bl) {
        object = this.anovaStats((Collection<SummaryStatistics>)object, bl);
        FDistribution fDistribution = new FDistribution(null, (double)OneWayAnova$AnovaStats.access$100((OneWayAnova$AnovaStats)object), (double)OneWayAnova$AnovaStats.access$200((OneWayAnova$AnovaStats)object));
        return 1.0 - fDistribution.cumulativeProbability(OneWayAnova$AnovaStats.access$000((OneWayAnova$AnovaStats)object));
    }

    private OneWayAnova$AnovaStats anovaStats(Collection<double[]> object) {
        MathUtils.checkNotNull(object);
        ArrayList<SummaryStatistics> arrayList = new ArrayList<SummaryStatistics>(object.size());
        object = object.iterator();
        while (object.hasNext()) {
            double[] dArray = (double[])object.next();
            SummaryStatistics summaryStatistics = new SummaryStatistics();
            arrayList.add(summaryStatistics);
            for (double d2 : dArray) {
                summaryStatistics.addValue(d2);
            }
        }
        return this.anovaStats(arrayList, false);
    }

    public boolean anovaTest(Collection<double[]> collection, double d2) {
        if (d2 <= 0.0 || d2 > 0.5) {
            throw new OutOfRangeException((Localizable)LocalizedFormats.OUT_OF_BOUND_SIGNIFICANCE_LEVEL, (Number)d2, 0, 0.5);
        }
        return this.anovaPValue(collection) < d2;
    }

    private OneWayAnova$AnovaStats anovaStats(Collection<SummaryStatistics> collection, boolean bl) {
        double d2;
        double d3;
        MathUtils.checkNotNull(collection);
        if (!bl) {
            if (collection.size() < 2) {
                throw new DimensionMismatchException((Localizable)LocalizedFormats.TWO_OR_MORE_CATEGORIES_REQUIRED, collection.size(), 2);
            }
            for (SummaryStatistics summaryStatistics : collection) {
                if (summaryStatistics.getN() > 1L) continue;
                throw new DimensionMismatchException((Localizable)LocalizedFormats.TWO_OR_MORE_VALUES_IN_CATEGORY_REQUIRED, (int)summaryStatistics.getN(), 2);
            }
        }
        bl = false;
        double d4 = 0.0;
        double d5 = 0.0;
        double d6 = 0.0;
        int n = 0;
        for (SummaryStatistics summaryStatistics : collection) {
            d3 = summaryStatistics.getSum();
            double d7 = summaryStatistics.getSumsq();
            int n2 = (int)summaryStatistics.getN();
            n += n2;
            d5 += d3;
            d6 += d7;
            bl += n2 - 1;
            double d8 = d3;
            d2 = d7 - d8 * d8 / (double)n2;
            d4 += d2;
        }
        double d9 = d5;
        double d10 = d6 - d9 * d9 / (double)n;
        d3 = d10 - d4;
        int n3 = collection.size() - 1;
        double d11 = d3 / (double)n3;
        d2 = d4 / (double)bl;
        double d12 = d11 / d2;
        return new OneWayAnova$AnovaStats(n3, bl ? 1 : 0, d12, null);
    }
}

