/*
 * Decompiled with CFR 0.152.
 */
package games.aquastudios.aquaclient.shaded.apache.commons.math3.stat.inference;

import games.aquastudios.aquaclient.shaded.apache.commons.math3.distribution.NormalDistribution;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.exception.NoDataException;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.exception.NullArgumentException;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.stat.ranking.NaNStrategy;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.stat.ranking.NaturalRanking;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.stat.ranking.TiesStrategy;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.util.FastMath;

public class MannWhitneyUTest {
    private NaturalRanking naturalRanking;

    public MannWhitneyUTest() {
        this.naturalRanking = new NaturalRanking(NaNStrategy.FIXED, TiesStrategy.AVERAGE);
    }

    public MannWhitneyUTest(NaNStrategy naNStrategy, TiesStrategy tiesStrategy) {
        this.naturalRanking = new NaturalRanking(naNStrategy, tiesStrategy);
    }

    private void ensureDataConformance(double[] dArray, double[] dArray2) {
        if (dArray == null || dArray2 == null) {
            throw new NullArgumentException();
        }
        if (dArray.length == 0 || dArray2.length == 0) {
            throw new NoDataException();
        }
    }

    private double[] concatenateSamples(double[] dArray, double[] dArray2) {
        double[] dArray3 = new double[dArray.length + dArray2.length];
        System.arraycopy(dArray, 0, dArray3, 0, dArray.length);
        System.arraycopy(dArray2, 0, dArray3, dArray.length, dArray2.length);
        return dArray3;
    }

    public double mannWhitneyU(double[] dArray, double[] dArray2) {
        this.ensureDataConformance(dArray, dArray2);
        double[] dArray3 = this.concatenateSamples(dArray, dArray2);
        dArray3 = this.naturalRanking.rank(dArray3);
        double d2 = 0.0;
        for (int i2 = 0; i2 < dArray.length; ++i2) {
            d2 += dArray3[i2];
        }
        double d3 = d2 - (double)((long)dArray.length * (long)(dArray.length + 1) / 2L);
        double d4 = (double)((long)dArray.length * (long)dArray2.length) - d3;
        return FastMath.max(d3, d4);
    }

    private double calculateAsymptoticPValue(double d2, int n, int n2) {
        long l = (long)n * (long)n2;
        double d3 = (double)l / 2.0;
        double d4 = (double)(l * (long)(n + n2 + 1)) / 12.0;
        double d5 = (d2 - d3) / FastMath.sqrt(d4);
        NormalDistribution normalDistribution = new NormalDistribution(null, 0.0, 1.0);
        return 2.0 * normalDistribution.cumulativeProbability(d5);
    }

    public double mannWhitneyUTest(double[] dArray, double[] dArray2) {
        this.ensureDataConformance(dArray, dArray2);
        double d2 = this.mannWhitneyU(dArray, dArray2);
        double d3 = (double)((long)dArray.length * (long)dArray2.length) - d2;
        return this.calculateAsymptoticPValue(d3, dArray.length, dArray2.length);
    }
}

