/*
 * Decompiled with CFR 0.152.
 */
package games.aquastudios.aquaclient.shaded.apache.commons.math3.stat.inference;

import games.aquastudios.aquaclient.shaded.apache.commons.math3.Field;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.FieldElement;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.distribution.AbstractRealDistribution;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.distribution.EnumeratedRealDistribution;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.distribution.RealDistribution;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.distribution.UniformRealDistribution;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.exception.InsufficientDataException;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.exception.MathInternalError;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.exception.NullArgumentException;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.exception.NumberIsTooLargeException;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.exception.OutOfRangeException;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.exception.TooManyIterationsException;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.exception.util.Localizable;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.exception.util.LocalizedFormats;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.fraction.BigFraction;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.fraction.BigFractionField;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.fraction.FractionConversionException;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.linear.Array2DRowFieldMatrix;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.linear.FieldMatrix;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.linear.MatrixUtils;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.linear.RealMatrix;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.random.JDKRandomGenerator;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.random.RandomGenerator;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.random.Well19937c;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.util.CombinatoricsUtils;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.util.FastMath;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.util.MathArrays;
import java.util.Arrays;
import java.util.HashSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class KolmogorovSmirnovTest {
    protected static final int MAXIMUM_PARTIAL_SUM_COUNT = 100000;
    protected static final double KS_SUM_CAUCHY_CRITERION = 1.0E-20;
    protected static final double PG_SUM_RELATIVE_ERROR = 1.0E-10;
    @Deprecated
    protected static final int SMALL_SAMPLE_PRODUCT = 200;
    protected static final int LARGE_SAMPLE_PRODUCT = 10000;
    @Deprecated
    protected static final int MONTE_CARLO_ITERATIONS = 1000000;
    private final RandomGenerator rng;

    public KolmogorovSmirnovTest() {
        this.rng = new Well19937c();
    }

    @Deprecated
    public KolmogorovSmirnovTest(RandomGenerator randomGenerator) {
        this.rng = randomGenerator;
    }

    public double kolmogorovSmirnovTest(RealDistribution realDistribution, double[] dArray, boolean bl) {
        KolmogorovSmirnovTest kolmogorovSmirnovTest = this;
        return 1.0 - kolmogorovSmirnovTest.cdf(kolmogorovSmirnovTest.kolmogorovSmirnovStatistic(realDistribution, dArray), dArray.length, bl);
    }

    public double kolmogorovSmirnovStatistic(RealDistribution realDistribution, double[] dArray) {
        this.checkArray(dArray);
        int n = dArray.length;
        double d2 = n;
        double[] dArray2 = new double[n];
        System.arraycopy(dArray, 0, dArray2, 0, n);
        Arrays.sort(dArray2);
        double d3 = 0.0;
        for (int i2 = 1; i2 <= n; ++i2) {
            double d4;
            double d5 = realDistribution.cumulativeProbability(dArray2[i2 - 1]);
            double d6 = FastMath.max(d5 - (double)(i2 - 1) / d2, (double)i2 / d2 - d5);
            if (!(d4 > d3)) continue;
            d3 = d6;
        }
        return d3;
    }

    public double kolmogorovSmirnovTest(double[] dArray, double[] dArray2, boolean bl) {
        double[] dArray3;
        double[] dArray4;
        long l = (long)dArray.length * (long)dArray2.length;
        if (l < 10000L && KolmogorovSmirnovTest.hasTies(dArray, dArray2)) {
            dArray4 = MathArrays.copyOf(dArray);
            dArray3 = MathArrays.copyOf(dArray2);
            KolmogorovSmirnovTest.fixTies(dArray4, dArray3);
        } else {
            dArray4 = dArray;
            dArray3 = dArray2;
        }
        if (l < 10000L) {
            KolmogorovSmirnovTest kolmogorovSmirnovTest = this;
            return kolmogorovSmirnovTest.exactP(kolmogorovSmirnovTest.kolmogorovSmirnovStatistic(dArray4, dArray3), dArray.length, dArray2.length, bl);
        }
        KolmogorovSmirnovTest kolmogorovSmirnovTest = this;
        return kolmogorovSmirnovTest.approximateP(kolmogorovSmirnovTest.kolmogorovSmirnovStatistic(dArray, dArray2), dArray.length, dArray2.length);
    }

    public double kolmogorovSmirnovTest(double[] dArray, double[] dArray2) {
        return this.kolmogorovSmirnovTest(dArray, dArray2, true);
    }

    public double kolmogorovSmirnovStatistic(double[] dArray, double[] dArray2) {
        return (double)this.integralKolmogorovSmirnovStatistic(dArray, dArray2) / (double)((long)dArray.length * (long)dArray2.length);
    }

    private long integralKolmogorovSmirnovStatistic(double[] dArray, double[] dArray2) {
        this.checkArray(dArray);
        this.checkArray(dArray2);
        dArray = MathArrays.copyOf(dArray);
        dArray2 = MathArrays.copyOf(dArray2);
        Arrays.sort(dArray);
        Arrays.sort(dArray2);
        int n = dArray.length;
        int n2 = dArray2.length;
        int n3 = 0;
        int n4 = 0;
        long l = 0L;
        long l2 = 0L;
        do {
            double d2;
            double d3 = d2 = Double.compare(dArray[n3], dArray2[n4]) <= 0 ? dArray[n3] : dArray2[n4];
            while (n3 < n && Double.compare(dArray[n3], d2) == 0) {
                ++n3;
                l += (long)n2;
            }
            while (n4 < n2 && Double.compare(dArray2[n4], d2) == 0) {
                ++n4;
                l -= (long)n;
            }
            if (l > l2) {
                l2 = l;
                continue;
            }
            if (-l <= l2) continue;
            l2 = -l;
        } while (n3 < n && n4 < n2);
        return l2;
    }

    public double kolmogorovSmirnovTest(RealDistribution realDistribution, double[] dArray) {
        return this.kolmogorovSmirnovTest(realDistribution, dArray, false);
    }

    public boolean kolmogorovSmirnovTest(RealDistribution realDistribution, double[] dArray, double d2) {
        if (d2 <= 0.0 || d2 > 0.5) {
            throw new OutOfRangeException((Localizable)LocalizedFormats.OUT_OF_BOUND_SIGNIFICANCE_LEVEL, (Number)d2, 0, 0.5);
        }
        return this.kolmogorovSmirnovTest(realDistribution, dArray) < d2;
    }

    public double bootstrap(double[] dArray, double[] dArray2, int n, boolean bl) {
        int n2 = dArray.length;
        int n3 = dArray2.length;
        Object object = new double[n2 + n3];
        System.arraycopy(dArray, 0, object, 0, n2);
        System.arraycopy(dArray2, 0, object, n2, n3);
        object = new EnumeratedRealDistribution(this.rng, (double[])object);
        long l = this.integralKolmogorovSmirnovStatistic(dArray, dArray2);
        int n4 = 0;
        int n5 = 0;
        for (int i2 = 0; i2 < n; ++i2) {
            double[] dArray3;
            double[] dArray4 = ((AbstractRealDistribution)object).sample(n2);
            long l2 = this.integralKolmogorovSmirnovStatistic(dArray4, dArray3 = ((AbstractRealDistribution)object).sample(n3));
            if (l2 > l) {
                ++n4;
                continue;
            }
            if (l2 != l) continue;
            ++n5;
        }
        if (bl) {
            return (double)n4 / (double)n;
        }
        return (double)(n4 + n5) / (double)n;
    }

    public double bootstrap(double[] dArray, double[] dArray2, int n) {
        return this.bootstrap(dArray, dArray2, n, true);
    }

    public double cdf(double d2, int n) {
        return this.cdf(d2, n, false);
    }

    public double cdfExact(double d2, int n) {
        return this.cdf(d2, n, true);
    }

    public double cdf(double d2, int n, boolean bl) {
        double d3 = 1.0 / (double)n;
        double d4 = d3 * 0.5;
        if (d2 <= d4) {
            return 0.0;
        }
        if (d4 < d2 && d2 <= d3) {
            double d5 = 1.0;
            double d6 = d2 * 2.0 - d3;
            for (int i2 = 1; i2 <= n; ++i2) {
                d5 *= (double)i2 * d6;
            }
            return d5;
        }
        if (1.0 - d3 <= d2 && d2 < 1.0) {
            return 1.0 - 2.0 * Math.pow(1.0 - d2, n);
        }
        if (1.0 <= d2) {
            return 1.0;
        }
        if (bl) {
            return this.exactK(d2, n);
        }
        if (n <= 140) {
            return this.roundedK(d2, n);
        }
        return this.pelzGood(d2, n);
    }

    private double exactK(double d2, int n) {
        int n2 = (int)Math.ceil((double)n * d2);
        Object object = this.createExactH(d2, n);
        object = object.power(n);
        object = object.getEntry(n2 - 1, n2 - 1);
        for (int i2 = 1; i2 <= n; ++i2) {
            object = ((BigFraction)object).multiply(i2).divide(n);
        }
        return ((BigFraction)object).bigDecimalValue(20, 4).doubleValue();
    }

    private double roundedK(double d2, int n) {
        int n2 = (int)Math.ceil((double)n * d2);
        RealMatrix realMatrix = this.createRoundedH(d2, n);
        realMatrix = realMatrix.power(n);
        double d3 = realMatrix.getEntry(n2 - 1, n2 - 1);
        for (int i2 = 1; i2 <= n; ++i2) {
            d3 *= (double)i2 / (double)n;
        }
        return d3;
    }

    public double pelzGood(double d2, int n) {
        double d3;
        double d4;
        double d5;
        double d6;
        double d7;
        int n2;
        double d8 = FastMath.sqrt(n);
        double d9 = d2 * d8;
        double d10 = d2;
        double d11 = d10 * d10 * (double)n;
        double d12 = d11 * d11;
        double d13 = d12 * d11;
        double d14 = d12;
        double d15 = d14 * d14;
        double d16 = 0.0;
        double d17 = Math.PI * Math.PI / (d11 * 8.0);
        for (n2 = 1; n2 < 100000 && !((d7 = FastMath.exp(-d17 * (d6 = (double)(2 * n2 - 1)) * d6)) <= (d16 += d7) * 1.0E-10); ++n2) {
        }
        if (n2 == 100000) {
            throw new TooManyIterationsException(100000);
        }
        double d18 = d16 * FastMath.sqrt(Math.PI * 2) / d9;
        double d19 = d11 * 2.0;
        d16 = 0.0;
        for (n2 = 0; n2 < 100000 && !(FastMath.abs(d7 = ((d5 = (d6 = (double)n2 + 0.5) * d6) * (Math.PI * Math.PI) - d11) * FastMath.exp(d5 * -9.869604401089358 / d19)) < 1.0E-10 * FastMath.abs(d16 += d7)); ++n2) {
        }
        if (n2 == 100000) {
            throw new TooManyIterationsException(100000);
        }
        double d20 = FastMath.sqrt(1.5707963267948966);
        d18 += d16 * d20 / (d12 * 3.0 * d8);
        double d21 = d12 * 2.0;
        double d22 = d13 * 6.0;
        d17 = d11 * 5.0;
        d16 = 0.0;
        for (n2 = 0; n2 < 100000 && !(FastMath.abs(d7 = (d22 + d21 + Math.PI * Math.PI * (d21 - d17) * (d5 = (d6 = (double)n2 + 0.5) * d6) + 97.40909103400243 * (1.0 - d19) * d5 * d5) * FastMath.exp(d5 * -9.869604401089358 / d19)) < 1.0E-10 * FastMath.abs(d16 += d7)); ++n2) {
        }
        if (n2 == 100000) {
            throw new TooManyIterationsException(100000);
        }
        double d23 = 0.0;
        n2 = 1;
        while (n2 < 100000) {
            int n3 = n2++;
            d5 = n3 * n3;
            d7 = d5 * (Math.PI * Math.PI) * FastMath.exp(d5 * -9.869604401089358 / d19);
            if (!(FastMath.abs(d7) < 1.0E-10 * FastMath.abs(d23 += d7))) continue;
        }
        if (n2 == 100000) {
            throw new TooManyIterationsException(100000);
        }
        d18 += d20 / (double)n * (d16 / (d11 * 36.0 * d11 * d11 * d9) - d23 / (d11 * 18.0 * d9));
        d16 = 0.0;
        for (n2 = 0; n2 < 100000 && !(FastMath.abs(d7 = ((d4 = (d3 = (d5 = (d6 = (double)n2 + 0.5) * d6) * d5) * d5) * 961.3891935753043 * (5.0 - d11 * 30.0) + d3 * 97.40909103400243 * (d11 * -60.0 + d12 * 212.0) + d5 * (Math.PI * Math.PI) * (d12 * 135.0 - d13 * 96.0) - d13 * 30.0 - d15 * 90.0) * FastMath.exp(d5 * -9.869604401089358 / d19)) < 1.0E-10 * FastMath.abs(d16 += d7)); ++n2) {
        }
        if (n2 == 100000) {
            throw new TooManyIterationsException(100000);
        }
        d23 = 0.0;
        n2 = 1;
        while (n2 < 100000) {
            int n4 = n2++;
            d5 = n4 * n4;
            d3 = d5 * d5;
            d7 = (d3 * -97.40909103400243 + d5 * 29.608813203268074 * d11) * FastMath.exp(d5 * -9.869604401089358 / d19);
            if (!(FastMath.abs(d7) < 1.0E-10 * FastMath.abs(d23 += d7))) continue;
        }
        if (n2 == 100000) {
            throw new TooManyIterationsException(100000);
        }
        return d18 + d20 / (d8 * (double)n) * (d16 / (d13 * 3240.0 * d12) + d23 / (d13 * 108.0));
    }

    private FieldMatrix<BigFraction> createExactH(double d2, int n) {
        BigFraction bigFraction;
        double d3;
        int n2 = (int)Math.ceil((double)n * d2);
        int n3 = 2 * n2 - 1;
        double d4 = (double)n2 - (double)n * d2;
        if (d3 >= 1.0) {
            throw new NumberIsTooLargeException(d4, (Number)1.0, false);
        }
        try {
            bigFraction = new BigFraction(d4, 1.0E-20, 10000);
        }
        catch (FractionConversionException fractionConversionException) {
            try {
                bigFraction = new BigFraction(d4, 1.0E-10, 10000);
            }
            catch (FractionConversionException fractionConversionException2) {
                bigFraction = new BigFraction(d4, 1.0E-5, 10000);
            }
        }
        int n4 = n3;
        FieldElement[][] fieldElementArray = new BigFraction[n4][n4];
        for (n = 0; n < n3; ++n) {
            for (n2 = 0; n2 < n3; ++n2) {
                fieldElementArray[n][n2] = n - n2 + 1 < 0 ? BigFraction.ZERO : BigFraction.ONE;
            }
        }
        BigFraction[] bigFractionArray = new BigFraction[n3];
        BigFraction[] bigFractionArray2 = bigFractionArray;
        bigFractionArray[0] = bigFraction;
        for (n2 = 1; n2 < n3; ++n2) {
            bigFractionArray2[n2] = bigFraction.multiply(bigFractionArray2[n2 - 1]);
        }
        for (n2 = 0; n2 < n3; ++n2) {
            fieldElementArray[n2][0] = fieldElementArray[n2][0].subtract(bigFractionArray2[n2]);
            fieldElementArray[n3 - 1][n2] = ((BigFraction)fieldElementArray[n3 - 1][n2]).subtract(bigFractionArray2[n3 - n2 - 1]);
        }
        if (bigFraction.compareTo(BigFraction.ONE_HALF) == 1) {
            fieldElementArray[n3 - 1][0] = ((BigFraction)fieldElementArray[n3 - 1][0]).add(bigFraction.multiply(2).subtract(1).pow(n3));
        }
        for (n2 = 0; n2 < n3; ++n2) {
            for (int i2 = 0; i2 < n2 + 1; ++i2) {
                if (n2 - i2 + 1 <= 0) continue;
                for (int i3 = 2; i3 <= n2 - i2 + 1; ++i3) {
                    fieldElementArray[n2][i2] = ((BigFraction)fieldElementArray[n2][i2]).divide(i3);
                }
            }
        }
        return new Array2DRowFieldMatrix((Field)BigFractionField.getInstance(), fieldElementArray);
    }

    private RealMatrix createRoundedH(double d2, int n) {
        double d3;
        int n2 = (int)Math.ceil((double)n * d2);
        int n3 = 2 * n2 - 1;
        double d4 = (double)n2 - (double)n * d2;
        if (d3 >= 1.0) {
            throw new NumberIsTooLargeException(d4, (Number)1.0, false);
        }
        int n4 = n3;
        double[][] dArray = new double[n4][n4];
        for (int i2 = 0; i2 < n3; ++i2) {
            for (n = 0; n < n3; ++n) {
                dArray[i2][n] = i2 - n + 1 < 0 ? 0.0 : 1.0;
            }
        }
        double[] dArray2 = new double[n3];
        double[] dArray3 = dArray2;
        dArray2[0] = d4;
        for (n = 1; n < n3; ++n) {
            dArray3[n] = d4 * dArray3[n - 1];
        }
        for (n = 0; n < n3; ++n) {
            dArray[n][0] = dArray[n][0] - dArray3[n];
            double[] dArray4 = dArray[n3 - 1];
            int n5 = n;
            dArray4[n5] = dArray4[n5] - dArray3[n3 - n - 1];
        }
        if (Double.compare(d4, 0.5) > 0) {
            double[] dArray5 = dArray[n3 - 1];
            dArray5[0] = dArray5[0] + FastMath.pow(d4 * 2.0 - 1.0, n3);
        }
        for (n = 0; n < n3; ++n) {
            for (int i3 = 0; i3 < n + 1; ++i3) {
                if (n - i3 + 1 <= 0) continue;
                for (n2 = 2; n2 <= n - i3 + 1; ++n2) {
                    double[] dArray6 = dArray[n];
                    int n6 = i3;
                    dArray6[n6] = dArray6[n6] / (double)n2;
                }
            }
        }
        return MatrixUtils.createRealMatrix(dArray);
    }

    private void checkArray(double[] dArray) {
        if (dArray == null) {
            throw new NullArgumentException(LocalizedFormats.NULL_NOT_ALLOWED, new Object[0]);
        }
        if (dArray.length < 2) {
            throw new InsufficientDataException(LocalizedFormats.INSUFFICIENT_OBSERVED_POINTS_IN_SAMPLE, dArray.length, 2);
        }
    }

    public double ksSum(double d2, double d3, int n) {
        long l;
        if (d2 == 0.0) {
            return 0.0;
        }
        double d4 = d2 * -2.0 * d2;
        int n2 = -1;
        double d5 = 0.5;
        double d6 = 1.0;
        for (l = 1L; d6 > d3 && l < (long)n; ++l) {
            d6 = FastMath.exp(d4 * (double)l * (double)l);
            d5 += (double)n2 * d6;
            n2 = -n2;
        }
        if (l == (long)n) {
            throw new TooManyIterationsException(n);
        }
        return d5 * 2.0;
    }

    private static long calculateIntegralD(double d2, int n, int n2, boolean bl) {
        long l = (long)n * (long)n2;
        long l2 = (long)FastMath.ceil((d2 - 1.0E-12) * (double)l);
        long l3 = (long)FastMath.floor((d2 + 1.0E-12) * (double)l);
        if (bl && l3 == l2) {
            return l2 + 1L;
        }
        return l2;
    }

    public double exactP(double d2, int n, int n2, boolean bl) {
        return 1.0 - KolmogorovSmirnovTest.n(n2, n, n2, n, KolmogorovSmirnovTest.calculateIntegralD(d2, n2, n, bl), bl) / CombinatoricsUtils.binomialCoefficientDouble(n + n2, n2);
    }

    public double approximateP(double d2, int n, int n2) {
        double d3 = n2;
        double d4 = n;
        return 1.0 - this.ksSum(d2 * FastMath.sqrt(d3 * d4 / (d3 + d4)), 1.0E-20, 100000);
    }

    static void fillBooleanArrayRandomlyWithFixedNumberTrueValues(boolean[] blArray, int n, RandomGenerator randomGenerator) {
        Arrays.fill(blArray, true);
        while (n < blArray.length) {
            blArray[blArray[var3_3 = randomGenerator.nextInt((int)(n + 1))] ? var3_3 : n] = false;
            ++n;
        }
    }

    public double monteCarloP(double d2, int n, int n2, boolean bl, int n3) {
        return this.integralMonteCarloP(KolmogorovSmirnovTest.calculateIntegralD(d2, n, n2, bl), n, n2, n3);
    }

    private double integralMonteCarloP(long l, int n, int n2, int n3) {
        int n4 = FastMath.max(n, n2);
        n = FastMath.min(n, n2);
        n2 = n4 + n;
        int n5 = 0;
        boolean[] blArray = new boolean[n2];
        block0: for (int i2 = 0; i2 < n3; ++i2) {
            KolmogorovSmirnovTest.fillBooleanArrayRandomlyWithFixedNumberTrueValues(blArray, n4, this.rng);
            long l2 = 0L;
            for (int i3 = 0; i3 < blArray.length; ++i3) {
                if (blArray[i3]) {
                    if ((l2 += (long)n) < l) continue;
                    ++n5;
                    continue block0;
                }
                if ((l2 -= (long)n4) > -l) continue;
                ++n5;
                continue block0;
            }
        }
        return (double)n5 / (double)n3;
    }

    private static void fixTies(double[] dArray, double[] dArray2) {
        boolean bl;
        double[] dArray3 = MathArrays.unique(MathArrays.concatenate(dArray, dArray2));
        if (dArray3.length == dArray.length + dArray2.length) {
            return;
        }
        double d2 = 1.0;
        double d3 = dArray3[0];
        for (int i2 = 1; i2 < dArray3.length; ++i2) {
            double d4;
            double d5 = d3 - dArray3[i2];
            if (d4 < d2) {
                d2 = d5;
            }
            d3 = dArray3[i2];
        }
        UniformRealDistribution uniformRealDistribution = new UniformRealDistribution(new JDKRandomGenerator(100), -(d2 /= 2.0), d2);
        int n = 0;
        do {
            KolmogorovSmirnovTest.jitter(dArray, uniformRealDistribution);
            KolmogorovSmirnovTest.jitter(dArray2, uniformRealDistribution);
        } while ((bl = KolmogorovSmirnovTest.hasTies(dArray, dArray2)) && ++n < 1000);
        if (bl) {
            throw new MathInternalError();
        }
    }

    private static boolean hasTies(double[] dArray, double[] dArray2) {
        int n;
        HashSet<Double> hashSet = new HashSet<Double>();
        for (n = 0; n < dArray.length; ++n) {
            if (hashSet.add(dArray[n])) continue;
            return true;
        }
        for (n = 0; n < dArray2.length; ++n) {
            if (hashSet.add(dArray2[n])) continue;
            return true;
        }
        return false;
    }

    private static void jitter(double[] dArray, RealDistribution realDistribution) {
        int n = 0;
        while (n < dArray.length) {
            int n2 = n++;
            dArray[n2] = dArray[n2] + realDistribution.sample();
        }
    }

    private static int c(int n, int n2, int n3, int n4, long l, boolean bl) {
        if (bl) {
            if (FastMath.abs((long)n * (long)n4 - (long)n2 * (long)n3) <= l) {
                return 1;
            }
            return 0;
        }
        if (FastMath.abs((long)n * (long)n4 - (long)n2 * (long)n3) < l) {
            return 1;
        }
        return 0;
    }

    private static double n(int n, int n2, int n3, int n4, long l, boolean bl) {
        int n5;
        double[] dArray = new double[n4];
        double d2 = 0.0;
        for (n5 = 0; n5 < n4; ++n5) {
            dArray[n5] = KolmogorovSmirnovTest.c(0, n5 + 1, n3, n4, l, bl);
        }
        for (n5 = 1; n5 <= n; ++n5) {
            d2 = KolmogorovSmirnovTest.c(n5, 0, n3, n4, l, bl);
            for (int i2 = 1; i2 <= n2; ++i2) {
                dArray[i2 - 1] = (double)KolmogorovSmirnovTest.c(n5, i2, n3, n4, l, bl) * (d2 + dArray[i2 - 1]);
                d2 = dArray[i2 - 1];
            }
        }
        return d2;
    }
}

