/*
 * Decompiled with CFR 0.152.
 */
package games.aquastudios.aquaclient.shaded.apache.commons.math3.stat.inference;

import games.aquastudios.aquaclient.shaded.apache.commons.math3.distribution.ChiSquaredDistribution;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.exception.DimensionMismatchException;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.exception.OutOfRangeException;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.exception.ZeroException;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.exception.util.Localizable;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.exception.util.LocalizedFormats;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.util.FastMath;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.util.MathArrays;

public class GTest {
    public double g(double[] dArray, long[] lArray) {
        if (dArray.length < 2) {
            throw new DimensionMismatchException(dArray.length, 2);
        }
        if (dArray.length != lArray.length) {
            throw new DimensionMismatchException(dArray.length, lArray.length);
        }
        MathArrays.checkPositive(dArray);
        MathArrays.checkNonNegative(lArray);
        double d2 = 0.0;
        double d3 = 0.0;
        for (int i2 = 0; i2 < lArray.length; ++i2) {
            d2 += dArray[i2];
            d3 += (double)lArray[i2];
        }
        double d4 = 1.0;
        boolean bl = false;
        if (FastMath.abs(d2 - d3) > 1.0E-5) {
            d4 = d3 / d2;
            bl = true;
        }
        double d5 = 0.0;
        for (int i3 = 0; i3 < lArray.length; ++i3) {
            double d6 = bl ? FastMath.log((double)lArray[i3] / (d4 * dArray[i3])) : FastMath.log((double)lArray[i3] / dArray[i3]);
            d5 += (double)lArray[i3] * d6;
        }
        return d5 * 2.0;
    }

    public double gTest(double[] dArray, long[] lArray) {
        ChiSquaredDistribution chiSquaredDistribution = new ChiSquaredDistribution(null, (double)dArray.length - 1.0);
        return 1.0 - chiSquaredDistribution.cumulativeProbability(this.g(dArray, lArray));
    }

    public double gTestIntrinsic(double[] dArray, long[] lArray) {
        ChiSquaredDistribution chiSquaredDistribution = new ChiSquaredDistribution(null, (double)dArray.length - 2.0);
        return 1.0 - chiSquaredDistribution.cumulativeProbability(this.g(dArray, lArray));
    }

    public boolean gTest(double[] dArray, long[] lArray, double d2) {
        if (d2 <= 0.0 || d2 > 0.5) {
            throw new OutOfRangeException((Localizable)LocalizedFormats.OUT_OF_BOUND_SIGNIFICANCE_LEVEL, (Number)d2, 0, 0.5);
        }
        return this.gTest(dArray, lArray) < d2;
    }

    private double entropy(long[][] lArray) {
        int n;
        int n2;
        double d2 = 0.0;
        double d3 = 0.0;
        for (n2 = 0; n2 < lArray.length; ++n2) {
            for (n = 0; n < lArray[n2].length; ++n) {
                d3 += (double)lArray[n2][n];
            }
        }
        for (n2 = 0; n2 < lArray.length; ++n2) {
            for (n = 0; n < lArray[n2].length; ++n) {
                double d4;
                if (lArray[n2][n] == 0L) continue;
                double d5 = d4 = (double)lArray[n2][n] / d3;
                d2 += d5 * FastMath.log(d5);
            }
        }
        return -d2;
    }

    private double entropy(long[] lArray) {
        int n;
        double d2 = 0.0;
        double d3 = 0.0;
        for (n = 0; n < lArray.length; ++n) {
            d3 += (double)lArray[n];
        }
        for (n = 0; n < lArray.length; ++n) {
            double d4;
            if (lArray[n] == 0L) continue;
            double d5 = d4 = (double)lArray[n] / d3;
            d2 += d5 * FastMath.log(d5);
        }
        return -d2;
    }

    public double gDataSetsComparison(long[] lArray, long[] lArray2) {
        if (lArray.length < 2) {
            throw new DimensionMismatchException(lArray.length, 2);
        }
        if (lArray.length != lArray2.length) {
            throw new DimensionMismatchException(lArray.length, lArray2.length);
        }
        MathArrays.checkNonNegative(lArray);
        MathArrays.checkNonNegative(lArray2);
        long l = 0L;
        long l2 = 0L;
        long[] lArray3 = new long[lArray.length];
        long[][] lArray4 = new long[2][lArray.length];
        for (int i2 = 0; i2 < lArray.length; ++i2) {
            if (lArray[i2] == 0L && lArray2[i2] == 0L) {
                throw new ZeroException((Localizable)LocalizedFormats.OBSERVED_COUNTS_BOTTH_ZERO_FOR_ENTRY, i2);
            }
            l += lArray[i2];
            l2 += lArray2[i2];
            lArray3[i2] = lArray[i2] + lArray2[i2];
            lArray4[0][i2] = lArray[i2];
            lArray4[1][i2] = lArray2[i2];
        }
        if (l == 0L || l2 == 0L) {
            throw new ZeroException();
        }
        long[] lArray5 = new long[]{l, l2};
        double d2 = (double)l + (double)l2;
        return d2 * 2.0 * (this.entropy(lArray5) + this.entropy(lArray3) - this.entropy(lArray4));
    }

    public double rootLogLikelihoodRatio(long l, long l2, long l3, long l4) {
        double d2 = this.gDataSetsComparison(new long[]{l, l2}, new long[]{l3, l4});
        double d3 = FastMath.sqrt(d2);
        if ((double)l / (double)(l + l2) < (double)l3 / (double)(l3 + l4)) {
            d3 = -d3;
        }
        return d3;
    }

    public double gTestDataSetsComparison(long[] lArray, long[] lArray2) {
        ChiSquaredDistribution chiSquaredDistribution = new ChiSquaredDistribution(null, (double)lArray.length - 1.0);
        return 1.0 - chiSquaredDistribution.cumulativeProbability(this.gDataSetsComparison(lArray, lArray2));
    }

    public boolean gTestDataSetsComparison(long[] lArray, long[] lArray2, double d2) {
        if (d2 <= 0.0 || d2 > 0.5) {
            throw new OutOfRangeException((Localizable)LocalizedFormats.OUT_OF_BOUND_SIGNIFICANCE_LEVEL, (Number)d2, 0, 0.5);
        }
        return this.gTestDataSetsComparison(lArray, lArray2) < d2;
    }
}

