/*
 * Decompiled with CFR 0.152.
 */
package games.aquastudios.aquaclient.shaded.apache.commons.math3.stat.inference;

import games.aquastudios.aquaclient.shaded.apache.commons.math3.distribution.ChiSquaredDistribution;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.exception.DimensionMismatchException;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.exception.OutOfRangeException;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.exception.ZeroException;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.exception.util.Localizable;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.exception.util.LocalizedFormats;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.util.FastMath;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.util.MathArrays;

public class ChiSquareTest {
    public double chiSquare(double[] dArray, long[] lArray) {
        if (dArray.length < 2) {
            throw new DimensionMismatchException(dArray.length, 2);
        }
        if (dArray.length != lArray.length) {
            throw new DimensionMismatchException(dArray.length, lArray.length);
        }
        MathArrays.checkPositive(dArray);
        MathArrays.checkNonNegative(lArray);
        double d2 = 0.0;
        double d3 = 0.0;
        for (int i2 = 0; i2 < lArray.length; ++i2) {
            d2 += dArray[i2];
            d3 += (double)lArray[i2];
        }
        double d4 = 1.0;
        boolean bl = false;
        if (FastMath.abs(d2 - d3) > 1.0E-5) {
            d4 = d3 / d2;
            bl = true;
        }
        double d5 = 0.0;
        for (int i3 = 0; i3 < lArray.length; ++i3) {
            double d6;
            if (bl) {
                double d7 = d6 = (double)lArray[i3] - d4 * dArray[i3];
                d5 += d7 * d7 / (d4 * dArray[i3]);
                continue;
            }
            double d8 = d6 = (double)lArray[i3] - dArray[i3];
            d5 += d8 * d8 / dArray[i3];
        }
        return d5;
    }

    public double chiSquareTest(double[] dArray, long[] lArray) {
        ChiSquaredDistribution chiSquaredDistribution = new ChiSquaredDistribution(null, (double)dArray.length - 1.0);
        return 1.0 - chiSquaredDistribution.cumulativeProbability(this.chiSquare(dArray, lArray));
    }

    public boolean chiSquareTest(double[] dArray, long[] lArray, double d2) {
        if (d2 <= 0.0 || d2 > 0.5) {
            throw new OutOfRangeException((Localizable)LocalizedFormats.OUT_OF_BOUND_SIGNIFICANCE_LEVEL, (Number)d2, 0, 0.5);
        }
        return this.chiSquareTest(dArray, lArray) < d2;
    }

    public double chiSquare(long[][] lArray) {
        this.checkArray(lArray);
        int n = lArray.length;
        int n2 = lArray[0].length;
        double[] dArray = new double[n];
        double[] dArray2 = new double[n2];
        double d2 = 0.0;
        for (int i2 = 0; i2 < n; ++i2) {
            for (int i3 = 0; i3 < n2; ++i3) {
                int n3 = i2;
                dArray[n3] = dArray[n3] + (double)lArray[i2][i3];
                int n4 = i3;
                dArray2[n4] = dArray2[n4] + (double)lArray[i2][i3];
                d2 += (double)lArray[i2][i3];
            }
        }
        double d3 = 0.0;
        for (int i4 = 0; i4 < n; ++i4) {
            for (int i5 = 0; i5 < n2; ++i5) {
                double d4 = dArray[i4] * dArray2[i5] / d2;
                d3 += ((double)lArray[i4][i5] - d4) * ((double)lArray[i4][i5] - d4) / d4;
            }
        }
        return d3;
    }

    public double chiSquareTest(long[][] lArray) {
        this.checkArray(lArray);
        double d2 = ((double)lArray.length - 1.0) * ((double)lArray[0].length - 1.0);
        ChiSquaredDistribution chiSquaredDistribution = new ChiSquaredDistribution(d2);
        return 1.0 - chiSquaredDistribution.cumulativeProbability(this.chiSquare(lArray));
    }

    public boolean chiSquareTest(long[][] lArray, double d2) {
        if (d2 <= 0.0 || d2 > 0.5) {
            throw new OutOfRangeException((Localizable)LocalizedFormats.OUT_OF_BOUND_SIGNIFICANCE_LEVEL, (Number)d2, 0, 0.5);
        }
        return this.chiSquareTest(lArray) < d2;
    }

    public double chiSquareDataSetsComparison(long[] lArray, long[] lArray2) {
        if (lArray.length < 2) {
            throw new DimensionMismatchException(lArray.length, 2);
        }
        if (lArray.length != lArray2.length) {
            throw new DimensionMismatchException(lArray.length, lArray2.length);
        }
        MathArrays.checkNonNegative(lArray);
        MathArrays.checkNonNegative(lArray2);
        long l = 0L;
        long l2 = 0L;
        double d2 = 0.0;
        for (int i2 = 0; i2 < lArray.length; ++i2) {
            l += lArray[i2];
            l2 += lArray2[i2];
        }
        if (l == 0L || l2 == 0L) {
            throw new ZeroException();
        }
        boolean bl = l != l2;
        if (bl) {
            d2 = FastMath.sqrt((double)l / (double)l2);
        }
        double d3 = 0.0;
        for (int i3 = 0; i3 < lArray.length; ++i3) {
            if (lArray[i3] == 0L && lArray2[i3] == 0L) {
                throw new ZeroException((Localizable)LocalizedFormats.OBSERVED_COUNTS_BOTTH_ZERO_FOR_ENTRY, i3);
            }
            double d4 = lArray[i3];
            double d5 = lArray2[i3];
            double d6 = bl ? d4 / d2 - d5 * d2 : d4 - d5;
            double d7 = d6;
            d3 += d7 * d7 / (d4 + d5);
        }
        return d3;
    }

    public double chiSquareTestDataSetsComparison(long[] lArray, long[] lArray2) {
        ChiSquaredDistribution chiSquaredDistribution = new ChiSquaredDistribution(null, (double)lArray.length - 1.0);
        return 1.0 - chiSquaredDistribution.cumulativeProbability(this.chiSquareDataSetsComparison(lArray, lArray2));
    }

    public boolean chiSquareTestDataSetsComparison(long[] lArray, long[] lArray2, double d2) {
        if (d2 <= 0.0 || d2 > 0.5) {
            throw new OutOfRangeException((Localizable)LocalizedFormats.OUT_OF_BOUND_SIGNIFICANCE_LEVEL, (Number)d2, 0, 0.5);
        }
        return this.chiSquareTestDataSetsComparison(lArray, lArray2) < d2;
    }

    private void checkArray(long[][] lArray) {
        if (lArray.length < 2) {
            throw new DimensionMismatchException(lArray.length, 2);
        }
        if (lArray[0].length < 2) {
            throw new DimensionMismatchException(lArray[0].length, 2);
        }
        MathArrays.checkRectangular(lArray);
        MathArrays.checkNonNegative(lArray);
    }
}

