/*
 * Decompiled with CFR 0.152.
 */
package games.aquastudios.aquaclient.shaded.apache.commons.math3.stat.inference;

import games.aquastudios.aquaclient.shaded.apache.commons.math3.distribution.BinomialDistribution;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.exception.MathIllegalArgumentException;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.exception.MathInternalError;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.exception.NotPositiveException;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.exception.NullArgumentException;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.exception.OutOfRangeException;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.exception.util.LocalizedFormats;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.stat.inference.AlternativeHypothesis;

public class BinomialTest {
    public boolean binomialTest(int n, int n2, double d2, AlternativeHypothesis alternativeHypothesis, double d3) {
        double d4;
        double d5 = this.binomialTest(n, n2, d2, alternativeHypothesis);
        return d4 < d3;
    }

    public double binomialTest(int n, int n2, double d2, AlternativeHypothesis alternativeHypothesis) {
        if (n < 0) {
            throw new NotPositiveException(n);
        }
        if (n2 < 0) {
            throw new NotPositiveException(n2);
        }
        if (d2 < 0.0 || d2 > 1.0) {
            throw new OutOfRangeException(d2, (Number)0, 1);
        }
        if (n < n2) {
            throw new MathIllegalArgumentException(LocalizedFormats.BINOMIAL_INVALID_PARAMETERS_ORDER, n, n2);
        }
        if (alternativeHypothesis == null) {
            throw new NullArgumentException();
        }
        BinomialDistribution binomialDistribution = new BinomialDistribution(null, n, d2);
        switch (alternativeHypothesis) {
            case GREATER_THAN: {
                return 1.0 - binomialDistribution.cumulativeProbability(n2 - 1);
            }
            case LESS_THAN: {
                return binomialDistribution.cumulativeProbability(n2);
            }
            case TWO_SIDED: {
                int n3 = 0;
                double d3 = 0.0;
                do {
                    double d4;
                    double d5;
                    if ((d5 = binomialDistribution.probability(n3)) == (d4 = binomialDistribution.probability(n))) {
                        d3 += d5 * 2.0;
                        ++n3;
                        --n;
                        continue;
                    }
                    if (d5 < d4) {
                        d3 += d5;
                        ++n3;
                        continue;
                    }
                    d3 += d4;
                    --n;
                } while (n3 <= n2 && n >= n2);
                return d3;
            }
        }
        throw new MathInternalError(LocalizedFormats.OUT_OF_RANGE_SIMPLE, new Object[]{alternativeHypothesis, AlternativeHypothesis.TWO_SIDED, AlternativeHypothesis.LESS_THAN});
    }
}

