/*
 * Decompiled with CFR 0.152.
 */
package games.aquastudios.aquaclient.shaded.apache.commons.math3.stat.descriptive.summary;

import games.aquastudios.aquaclient.shaded.apache.commons.math3.stat.descriptive.AbstractStorelessUnivariateStatistic;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.util.FastMath;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.util.MathUtils;
import java.io.Serializable;

public class SumOfLogs
extends AbstractStorelessUnivariateStatistic
implements Serializable {
    private static final long serialVersionUID = -370076995648386763L;
    private int n;
    private double value;

    public SumOfLogs() {
        this.value = 0.0;
        this.n = 0;
    }

    public SumOfLogs(SumOfLogs sumOfLogs) {
        SumOfLogs.copy(sumOfLogs, this);
    }

    public void increment(double d2) {
        this.value += FastMath.log(d2);
        ++this.n;
    }

    public double getResult() {
        return this.value;
    }

    public long getN() {
        return this.n;
    }

    public void clear() {
        this.value = 0.0;
        this.n = 0;
    }

    public double evaluate(double[] dArray, int n, int n2) {
        double d2 = Double.NaN;
        if (this.test(dArray, n, n2, true)) {
            d2 = 0.0;
            for (int i2 = n; i2 < n + n2; ++i2) {
                d2 += FastMath.log(dArray[i2]);
            }
        }
        return d2;
    }

    public SumOfLogs copy() {
        SumOfLogs sumOfLogs = new SumOfLogs();
        SumOfLogs.copy(this, sumOfLogs);
        return sumOfLogs;
    }

    public static void copy(SumOfLogs sumOfLogs, SumOfLogs sumOfLogs2) {
        MathUtils.checkNotNull(sumOfLogs);
        MathUtils.checkNotNull(sumOfLogs2);
        sumOfLogs2.setData(sumOfLogs.getDataRef());
        sumOfLogs2.n = sumOfLogs.n;
        sumOfLogs2.value = sumOfLogs.value;
    }
}

