/*
 * Decompiled with CFR 0.152.
 */
package games.aquastudios.aquaclient.shaded.apache.commons.math3.stat.descriptive.summary;

import games.aquastudios.aquaclient.shaded.apache.commons.math3.stat.descriptive.AbstractStorelessUnivariateStatistic;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.util.MathUtils;
import java.io.Serializable;

public class Sum
extends AbstractStorelessUnivariateStatistic
implements Serializable {
    private static final long serialVersionUID = -8231831954703408316L;
    private long n;
    private double value;

    public Sum() {
        this.n = 0L;
        this.value = 0.0;
    }

    public Sum(Sum sum) {
        Sum.copy(sum, this);
    }

    public void increment(double d2) {
        this.value += d2;
        ++this.n;
    }

    public double getResult() {
        return this.value;
    }

    public long getN() {
        return this.n;
    }

    public void clear() {
        this.value = 0.0;
        this.n = 0L;
    }

    public double evaluate(double[] dArray, int n, int n2) {
        double d2 = Double.NaN;
        if (this.test(dArray, n, n2, true)) {
            d2 = 0.0;
            for (int i2 = n; i2 < n + n2; ++i2) {
                d2 += dArray[i2];
            }
        }
        return d2;
    }

    public double evaluate(double[] dArray, double[] dArray2, int n, int n2) {
        double d2 = Double.NaN;
        if (this.test(dArray, dArray2, n, n2, true)) {
            d2 = 0.0;
            for (int i2 = n; i2 < n + n2; ++i2) {
                d2 += dArray[i2] * dArray2[i2];
            }
        }
        return d2;
    }

    public double evaluate(double[] dArray, double[] dArray2) {
        return this.evaluate(dArray, dArray2, 0, dArray.length);
    }

    public Sum copy() {
        Sum sum = new Sum();
        Sum.copy(this, sum);
        return sum;
    }

    public static void copy(Sum sum, Sum sum2) {
        MathUtils.checkNotNull(sum);
        MathUtils.checkNotNull(sum2);
        sum2.setData(sum.getDataRef());
        sum2.n = sum.n;
        sum2.value = sum.value;
    }
}

