/*
 * Decompiled with CFR 0.152.
 */
package games.aquastudios.aquaclient.shaded.apache.commons.math3.stat.descriptive.rank;

import games.aquastudios.aquaclient.shaded.apache.commons.math3.exception.MathUnsupportedOperationException;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.exception.OutOfRangeException;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.exception.util.Localizable;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.exception.util.LocalizedFormats;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.stat.descriptive.AbstractUnivariateStatistic;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.stat.descriptive.rank.Percentile$EstimationType;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.stat.ranking.NaNStrategy;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.util.KthSelector;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.util.MathArrays;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.util.MathUtils;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.util.MedianOf3PivotingStrategy;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.util.PivotingStrategyInterface;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.util.Precision;
import java.io.Serializable;
import java.util.Arrays;
import java.util.BitSet;

public class Percentile
extends AbstractUnivariateStatistic
implements Serializable {
    private static final long serialVersionUID = -8091216485095130416L;
    private static final int MAX_CACHED_LEVELS = 10;
    private static final int PIVOTS_HEAP_LENGTH = 512;
    private final KthSelector kthSelector;
    private final Percentile$EstimationType estimationType;
    private final NaNStrategy nanStrategy;
    private double quantile;
    private int[] cachedPivots;

    public Percentile() {
        this(50.0);
    }

    public Percentile(double d2) {
        this(d2, Percentile$EstimationType.LEGACY, NaNStrategy.REMOVED, new KthSelector(new MedianOf3PivotingStrategy()));
    }

    public Percentile(Percentile percentile) {
        MathUtils.checkNotNull(percentile);
        this.estimationType = percentile.getEstimationType();
        this.nanStrategy = percentile.getNaNStrategy();
        this.kthSelector = percentile.getKthSelector();
        ((AbstractUnivariateStatistic)this).setData(percentile.getDataRef());
        if (percentile.cachedPivots != null) {
            System.arraycopy(percentile.cachedPivots, 0, this.cachedPivots, 0, percentile.cachedPivots.length);
        }
        this.setQuantile(percentile.quantile);
    }

    protected Percentile(double d2, Percentile$EstimationType percentile$EstimationType, NaNStrategy naNStrategy, KthSelector kthSelector) {
        this.setQuantile(d2);
        this.cachedPivots = null;
        MathUtils.checkNotNull((Object)percentile$EstimationType);
        MathUtils.checkNotNull((Object)naNStrategy);
        MathUtils.checkNotNull(kthSelector);
        this.estimationType = percentile$EstimationType;
        this.nanStrategy = naNStrategy;
        this.kthSelector = kthSelector;
    }

    public void setData(double[] dArray) {
        if (dArray == null) {
            this.cachedPivots = null;
        } else {
            this.cachedPivots = new int[512];
            Arrays.fill(this.cachedPivots, -1);
        }
        super.setData(dArray);
    }

    public void setData(double[] dArray, int n, int n2) {
        if (dArray == null) {
            this.cachedPivots = null;
        } else {
            this.cachedPivots = new int[512];
            Arrays.fill(this.cachedPivots, -1);
        }
        super.setData(dArray, n, n2);
    }

    public double evaluate(double d2) {
        Percentile percentile = this;
        return percentile.evaluate(percentile.getDataRef(), d2);
    }

    public double evaluate(double[] dArray, double d2) {
        this.test(dArray, 0, 0);
        return this.evaluate(dArray, 0, dArray.length, d2);
    }

    public double evaluate(double[] dArray, int n, int n2) {
        return this.evaluate(dArray, n, n2, this.quantile);
    }

    public double evaluate(double[] objectArray, int n, int n2, double d2) {
        this.test((double[])objectArray, n, n2);
        if (d2 > 100.0 || d2 <= 0.0) {
            throw new OutOfRangeException((Localizable)LocalizedFormats.OUT_OF_BOUNDS_QUANTILE_VALUE, (Number)d2, 0, 100);
        }
        if (n2 == 0) {
            return Double.NaN;
        }
        if (n2 == 1) {
            return objectArray[n];
        }
        double[] dArray = this.getWorkArray((double[])objectArray, n, n2);
        objectArray = this.getPivots((double[])objectArray);
        if (dArray.length == 0) {
            return Double.NaN;
        }
        return this.estimationType.evaluate(dArray, (int[])objectArray, d2, this.kthSelector);
    }

    @Deprecated
    int medianOf3(double[] dArray, int n, int n2) {
        return new MedianOf3PivotingStrategy().pivotIndex(dArray, n, n2);
    }

    public double getQuantile() {
        return this.quantile;
    }

    public void setQuantile(double d2) {
        if (d2 <= 0.0 || d2 > 100.0) {
            throw new OutOfRangeException((Localizable)LocalizedFormats.OUT_OF_BOUNDS_QUANTILE_VALUE, (Number)d2, 0, 100);
        }
        this.quantile = d2;
    }

    public Percentile copy() {
        return new Percentile(this);
    }

    @Deprecated
    public static void copy(Percentile percentile, Percentile percentile2) {
        throw new MathUnsupportedOperationException();
    }

    protected double[] getWorkArray(double[] dArray, int n, int n2) {
        if (dArray == this.getDataRef()) {
            dArray = this.getDataRef();
        } else {
            switch (this.nanStrategy) {
                case MAXIMAL: {
                    dArray = Percentile.replaceAndSlice(dArray, n, n2, Double.NaN, Double.POSITIVE_INFINITY);
                    break;
                }
                case MINIMAL: {
                    dArray = Percentile.replaceAndSlice(dArray, n, n2, Double.NaN, Double.NEGATIVE_INFINITY);
                    break;
                }
                case REMOVED: {
                    dArray = Percentile.removeAndSlice(dArray, n, n2, Double.NaN);
                    break;
                }
                case FAILED: {
                    dArray = Percentile.copyOf(dArray, n, n2);
                    MathArrays.checkNotNaN(dArray);
                    break;
                }
                default: {
                    dArray = Percentile.copyOf(dArray, n, n2);
                }
            }
        }
        return dArray;
    }

    private static double[] copyOf(double[] dArray, int n, int n2) {
        MathArrays.verifyValues(dArray, n, n2);
        int n3 = n;
        return MathArrays.copyOfRange(dArray, n3, n3 + n2);
    }

    private static double[] replaceAndSlice(double[] dArray, int n, int n2, double d2, double d3) {
        dArray = Percentile.copyOf(dArray, n, n2);
        for (n = 0; n < n2; ++n) {
            dArray[n] = Precision.equalsIncludingNaN(d2, dArray[n]) ? d3 : dArray[n];
        }
        return dArray;
    }

    private static double[] removeAndSlice(double[] dArray, int n, int n2, double d2) {
        double[] dArray2;
        int n3;
        MathArrays.verifyValues(dArray, n, n2);
        BitSet bitSet = new BitSet(n2);
        for (n3 = n; n3 < n + n2; ++n3) {
            if (!Precision.equalsIncludingNaN(d2, dArray[n3])) continue;
            bitSet.set(n3 - n);
        }
        if (bitSet.isEmpty()) {
            dArray2 = Percentile.copyOf(dArray, n, n2);
        } else if (bitSet.cardinality() == n2) {
            dArray2 = new double[]{};
        } else {
            int n4;
            dArray2 = new double[n2 - bitSet.cardinality()];
            n3 = n;
            int n5 = 0;
            int n6 = 0;
            while ((n4 = bitSet.nextSetBit(n6)) != -1) {
                n6 = n4 - n6;
                System.arraycopy(dArray, n3, dArray2, n5, n6);
                n5 += n6;
                n6 = bitSet.nextClearBit(n4);
                n3 = n + n6;
            }
            if (n3 < n + n2) {
                System.arraycopy(dArray, n3, dArray2, n5, n + n2 - n3);
            }
        }
        return dArray2;
    }

    private int[] getPivots(double[] objectArray) {
        if (objectArray == this.getDataRef()) {
            objectArray = this.cachedPivots;
        } else {
            int[] nArray = new int[512];
            objectArray = nArray;
            Arrays.fill(nArray, -1);
        }
        return objectArray;
    }

    public Percentile$EstimationType getEstimationType() {
        return this.estimationType;
    }

    public Percentile withEstimationType(Percentile$EstimationType percentile$EstimationType) {
        return new Percentile(this.quantile, percentile$EstimationType, this.nanStrategy, this.kthSelector);
    }

    public NaNStrategy getNaNStrategy() {
        return this.nanStrategy;
    }

    public Percentile withNaNStrategy(NaNStrategy naNStrategy) {
        return new Percentile(this.quantile, this.estimationType, naNStrategy, this.kthSelector);
    }

    public KthSelector getKthSelector() {
        return this.kthSelector;
    }

    public PivotingStrategyInterface getPivotingStrategy() {
        return this.kthSelector.getPivotingStrategy();
    }

    public Percentile withKthSelector(KthSelector kthSelector) {
        return new Percentile(this.quantile, this.estimationType, this.nanStrategy, kthSelector);
    }
}

