/*
 * Decompiled with CFR 0.152.
 */
package games.aquastudios.aquaclient.shaded.apache.commons.math3.stat.descriptive.rank;

import games.aquastudios.aquaclient.shaded.apache.commons.math3.exception.OutOfRangeException;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.exception.util.Localizable;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.exception.util.LocalizedFormats;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.stat.descriptive.AbstractStorelessUnivariateStatistic;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.stat.descriptive.StorelessUnivariateStatistic;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.stat.descriptive.rank.PSquarePercentile$FixedCapacityList;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.stat.descriptive.rank.PSquarePercentile$Markers;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.stat.descriptive.rank.PSquarePercentile$PSquareMarkers;
import java.io.Serializable;
import java.text.DecimalFormat;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PSquarePercentile
extends AbstractStorelessUnivariateStatistic
implements StorelessUnivariateStatistic,
Serializable {
    private static final int PSQUARE_CONSTANT = 5;
    private static final double DEFAULT_QUANTILE_DESIRED = 50.0;
    private static final long serialVersionUID = 2283912083175715479L;
    private static final DecimalFormat DECIMAL_FORMAT = new DecimalFormat("00.00");
    private final List<Double> initialFive = new PSquarePercentile$FixedCapacityList<Double>(5);
    private final double quantile;
    private transient double lastObservation;
    private PSquarePercentile$PSquareMarkers markers = null;
    private double pValue = Double.NaN;
    private long countOfObservations;

    public PSquarePercentile(double d2) {
        if (d2 > 100.0 || d2 < 0.0) {
            throw new OutOfRangeException((Localizable)LocalizedFormats.OUT_OF_RANGE, (Number)d2, 0, 100);
        }
        this.quantile = d2 / 100.0;
    }

    PSquarePercentile() {
        this(50.0);
    }

    @Override
    public int hashCode() {
        double d2 = ((AbstractStorelessUnivariateStatistic)this).getResult();
        d2 = Double.isNaN(d2) ? 37.0 : d2;
        double d3 = this.markers == null ? 0.0 : (double)this.markers.hashCode();
        double[] dArray = new double[]{d2, this.quantile, d3, this.countOfObservations};
        return Arrays.hashCode(dArray);
    }

    @Override
    public boolean equals(Object object) {
        boolean bl;
        block4: {
            boolean bl2;
            block3: {
                block2: {
                    bl = false;
                    if (this != object) break block2;
                    bl2 = true;
                    break block3;
                }
                if (object == null || !(object instanceof PSquarePercentile)) break block4;
                object = (PSquarePercentile)object;
                bl = this.markers != null && ((PSquarePercentile)object).markers != null;
                boolean bl3 = this.markers == null && ((PSquarePercentile)object).markers == null;
                bl = bl ? this.markers.equals(((PSquarePercentile)object).markers) : bl3;
                bl2 = bl && this.getN() == ((PSquarePercentile)object).getN();
            }
            bl = bl2;
        }
        return bl;
    }

    @Override
    public void increment(double d2) {
        ++this.countOfObservations;
        this.lastObservation = d2;
        if (this.markers == null) {
            if (this.initialFive.add(d2)) {
                Collections.sort(this.initialFive);
                this.pValue = this.initialFive.get((int)(this.quantile * (double)(this.initialFive.size() - 1)));
                return;
            }
            this.markers = PSquarePercentile.newMarkers(this.initialFive, this.quantile);
        }
        this.pValue = this.markers.processDataPoint(d2);
    }

    public String toString() {
        if (this.markers == null) {
            return String.format("obs=%s pValue=%s", DECIMAL_FORMAT.format(this.lastObservation), DECIMAL_FORMAT.format(this.pValue));
        }
        return String.format("obs=%s markers=%s", DECIMAL_FORMAT.format(this.lastObservation), this.markers.toString());
    }

    @Override
    public long getN() {
        return this.countOfObservations;
    }

    @Override
    public StorelessUnivariateStatistic copy() {
        PSquarePercentile pSquarePercentile = new PSquarePercentile(100.0 * this.quantile);
        if (this.markers != null) {
            pSquarePercentile.markers = (PSquarePercentile$PSquareMarkers)this.markers.clone();
        }
        pSquarePercentile.countOfObservations = this.countOfObservations;
        pSquarePercentile.pValue = this.pValue;
        pSquarePercentile.initialFive.clear();
        pSquarePercentile.initialFive.addAll(this.initialFive);
        return pSquarePercentile;
    }

    public double quantile() {
        return this.quantile;
    }

    @Override
    public void clear() {
        this.markers = null;
        this.initialFive.clear();
        this.countOfObservations = 0L;
        this.pValue = Double.NaN;
    }

    @Override
    public double getResult() {
        if (Double.compare(this.quantile, 1.0) == 0) {
            this.pValue = this.maximum();
        } else if (Double.compare(this.quantile, 0.0) == 0) {
            this.pValue = this.minimum();
        }
        return this.pValue;
    }

    private double maximum() {
        double d2 = Double.NaN;
        if (this.markers != null) {
            d2 = this.markers.height(5);
        } else if (!this.initialFive.isEmpty()) {
            d2 = this.initialFive.get(this.initialFive.size() - 1);
        }
        return d2;
    }

    private double minimum() {
        double d2 = Double.NaN;
        if (this.markers != null) {
            d2 = this.markers.height(1);
        } else if (!this.initialFive.isEmpty()) {
            d2 = this.initialFive.get(0);
        }
        return d2;
    }

    public static PSquarePercentile$PSquareMarkers newMarkers(List<Double> list, double d2) {
        return new PSquarePercentile$Markers(list, d2, null);
    }
}

